/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.skyblock.dungeon.preview.RoomPreviewServer;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonPlayerManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import de.hysky.skyblocker.utils.ws.Service;
import de.hysky.skyblocker.utils.ws.WsMessageHandler;
import de.hysky.skyblocker.utils.ws.message.DungeonMimicKilledMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonPrinceKilledMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonRoomHideWaypointMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonRoomMatchMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonRoomSecretCountMessage;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_310;
import org.joml.Vector2ic;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class SecretSync {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<DungeonsConfig.SecretSync> CONFIG = () -> SkyblockerConfigManager.get().dungeons.secretSync;

    @Init
    public static void init() {
        DungeonEvents.ROOM_MATCHED.register(SecretSync::syncRoomMatch);
        DungeonEvents.SECRET_COUNT_UPDATED.register(SecretSync::syncSecretCount);
        DungeonEvents.SECRET_FOUND.register(SecretSync::syncSecretFound);
    }

    public static boolean checkSender(UUID uuid) {
        if (Arrays.stream(DungeonPlayerManager.getPlayers()).filter(Objects::nonNull).anyMatch(player -> uuid.equals(player.uuid()))) {
            return true;
        }
        LOGGER.error("[Skyblocker Dungeon Secret Sync] Received a message from a player not in the Dungeons run: {}", (Object)uuid);
        return false;
    }

    public static @Nullable Room getRoomByName(String roomName) {
        return DungeonManager.getRoomsStream().filter(Room::isMatched).filter(rm -> rm.getName().equals(roomName)).findAny().orElse(null);
    }

    public static void syncRoomMatch(Room room) {
        if (SecretSync.CLIENT.field_1724 == null || room.fromWebsocket) {
            return;
        }
        List<Vector2ic> segments = room.getSegments().stream().toList();
        WsMessageHandler.sendServerMessage(Service.DUNGEON_SECRETS, new DungeonRoomMatchMessage(SecretSync.CLIENT.field_1724.method_5667(), room.getType(), room.getShape(), room.getDirection(), room.getName(), segments));
    }

    public static void handleRoomMatch(DungeonRoomMatchMessage msg) {
        if (!SecretSync.CONFIG.get().receiveRoomMatch || !SecretSync.checkSender(msg.sender())) {
            return;
        }
        if (DungeonManager.getRoomsStream().count() > 36L || msg.pos().size() > 4) {
            return;
        }
        if (DungeonManager.getRoomMetadata(msg.room()) == null) {
            LOGGER.error("[Skyblocker Dungeons Secret Sync] Received an invalid room over the websocket, msg: {}", (Object)msg);
            return;
        }
        if (DungeonManager.checkIfSegmentsExist(msg.pos())) {
            return;
        }
        Set<Vector2ic> segments = Set.of((Vector2ic[])msg.pos().toArray(Vector2ic[]::new));
        IntSortedSet segmentsX = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(segments.stream().mapToInt(Vector2ic::x).toArray()));
        IntSortedSet segmentsY = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(segments.stream().mapToInt(Vector2ic::y).toArray()));
        if (Room.determineShape(msg.roomType(), segments, segmentsX, segmentsY) != msg.shape()) {
            LOGGER.error("[Skyblocker Dungeons Secret Sync] Received a room with an invalid shape!, msg: {}", (Object)msg);
            return;
        }
        Room newRoom = new Room(msg.roomType(), msg.shape(), msg.direction(), msg.room(), segments, segmentsX, segmentsY);
        DungeonManager.addRoomFromWs(newRoom);
        LOGGER.info("[Skyblocker Dungeon Secret Sync] Added room {}", (Object)msg.room());
    }

    public static void syncSecretCount(Room room, boolean fromWS) {
        if (SecretSync.CLIENT.field_1724 == null || fromWS) {
            return;
        }
        WsMessageHandler.sendServerMessage(Service.DUNGEON_SECRETS, new DungeonRoomSecretCountMessage(SecretSync.CLIENT.field_1724.method_5667(), room.getName(), room.getFoundSecretCount()));
    }

    public static void handleSecretCountUpdate(DungeonRoomSecretCountMessage msg) {
        if (!SecretSync.CONFIG.get().receiveRoomSecretCount || !SecretSync.checkSender(msg.sender())) {
            return;
        }
        Room room = SecretSync.getRoomByName(msg.roomName());
        if (room == null || room.secretsFound >= msg.secretCount() || msg.secretCount() > room.getSecretCount()) {
            return;
        }
        room.secretsFound = msg.secretCount();
        room.secretCountOutdated = false;
        ((DungeonEvents.SecretCountUpdate)DungeonEvents.SECRET_COUNT_UPDATED.invoker()).onSecretCountUpdate(room, true);
    }

    public static void syncSecretFound(Room room, SecretWaypoint waypoint) {
        if (SecretSync.CLIENT.field_1724 == null || RoomPreviewServer.isActive) {
            return;
        }
        WsMessageHandler.sendServerMessage(Service.DUNGEON_SECRETS, new DungeonRoomHideWaypointMessage(SecretSync.CLIENT.field_1724.method_5667(), room.getName(), waypoint.hashCode()));
    }

    public static void handleHideWaypoint(DungeonRoomHideWaypointMessage msg) {
        if (!SecretSync.checkSender(msg.sender()) || !SecretSync.CONFIG.get().hideReceivedWaypoints) {
            return;
        }
        Room room = SecretSync.getRoomByName(msg.roomName());
        if (room == null) {
            return;
        }
        int secretIndex = room.getIndexByWaypointHash(msg.waypointHash());
        if (secretIndex == -1) {
            return;
        }
        room.markSecrets(secretIndex, true);
        LOGGER.info("[Skyblocker Dungeon Secret Sync] Hiding waypoints for secret #{} in room {}", (Object)secretIndex, (Object)msg.roomName());
    }

    public static void syncMimicKilled() {
        if (SecretSync.CLIENT.field_1724 == null) {
            return;
        }
        WsMessageHandler.sendServerMessage(Service.DUNGEON_SECRETS, new DungeonMimicKilledMessage(SecretSync.CLIENT.field_1724.method_5667()));
    }

    public static void handleMimicKilled(DungeonMimicKilledMessage msg) {
        if (!SecretSync.checkSender(msg.sender())) {
            return;
        }
        DungeonScore.onMimicKill();
        LOGGER.info("[Skyblocker Dungeon Secret Sync] Mimic killed!");
    }

    public static void syncPrinceKilled() {
        if (SecretSync.CLIENT.field_1724 == null) {
            return;
        }
        WsMessageHandler.sendServerMessage(Service.DUNGEON_SECRETS, new DungeonPrinceKilledMessage(SecretSync.CLIENT.field_1724.method_5667()));
    }

    public static void handlePrinceKilled(DungeonPrinceKilledMessage msg) {
        if (!SecretSync.checkSender(msg.sender())) {
            return;
        }
        DungeonScore.onPrinceKill(false);
        LOGGER.info("[Skyblocker Dungeon Secret Sync] Prince killed!");
    }
}

