/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.google.gson.JsonObject;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.waypoint.DistancedNamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_7485;
import net.minecraft.class_8824;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretWaypoint
extends DistancedNamedWaypoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretWaypoint.class);
    public static final Codec<SecretWaypoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("secretIndex").forGetter(secretWaypoint -> secretWaypoint.secretIndex), (App)Category.CODEC.fieldOf("category").forGetter(secretWaypoint -> secretWaypoint.category), (App)class_8824.field_46597.fieldOf("name").forGetter(secretWaypoint -> secretWaypoint.name), (App)class_2338.field_25064.fieldOf("pos").forGetter(secretWaypoint -> secretWaypoint.pos)).apply((Applicative)instance, SecretWaypoint::new));
    public static final Codec<List<SecretWaypoint>> LIST_CODEC = CODEC.listOf();
    static final List<String> SECRET_ITEMS = List.of("Candycomb", "Decoy", "Defuse Kit", "Dungeon Chest Key", "Healing VIII", "Inflatable Jerry", "Spirit Leap", "Training Weights", "Trap", "Treasure Talisman");
    private static final Supplier<DungeonsConfig.SecretWaypoints> CONFIG = () -> SkyblockerConfigManager.get().dungeons.secretWaypoints;
    static final Supplier<Waypoint.Type> TYPE_SUPPLIER = () -> SecretWaypoint.CONFIG.get().waypointType;
    public final int secretIndex;
    public final Category category;

    public SecretWaypoint(int secretIndex, Category category, String name, class_2338 pos) {
        this(secretIndex, category, class_2561.method_30163((String)name), pos);
    }

    SecretWaypoint(int secretIndex, Category category, class_2561 name, class_2338 pos) {
        super(pos, name, TYPE_SUPPLIER, category.colorComponents);
        this.secretIndex = secretIndex;
        this.category = category;
    }

    static ToDoubleFunction<SecretWaypoint> getSquaredDistanceToFunction(class_1297 entity) {
        return secretWaypoint -> entity.method_5707(secretWaypoint.centerPos);
    }

    static Predicate<SecretWaypoint> getRangePredicate(class_1297 entity) {
        return secretWaypoint -> entity.method_73189().method_24802((class_2374)secretWaypoint.centerPos, 16.0);
    }

    @Override
    public boolean shouldRender() {
        if (this.category.isPrince()) {
            return !DungeonScore.wasPrinceKilled() && this.category.isEnabled();
        }
        return super.shouldRender() && this.category.isEnabled();
    }

    boolean needsInteraction() {
        return this.category.needsInteraction();
    }

    boolean isLever() {
        return this.category.isLever();
    }

    boolean needsItemPickup() {
        return this.category.needsItemPickup();
    }

    boolean isBat() {
        return this.category.isBat();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!super.equals(obj)) return false;
        if (!(obj instanceof SecretWaypoint)) return false;
        SecretWaypoint other = (SecretWaypoint)obj;
        if (this.secretIndex != other.secretIndex) return false;
        if (this.category != other.category) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.secretIndex, this.category, this.name, this.pos});
    }

    @Override
    protected boolean shouldRenderName() {
        return super.shouldRenderName() && SecretWaypoint.CONFIG.get().showSecretText;
    }

    @Override
    protected class_238 getRenderBox() {
        class_238 box;
        if (SkyblockerConfigManager.get().dungeons.secretWaypoints.adaptiveBoxSize && (this.category == Category.WITHER || this.category == Category.REDSTONE_KEY) && (box = RenderHelper.getBlockBoundingBox(class_310.method_1551().field_1687, this.pos)) != null) {
            return box;
        }
        return super.getRenderBox();
    }

    SecretWaypoint relativeToActual(Room room) {
        return new SecretWaypoint(this.secretIndex, this.category, this.name, room.relativeToActual(this.pos));
    }

    public static enum Category implements class_3542
    {
        ENTRANCE("entrance", secretWaypoints -> secretWaypoints.enableEntranceWaypoints, 0, 255, 0),
        SUPERBOOM("superboom", secretWaypoints -> secretWaypoints.enableSuperboomWaypoints, 255, 0, 0),
        CHEST("chest", secretWaypoints -> secretWaypoints.enableChestWaypoints, 2, 213, 250),
        ITEM("item", secretWaypoints -> secretWaypoints.enableItemWaypoints, 2, 64, 250),
        BAT("bat", secretWaypoints -> secretWaypoints.enableBatWaypoints, 142, 66, 0),
        WITHER("wither", secretWaypoints -> secretWaypoints.enableWitherWaypoints, 30, 30, 30),
        REDSTONE_KEY("key", secretWaypoints -> secretWaypoints.enableRedstoneKeyWaypoints, 200, 30, 30),
        LEVER("lever", secretWaypoints -> secretWaypoints.enableLeverWaypoints, 250, 217, 2),
        FAIRYSOUL("fairysoul", secretWaypoints -> secretWaypoints.enableFairySoulWaypoints, 255, 85, 255),
        STONK("stonk", secretWaypoints -> secretWaypoints.enableStonkWaypoints, 146, 52, 235),
        AOTV("aotv", secretWaypoints -> secretWaypoints.enableAotvWaypoints, 252, 98, 3),
        PEARL("pearl", secretWaypoints -> secretWaypoints.enablePearlWaypoints, 57, 117, 125),
        PRINCE("prince", secretWaypoints -> secretWaypoints.enablePrinceWaypoints, 133, 21, 13),
        DEFAULT("default", secretWaypoints -> secretWaypoints.enableDefaultWaypoints, 190, 255, 252);

        public static final Codec<Category> CODEC;
        private final String name;
        private final Predicate<DungeonsConfig.SecretWaypoints> enabledPredicate;
        private final float[] colorComponents;

        private Category(String name, Predicate<DungeonsConfig.SecretWaypoints> enabledPredicate, int ... intColorComponents) {
            this.name = name;
            this.enabledPredicate = enabledPredicate;
            this.colorComponents = new float[intColorComponents.length];
            for (int i = 0; i < intColorComponents.length; ++i) {
                this.colorComponents[i] = (float)intColorComponents[i] / 255.0f;
            }
        }

        static Category get(JsonObject waypointJson) {
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)waypointJson.get("category")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(DEFAULT);
        }

        boolean needsInteraction() {
            return this == CHEST || this == WITHER || this == REDSTONE_KEY;
        }

        boolean isLever() {
            return this == LEVER;
        }

        boolean needsItemPickup() {
            return this == ITEM;
        }

        boolean isBat() {
            return this == BAT;
        }

        boolean isPrince() {
            return this == PRINCE;
        }

        boolean isEnabled() {
            return this.enabledPredicate.test(SkyblockerConfigManager.get().dungeons.secretWaypoints);
        }

        public String toString() {
            return this.name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Category::values);
        }

        static class CategoryArgumentType
        extends class_7485<Category> {
            CategoryArgumentType() {
                super(CODEC, Category::values);
            }

            static CategoryArgumentType category() {
                return new CategoryArgumentType();
            }

            static <S> Category getCategory(CommandContext<S> context, String name) {
                return (Category)((Object)context.getArgument(name, Category.class));
            }
        }
    }
}

