/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.terminal;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.terminal.TerminalSolver;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.StackDisplayModifier;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorTerminal
extends SimpleContainerSolver
implements TerminalSolver,
StackDisplayModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ColorTerminal.class.getName());
    private static final Map<String, class_1767> colorFromName = new HashMap<String, class_1767>();
    private class_1767 targetColor;
    private static final Map<class_1792, class_1767> itemColor;

    public ColorTerminal() {
        super("^Select all the ([A-Z ]+) items!$");
    }

    @Override
    public boolean isEnabled() {
        this.targetColor = null;
        return SkyblockerConfigManager.get().dungeons.terminals.solveColor;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ContainerSolver.trimEdges(slots, 6);
        String colorString = this.groups[0];
        if (this.targetColor == null) {
            this.targetColor = colorFromName.get(colorString);
            if (this.targetColor == null) {
                LOGGER.error("[Skyblocker] Couldn't find dye color corresponding to \"{}\"", (Object)colorString);
                return Collections.emptyList();
            }
        }
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (Int2ObjectMap.Entry slot : slots.int2ObjectEntrySet()) {
            class_1799 itemStack = (class_1799)slot.getValue();
            if (itemStack.method_7958() || !this.targetColor.equals((Object)itemColor.get(itemStack.method_7909()))) continue;
            highlights.add(ColorHighlight.green(slot.getIntKey()));
        }
        return highlights;
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (stack.method_7958() || !this.targetColor.equals((Object)itemColor.get(stack.method_7909()))) {
            return this.shouldBlockIncorrectClicks();
        }
        return false;
    }

    @Override
    public class_1799 modifyDisplayStack(int slotIndex, class_1799 stack) {
        return slotIndex >= 54 || this.targetColor != null && this.targetColor.equals((Object)itemColor.get(stack.method_7909())) ? stack : class_1799.field_8037;
    }

    static {
        for (class_1767 color : class_1767.values()) {
            colorFromName.put(color.method_7792().toUpperCase(Locale.ENGLISH), color);
        }
        colorFromName.put("SILVER", class_1767.field_7967);
        colorFromName.put("LIGHT BLUE", class_1767.field_7951);
        itemColor = new HashMap<class_1792, class_1767>();
        for (class_1767 color : class_1767.values()) {
            for (String item : new String[]{"dye", "wool", "stained_glass", "terracotta"}) {
                itemColor.put((class_1792)class_7923.field_41178.method_63535(class_2960.method_60656((String)(color.method_7792() + "_" + item))), color);
            }
        }
        itemColor.put(class_1802.field_8324, class_1767.field_7952);
        itemColor.put(class_1802.field_8759, class_1767.field_7966);
        itemColor.put(class_1802.field_8116, class_1767.field_7957);
        itemColor.put(class_1802.field_8794, class_1767.field_7963);
    }
}

