/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.terminal;

import com.google.common.collect.ImmutableMap;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.terminal.TerminalSolver;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public final class SameColorTerminal
extends SimpleContainerSolver
implements TerminalSolver,
SlotTextAdder {
    public static final SameColorTerminal INSTANCE = new SameColorTerminal();
    private static final class_1792[] ORDER = new class_1792[]{class_1802.field_8879, class_1802.field_8761, class_1802.field_8703, class_1802.field_8656, class_1802.field_8747};
    private static final ImmutableMap<class_1792, Integer> INDEX;
    private final Int2IntMap clickMap = new Int2IntOpenHashMap();

    private SameColorTerminal() {
        super("^Change all to same color!$");
    }

    @Override
    public boolean isEnabled() {
        this.clickMap.clear();
        return SkyblockerConfigManager.get().dungeons.terminals.solveSameColor;
    }

    private void computeClicks(Int2ObjectMap<class_1799> slots) {
        this.clickMap.clear();
        int[] counts = new int[ORDER.length];
        Int2IntOpenHashMap slotColors = new Int2IntOpenHashMap();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            class_1792 item = ((class_1799)entry.getValue()).method_7909();
            Integer idx = (Integer)INDEX.get((Object)item);
            if (idx == null) continue;
            slotColors.put(entry.getIntKey(), idx.intValue());
            int n = idx;
            counts[n] = counts[n] + 1;
        }
        if (slotColors.isEmpty()) {
            return;
        }
        int target = 0;
        for (int i = 1; i < counts.length; ++i) {
            if (counts[i] <= counts[target]) continue;
            target = i;
        }
        for (Int2IntMap.Entry entry : slotColors.int2IntEntrySet()) {
            int diffBackward;
            int slot = entry.getIntKey();
            int color = entry.getIntValue();
            int diffForward = Math.floorMod(target - color, ORDER.length);
            int clicks = diffForward <= (diffBackward = Math.floorMod(color - target, ORDER.length)) ? diffForward : -diffBackward;
            this.clickMap.put(slot, clicks);
        }
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        this.computeClicks(slots);
        return List.of();
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (this.clickMap.containsKey(slot)) {
            boolean usingCorrectButton;
            int clicks = this.clickMap.get(slot);
            if (clicks == 0) {
                return this.shouldBlockIncorrectClicks();
            }
            boolean positive = Integer.signum(clicks) == 1;
            boolean bl = usingCorrectButton = positive && button == 0 || !positive && button == 1;
            if (!usingCorrectButton) {
                return this.shouldBlockIncorrectClicks();
            }
        }
        return false;
    }

    @Override
    public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
        int clicks = this.clickMap.getOrDefault(slotId, 0);
        if (clicks == 0) {
            return List.of();
        }
        return SlotText.topLeftList((class_2561)class_2561.method_43470((String)String.valueOf(clicks)).method_27692(class_124.field_1065));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)ORDER.length);
        for (int i = 0; i < ORDER.length; ++i) {
            builder.put((Object)ORDER[i], (Object)i);
        }
        INDEX = builder.build();
    }
}

