/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.terminal;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.terminal.TerminalSolver;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.StackDisplayModifier;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public final class StartsWithTerminal
extends SimpleContainerSolver
implements TerminalSolver,
StackDisplayModifier {
    private final Int2ObjectOpenHashMap<ItemState> trackedItemStates = new Int2ObjectOpenHashMap();
    private int lastKnownScreenId = Integer.MIN_VALUE;

    public StartsWithTerminal() {
        super("^What starts with: '([A-Z])'\\?$");
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().dungeons.terminals.solveStartsWith;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ContainerSolver.trimEdges(slots, 6);
        this.setupState(slots);
        String prefix = this.groups[0];
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (Int2ObjectMap.Entry slot : slots.int2ObjectEntrySet()) {
            class_1799 stack = (class_1799)slot.getValue();
            ItemState state = (ItemState)this.trackedItemStates.getOrDefault(slot.getIntKey(), (Object)ItemState.DEFAULT);
            if (state.clicked() || !stack.method_7964().getString().startsWith(prefix)) continue;
            highlights.add(ColorHighlight.green(slot.getIntKey()));
        }
        return highlights;
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (!this.trackedItemStates.containsKey(slot) || stack == null || stack.method_7960()) {
            return this.shouldBlockIncorrectClicks();
        }
        ItemState state = (ItemState)this.trackedItemStates.get(slot);
        String prefix = this.groups[0];
        if (!stack.method_7964().getString().startsWith(prefix) || state.clicked() || this.lastKnownScreenId == screenId) {
            return this.shouldBlockIncorrectClicks();
        }
        this.trackedItemStates.put(slot, (Object)state.click());
        this.lastKnownScreenId = screenId;
        return false;
    }

    @Override
    public class_1799 modifyDisplayStack(int slotIndex, class_1799 stack) {
        return slotIndex >= 54 || stack.method_7964().getString().startsWith(this.groups[0]) ? stack : class_1799.field_8037;
    }

    private void setupState(Int2ObjectMap<class_1799> usefulSlots) {
        Predicate<Int2ObjectMap.Entry<class_1799>> notNullOrEmpty = e -> e.getValue() != null && !((class_1799)e.getValue()).method_7960();
        if (StartsWithTerminal.allEntriesMatch((ObjectSet<Int2ObjectMap.Entry<class_1799>>)usefulSlots.int2ObjectEntrySet(), notNullOrEmpty)) {
            if (this.trackedItemStates.isEmpty()) {
                for (Int2ObjectMap.Entry entry : usefulSlots.int2ObjectEntrySet()) {
                    this.trackedItemStates.put(entry.getIntKey(), (Object)ItemState.of(((class_1799)entry.getValue()).method_7909()));
                }
            } else {
                Predicate<Int2ObjectMap.Entry<class_1799>> doesItemMatch = e -> this.trackedItemStates.containsKey(e.getIntKey()) && ((ItemState)this.trackedItemStates.get(e.getIntKey())).itemMatches(((class_1799)e.getValue()).method_7909());
                if (!StartsWithTerminal.allEntriesMatch((ObjectSet<Int2ObjectMap.Entry<class_1799>>)usefulSlots.int2ObjectEntrySet(), doesItemMatch)) {
                    this.clearState();
                    this.setupState(usefulSlots);
                }
            }
        }
    }

    private void clearState() {
        this.trackedItemStates.clear();
        this.lastKnownScreenId = Integer.MIN_VALUE;
    }

    private static boolean allEntriesMatch(ObjectSet<Int2ObjectMap.Entry<class_1799>> entries, Predicate<Int2ObjectMap.Entry<class_1799>> predicate) {
        for (Int2ObjectMap.Entry entry : entries) {
            if (predicate.test((Int2ObjectMap.Entry<class_1799>)entry)) continue;
            return false;
        }
        return true;
    }

    private record ItemState(class_1792 item, boolean clicked) {
        private static final ItemState DEFAULT = new ItemState(null, false);

        boolean itemMatches(class_1792 item) {
            return this.item.equals(item);
        }

        ItemState click() {
            return new ItemState(this.item, true);
        }

        static ItemState of(class_1792 item) {
            return new ItemState(item, false);
        }
    }
}

