/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.Utils;
import io.github.moulberry.repo.NEURepoFile;
import io.github.moulberry.repo.NEURepositoryException;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_1188;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;

public class BlockBreakPrediction {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EnumMap<Location, Map<class_2248, IntIntPair>> blockStrengths = new EnumMap(Location.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern MINING_SPEED_PATTERN = Pattern.compile("Mining Speed: \u2e15(\\d+)");
    private static final Pattern BREAKING_POWER_PATTERN = Pattern.compile("Breaking Power (\\d+)");
    private static boolean newBlock = false;
    private static boolean soundPlayed = false;
    private static long currentBlockBreakTime;
    private static long startAttackingTime;
    private static boolean sentWarningMessage;

    @Init
    public static void init() {
        AttackBlockCallback.EVENT.register(BlockBreakPrediction::onBlockInteract);
        NEURepoManager.runAsyncAfterLoad(BlockBreakPrediction::loadBlockStrength);
    }

    private static class_1269 onBlockInteract(class_1657 player, class_1937 level, class_1268 interactionHand, class_2338 blockPos, class_2350 direction) {
        newBlock = true;
        startAttackingTime = System.currentTimeMillis();
        soundPlayed = false;
        return class_1269.field_5811;
    }

    public static int getBlockBreakPrediction(class_2338 pos, int progression) {
        if (BlockBreakPrediction.CLIENT.field_1724 == null || BlockBreakPrediction.CLIENT.field_1761 == null || !SkyblockerConfigManager.get().mining.blockBreakPrediction.enabled) {
            return progression;
        }
        class_239 class_2392 = BlockBreakPrediction.CLIENT.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 hitResult = (class_3965)class_2392;
            if (!hitResult.method_17777().equals((Object)pos)) {
                return progression;
            }
        } else {
            return progression;
        }
        if (newBlock) {
            newBlock = false;
            Matcher loreMatch = ItemUtils.getLoreLineIfMatch(BlockBreakPrediction.CLIENT.field_1724.method_6047(), BREAKING_POWER_PATTERN);
            if (loreMatch != null) {
                int toolBreakingPower = NumberUtils.toInt((String)loreMatch.group(1));
                currentBlockBreakTime = BlockBreakPrediction.getBreakTime(pos, toolBreakingPower);
            } else {
                currentBlockBreakTime = -1L;
            }
        }
        if (!BlockBreakPrediction.CLIENT.field_1761.method_2923()) {
            currentBlockBreakTime = -1L;
        }
        if (currentBlockBreakTime > 0L) {
            long timeElapsed = System.currentTimeMillis() - startAttackingTime;
            if (SkyblockerConfigManager.get().mining.blockBreakPrediction.playSound && !soundPlayed && (int)(timeElapsed * 10L / currentBlockBreakTime) == 10) {
                soundPlayed = true;
                BlockBreakPrediction.CLIENT.field_1724.method_5783(class_3417.field_14842, 100.0f, 1.0f);
            }
            return Math.min((int)(timeElapsed * 10L / currentBlockBreakTime), 9);
        }
        return progression;
    }

    private static int getCurrentMiningSpeed() {
        if (BlockBreakPrediction.CLIENT.field_1724 == null) {
            return -1;
        }
        Optional<Matcher> speed = PlayerListManager.getPlayerStringList().stream().map(MINING_SPEED_PATTERN::matcher).filter(Matcher::matches).findFirst();
        if (speed.isEmpty()) {
            if (!sentWarningMessage) {
                BlockBreakPrediction.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.blockBreakPrediction.enableStatsMessage")).method_27692(class_124.field_1061), false);
                sentWarningMessage = true;
            }
            return -1;
        }
        return NumberUtils.toInt((String)speed.get().group(1));
    }

    private static long getBreakTime(class_2338 pos, int toolBreakingPower) {
        if (BlockBreakPrediction.CLIENT.field_1687 == null) {
            return -1L;
        }
        class_2248 targetBlock = BlockBreakPrediction.CLIENT.field_1687.method_8320(pos).method_26204();
        if (!blockStrengths.containsKey((Object)Utils.getLocation()) || !blockStrengths.get((Object)Utils.getLocation()).containsKey(targetBlock)) {
            return -1L;
        }
        Pair blockStrengthAndBreakingPower = (Pair)blockStrengths.get((Object)Utils.getLocation()).get(targetBlock);
        if ((Integer)blockStrengthAndBreakingPower.second() > toolBreakingPower) {
            return -1L;
        }
        int blockStrength = (Integer)blockStrengthAndBreakingPower.first();
        int miningSpeed = BlockBreakPrediction.getCurrentMiningSpeed();
        return (long)(50.0f * Math.min((float)blockStrength * 30.0f / (float)miningSpeed, 6.6666665f * (float)blockStrength));
    }

    public static void addStrength(Location location, class_2248 blockId, int strength, int breakingPower) {
        blockStrengths.computeIfAbsent(location, k -> new HashMap()).put(blockId, IntIntPair.of((int)strength, (int)breakingPower));
    }

    private static void loadBlockStrength() {
        try {
            List<NEURepoFile> blocks = NEURepoManager.tree("mining/blocks").toList();
            for (NEURepoFile file : blocks) {
                if (!file.isFile()) continue;
                try {
                    InputStream stream = file.stream();
                    try {
                        BlockFile data = (BlockFile)BlockFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(new String(stream.readAllBytes()))).getOrThrow();
                        for (SkyblockBlock skyblockBlockType : data.skyblockBlocks) {
                            for (Location location : skyblockBlockType.onlyIn) {
                                if (data.name.equals("Mithril Ore")) {
                                    class_2248 block = BlockBreakPrediction.getBlockFromRepo(skyblockBlockType.itemId, skyblockBlockType.damage);
                                    if (block == class_2246.field_10423 || block == class_2246.field_10235) {
                                        BlockBreakPrediction.addStrength(location, block, 500, data.breakingPower);
                                        continue;
                                    }
                                    if (block == class_2246.field_10294) {
                                        BlockBreakPrediction.addStrength(location, block, 1500, data.breakingPower);
                                        continue;
                                    }
                                    BlockBreakPrediction.addStrength(location, block, 800, data.breakingPower);
                                    continue;
                                }
                                BlockBreakPrediction.addStrength(location, BlockBreakPrediction.getBlockFromRepo(skyblockBlockType.itemId, skyblockBlockType.damage), data.blockStrength, data.breakingPower);
                            }
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("[Skyblocker BlockBreakPredictions] Failed to load mining blocks!", (Throwable)ex);
                }
            }
        }
        catch (NEURepositoryException exception) {
            LOGGER.error("[Skyblocker BlockBreakPredictions] Failed to load mining blocks!", (Throwable)exception);
        }
    }

    public static class_2248 getBlockFromRepo(String id, int damage) {
        return Optional.ofNullable(class_1188.method_5042((String)id, (int)damage)).map(class_2960::method_12829).flatMap(arg_0 -> ((class_7922)class_7923.field_41175).method_17966(arg_0)).orElse((class_2248)class_7923.field_41175.method_63535(class_2960.method_12829((String)id)));
    }

    static {
        sentWarningMessage = false;
    }

    public record BlockFile(int blockStrength, int breakingPower, String name, List<SkyblockBlock> skyblockBlocks) {
        public static final Codec<BlockFile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("blockStrength").forGetter(BlockFile::blockStrength), (App)Codec.INT.fieldOf("breakingPower").forGetter(BlockFile::breakingPower), (App)Codec.STRING.fieldOf("name").forGetter(BlockFile::name), (App)SkyblockBlock.LIST_CODEC.fieldOf("blocks189").forGetter(BlockFile::skyblockBlocks)).apply((Applicative)instance, BlockFile::new));
    }

    public record SkyblockBlock(String itemId, int damage, List<Location> onlyIn) {
        private static final Codec<SkyblockBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("itemId").forGetter(SkyblockBlock::itemId), (App)Codec.INT.fieldOf("damage").forGetter(SkyblockBlock::damage), (App)Location.CODEC.listOf().fieldOf("onlyIn").forGetter(SkyblockBlock::onlyIn)).apply((Applicative)instance, SkyblockBlock::new));
        public static final Codec<List<SkyblockBlock>> LIST_CODEC = CODEC.listOf();
    }
}

