/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.MiningConfig;
import de.hysky.skyblocker.skyblock.dwarven.MiningLocationLabel;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.CommsWidget;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_640;

public class CommissionLabels {
    private static final Map<String, MiningLocationLabel.DwarvenCategory> DWARVEN_LOCATIONS = Arrays.stream(MiningLocationLabel.DwarvenCategory.values()).collect(Collectors.toMap(MiningLocationLabel.DwarvenCategory::toString, Function.identity()));
    private static final List<MiningLocationLabel.DwarvenEmissaries> DWARVEN_EMISSARIES = Arrays.stream(MiningLocationLabel.DwarvenEmissaries.values()).toList();
    private static final Map<String, MiningLocationLabel.GlaciteCategory> GLACITE_LOCATIONS = Arrays.stream(MiningLocationLabel.GlaciteCategory.values()).collect(Collectors.toMap(MiningLocationLabel.GlaciteCategory::toString, Function.identity()));
    protected static List<MiningLocationLabel> activeWaypoints = new ArrayList<MiningLocationLabel>();
    private static List<String> commissions = List.of();
    private static boolean commissionDone = false;

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(CommissionLabels::extractRendering);
        Scheduler.INSTANCE.scheduleCyclic(CommissionLabels::tick, 20);
    }

    public static boolean enabled() {
        return SkyblockerConfigManager.get().mining.commissionWaypoints.mode != MiningConfig.CommissionWaypointMode.OFF;
    }

    private static void tick() {
        if (!Utils.isInDwarvenMines() || !CommissionLabels.enabled()) {
            return;
        }
        boolean foundCommissions = false;
        ArrayList<String> newCommissions = new ArrayList<String>();
        boolean newCommissionDone = false;
        for (int i = 0; i < PlayerListManager.getPlayerList().size(); ++i) {
            class_640 entry = PlayerListManager.getPlayerList().get(i);
            class_2561 displayName = entry.method_2971();
            if (displayName == null) continue;
            String string = displayName.getString();
            if (foundCommissions) {
                if (!string.startsWith(" ")) break;
                Matcher matcher = CommsWidget.COMM_PATTERN.matcher(string = string.substring(1));
                if (!matcher.matches()) continue;
                String name = matcher.group("name");
                String progress = matcher.group("progress");
                newCommissionDone |= "DONE".equals(progress);
                newCommissions.add(name);
                continue;
            }
            if (!string.startsWith("Commissions")) continue;
            foundCommissions = true;
        }
        if (!newCommissions.equals(commissions) || newCommissionDone != commissionDone) {
            commissions = newCommissions;
            commissionDone = newCommissionDone;
            CommissionLabels.update(commissions, commissionDone);
        }
    }

    public static void update(List<String> newCommissions, boolean completed) {
        if (!CommissionLabels.enabled()) {
            return;
        }
        MiningConfig.CommissionWaypointMode currentMode = SkyblockerConfigManager.get().mining.commissionWaypoints.mode;
        activeWaypoints.clear();
        Area area = Utils.getArea();
        if (area.equals(Area.DwarvenMines.DWARVEN_BASE_CAMP) || area.equals(Area.DwarvenMines.GLACITE_TUNNELS) || area.equals(Area.DwarvenMines.GLACITE_MINESHAFTS) || area.equals(Area.DwarvenMines.GREAT_GLACITE_LAKE)) {
            if (currentMode != MiningConfig.CommissionWaypointMode.BOTH && currentMode != MiningConfig.CommissionWaypointMode.GLACITE) {
                return;
            }
            for (String commission : newCommissions) {
                for (Map.Entry<String, MiningLocationLabel.GlaciteCategory> glaciteLocation : GLACITE_LOCATIONS.entrySet()) {
                    if (!commission.contains(glaciteLocation.getKey())) continue;
                    MiningLocationLabel.GlaciteCategory category = glaciteLocation.getValue();
                    for (class_2338 gemstoneLocation : category.getLocations()) {
                        activeWaypoints.add(new MiningLocationLabel(category, gemstoneLocation));
                    }
                }
            }
            if (SkyblockerConfigManager.get().mining.commissionWaypoints.showBaseCamp) {
                activeWaypoints.add(new MiningLocationLabel(MiningLocationLabel.GlaciteCategory.CAMPFIRE, MiningLocationLabel.GlaciteCategory.CAMPFIRE.getLocations()[0]));
            }
            return;
        }
        if (currentMode != MiningConfig.CommissionWaypointMode.BOTH && currentMode != MiningConfig.CommissionWaypointMode.DWARVEN) {
            return;
        }
        for (String commission : newCommissions) {
            for (Map.Entry<String, MiningLocationLabel.DwarvenCategory> dwarvenLocation : DWARVEN_LOCATIONS.entrySet()) {
                if (!commission.contains(dwarvenLocation.getKey())) continue;
                MiningLocationLabel.DwarvenCategory category = dwarvenLocation.getValue();
                category.isTitanium = commission.contains("Titanium");
                activeWaypoints.add(new MiningLocationLabel(category, category.getLocation()));
            }
        }
        if (SkyblockerConfigManager.get().mining.commissionWaypoints.showEmissary && completed) {
            if (SkyblockerConfigManager.get().mining.commissionWaypoints.hideEmissaryOnPigeon) {
                for (class_1799 stack : class_310.method_1551().field_1724.method_31548().method_67533()) {
                    if (!stack.getSkyblockId().equals("ROYAL_PIGEON")) continue;
                    return;
                }
            }
            for (MiningLocationLabel.DwarvenEmissaries emissaries : DWARVEN_EMISSARIES) {
                activeWaypoints.add(new MiningLocationLabel(emissaries, emissaries.getLocation()));
            }
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (Location.DWARVEN_MINES != Utils.getLocation() || !CommissionLabels.enabled()) {
            return;
        }
        for (MiningLocationLabel MiningLocationLabel2 : activeWaypoints) {
            MiningLocationLabel2.extractRendering(collector);
        }
    }
}

