/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.events.PlaySoundEvents;
import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_5702;
import net.minecraft.class_746;

public class CrystalsChestHighlighter {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final String CHEST_SPAWN_MESSAGE = "You uncovered a treasure chest!";
    private static final long MAX_PARTICLE_LIFE_TIME = 250L;
    private static final class_243 LOCK_HIGHLIGHT_SIZE = new class_243(0.1, 0.1, 0.1);
    private static int waitingForChest = 0;
    private static final Set<class_2338> activeChests = new HashSet<class_2338>();
    private static final Object2LongOpenHashMap<class_243> activeParticles = new Object2LongOpenHashMap();
    private static int currentLockCount = 0;
    private static int neededLockCount = 0;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(CrystalsChestHighlighter::extractLocationFromMessage);
        WorldRenderExtractionCallback.EVENT.register(CrystalsChestHighlighter::extractRendering);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> CrystalsChestHighlighter.reset());
        WorldEvents.BLOCK_STATE_UPDATE.register(CrystalsChestHighlighter::onBlockUpdate);
        ParticleEvents.FROM_SERVER.register(CrystalsChestHighlighter::onParticle);
        PlaySoundEvents.FROM_SERVER.register(CrystalsChestHighlighter::onSound);
    }

    private static void reset() {
        waitingForChest = 0;
        activeChests.clear();
        activeParticles.clear();
        currentLockCount = 0;
    }

    private static boolean extractLocationFromMessage(class_2561 text, boolean b) {
        if (!Utils.isInCrystalHollows() || !SkyblockerConfigManager.get().mining.crystalHollows.chestHighlighter) {
            return true;
        }
        if (text.getString().matches(CHEST_SPAWN_MESSAGE)) {
            ++waitingForChest;
        }
        return true;
    }

    private static void onBlockUpdate(class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (!SkyblockerConfigManager.get().mining.crystalHollows.chestHighlighter || CrystalsChestHighlighter.CLIENT.field_1724 == null || !Utils.isInCrystalHollows()) {
            return;
        }
        class_2338 immutable = pos.method_10062();
        if (waitingForChest > 0 && newState.method_27852(class_2246.field_10034)) {
            if (immutable.method_19770((class_2374)CrystalsChestHighlighter.CLIENT.field_1724.method_73189()) > 100.0) {
                return;
            }
            activeChests.add(immutable);
            currentLockCount = 0;
            --waitingForChest;
        } else if (newState.method_26215() && activeChests.contains(immutable)) {
            currentLockCount = 0;
            activeChests.remove(immutable);
        }
    }

    private static void onParticle(class_2675 packet) {
        if (!Utils.isInCrystalHollows() || !SkyblockerConfigManager.get().mining.crystalHollows.chestHighlighter) {
            return;
        }
        if (class_2398.field_11205.equals(packet.method_11551().method_10295())) {
            activeParticles.put((Object)new class_243(packet.method_11544(), packet.method_11547(), packet.method_11546()), System.currentTimeMillis());
        }
    }

    private static void onSound(class_2767 packet) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !Utils.isInCrystalHollows() || !SkyblockerConfigManager.get().mining.crystalHollows.chestHighlighter) {
            return;
        }
        class_3414 sound = (class_3414)packet.method_11894().comp_349();
        if (sound.comp_3319().equals((Object)class_3417.field_14627.comp_3319()) && packet.method_11892() == 1.0f && !activeChests.isEmpty()) {
            class_243 eyePos = player.method_5836(0.0f);
            class_243 rotationVec = player.method_5828(0.0f);
            double range = player.method_55754();
            class_243 vec3d3 = eyePos.method_1031(rotationVec.field_1352 * range, rotationVec.field_1351 * range, rotationVec.field_1350 * range);
            class_3965 raycast = player.method_73183().method_32880(new class_5702(eyePos, vec3d3, blockState -> blockState.method_27852(class_2246.field_10034)));
            if (!raycast.method_17783().equals((Object)class_239.class_240.field_1333)) {
                ++currentLockCount;
                activeParticles.clear();
            }
        } else if (sound.comp_3319().equals((Object)class_3417.field_15008.comp_3319())) {
            currentLockCount = 0;
            activeParticles.clear();
        } else if (sound.comp_3319().equals((Object)class_3417.field_14982.comp_3319())) {
            neededLockCount = Math.min(currentLockCount, 5);
            currentLockCount = 0;
            activeParticles.clear();
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        class_3965 blockHitResult;
        if (!Utils.isInCrystalHollows() || !SkyblockerConfigManager.get().mining.crystalHollows.chestHighlighter) {
            return;
        }
        float[] color = SkyblockerConfigManager.get().mining.crystalHollows.chestHighlightColor.getComponents(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        for (class_2338 chest : activeChests) {
            collector.submitOutlinedBox(class_238.method_30048((class_243)chest.method_46558().method_1023(0.0, 0.0625, 0.0), (double)0.885, (double)0.885, (double)0.885), color, color[3], 3.0f, false);
        }
        if (CrystalsChestHighlighter.CLIENT.field_1724 == null) {
            return;
        }
        class_239 target = CrystalsChestHighlighter.CLIENT.field_1765;
        if (target instanceof class_3965 && activeChests.contains((blockHitResult = (class_3965)target).method_17777())) {
            class_243 chestPos = blockHitResult.method_17777().method_46558();
            if (!activeParticles.isEmpty()) {
                class_243 highlightSpot = class_243.field_1353;
                activeParticles.object2LongEntrySet().removeIf(e -> System.currentTimeMillis() - e.getLongValue() > 250L);
                int addedParticles = 0;
                for (class_243 particlePos : activeParticles.keySet()) {
                    if (!particlePos.method_24802((class_2374)chestPos, 0.8)) continue;
                    highlightSpot = highlightSpot.method_1019(particlePos);
                    ++addedParticles;
                }
                highlightSpot = highlightSpot.method_1021(1.0 / (double)addedParticles).method_1020(LOCK_HIGHLIGHT_SIZE.method_1021(0.5));
                collector.submitFilledBox(highlightSpot, LOCK_HIGHLIGHT_SIZE, color, color[3], true);
            }
            if (neededLockCount <= 0) {
                return;
            }
            collector.submitText((class_2561)class_2561.method_43470((String)(Math.min(currentLockCount, neededLockCount) + "/" + neededLockCount)).method_54663(SkyblockerConfigManager.get().mining.crystalHollows.chestHighlightColor.getRGB()), chestPos, true);
        }
    }
}

