/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.ItemAbility;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jspecify.annotations.Nullable;

public class PickobulusHelper {
    private static final Set<class_2248> CONVERT_INTO_BEDROCK_BLOCKS = Set.of(class_2246.field_10340, class_2246.field_10445, class_2246.field_10346, class_2246.field_10135, class_2246.field_10006, class_2246.field_10297, class_2246.field_10235, class_2246.field_10294, class_2246.field_10423, class_2246.field_10441, class_2246.field_10205, class_2246.field_10085, class_2246.field_10201, class_2246.field_10234, class_2246.field_10002, class_2246.field_10381, class_2246.field_10153, class_2246.field_10571, class_2246.field_10212, class_2246.field_10418, class_2246.field_10090, class_2246.field_10080, class_2246.field_10442, class_2246.field_10013, class_2246.field_10213, class_2246.field_10515, class_2246.field_10171, class_2246.field_10540, class_2246.field_10471);
    private static final Set<class_2248> STAINED_GLASS_BLOCKS = Set.of(class_2246.field_10087, class_2246.field_10227, class_2246.field_10574, class_2246.field_10271, class_2246.field_10049, class_2246.field_10157, class_2246.field_10317, class_2246.field_10555, class_2246.field_9996, class_2246.field_10248, class_2246.field_10399, class_2246.field_10060, class_2246.field_10073, class_2246.field_10357, class_2246.field_10272, class_2246.field_9997, class_2246.field_9991, class_2246.field_10496, class_2246.field_10469, class_2246.field_10193, class_2246.field_10578, class_2246.field_10305, class_2246.field_10565, class_2246.field_10077, class_2246.field_10129, class_2246.field_10355, class_2246.field_10152, class_2246.field_9982, class_2246.field_10163, class_2246.field_10419, class_2246.field_10118, class_2246.field_10070);
    private static final float[] LIGHT_BLUE = ColorUtils.getFloatComponents(class_1767.field_7951);
    private static final class_310 CLIENT = class_310.method_1551();
    private static boolean shouldRender;
    private static @Nullable class_2561 errorMessage;
    private static final class_2680[][][] blocks;
    private static final Set<class_2338> breakBlocks;
    private static final int[] drops;

    public static boolean shouldRender() {
        return shouldRender;
    }

    public static @Nullable class_2561 getErrorMessage() {
        return errorMessage;
    }

    public static int getTotalBlocks() {
        return breakBlocks.size();
    }

    public static int[] getDrops() {
        return drops;
    }

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(PickobulusHelper::update, 1);
        WorldRenderExtractionCallback.EVENT.register(PickobulusHelper::extractRendering);
    }

    private static void update() {
        if (!SkyblockerConfigManager.get().mining.enablePickobulusHelper && !SkyblockerConfigManager.get().mining.pickobulusHelper.enablePickobulusHud) {
            return;
        }
        shouldRender = true;
        errorMessage = null;
        breakBlocks.clear();
        Arrays.fill(drops, 0);
        if (PickobulusHelper.CLIENT.field_1724 == null || PickobulusHelper.CLIENT.field_1687 == null) {
            errorMessage = class_2561.method_43470((String)"Can't find player or world?").method_27692(class_124.field_1061);
            return;
        }
        Optional<String> pickobulusCooldownHud = PlayerListManager.getPlayerStringList().stream().map(String::trim).filter(entry -> entry.startsWith("Pickobulus: ")).findAny();
        if (pickobulusCooldownHud.isPresent() && !pickobulusCooldownHud.get().equals("Pickobulus: Available")) {
            shouldRender = !SkyblockerConfigManager.get().mining.pickobulusHelper.hideHudOnCooldown;
            errorMessage = class_2561.method_43470((String)("Pickobulus is on cooldown: " + pickobulusCooldownHud.get().substring(12))).method_27692(class_124.field_1061);
            return;
        }
        if (!ItemAbility.hasAbility(PickobulusHelper.CLIENT.field_1724.method_6047(), "Pickobulus")) {
            shouldRender = false;
            errorMessage = class_2561.method_43470((String)"Not holding a tool with pickobulus").method_27692(class_124.field_1061);
            return;
        }
        class_243 start = PickobulusHelper.CLIENT.field_1724.method_73189().method_1031(0.0, (double)Utils.getEyeHeight((class_1657)PickobulusHelper.CLIENT.field_1724) + 0.53625, 0.0);
        class_3965 blockHitResult = PickobulusHelper.CLIENT.field_1687.method_17742(new class_3959(start, start.method_1019(PickobulusHelper.CLIENT.field_1724.method_5663().method_1021(20.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)PickobulusHelper.CLIENT.field_1724));
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            errorMessage = class_2561.method_43470((String)"Not looking at a block").method_27692(class_124.field_1061);
            return;
        }
        PickobulusHelper.calculatePickobulus(blockHitResult.method_17777());
    }

    private static void calculatePickobulus(class_2338 pos) {
        int k;
        int j;
        int i;
        assert (PickobulusHelper.CLIENT.field_1687 != null);
        class_2338.class_2339 posMutable = pos.method_25503().method_10100(-4, -4, -4);
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 8; ++j) {
                for (k = 0; k < 8; ++k) {
                    PickobulusHelper.blocks[i][j][k] = PickobulusHelper.CLIENT.field_1687.method_8320((class_2338)posMutable);
                    posMutable.method_10098(class_2350.field_11035);
                }
                posMutable.method_10100(0, 1, -8);
            }
            posMutable.method_10100(1, -8, 0);
        }
        for (i = 1; i < 7; ++i) {
            for (j = 1; j < 7; ++j) {
                block10: for (k = 1; k < 7; ++k) {
                    boolean exposed;
                    class_2680 state = blocks[i][j][k];
                    if (state.method_26215() || state.method_27852(class_2246.field_9987)) continue;
                    boolean bl = exposed = blocks[i - 1][j][k].method_26215() || blocks[i + 1][j][k].method_26215() || blocks[i][j - 1][k].method_26215() || blocks[i][j + 1][k].method_26215() || blocks[i][j][k - 1].method_26215() || blocks[i][j][k + 1].method_26215();
                    if (!exposed) continue;
                    if (Utils.getArea() == Area.DwarvenMines.GLACITE_TUNNELS) {
                        PickobulusHelper.handleGlaciteTunnels(pos, state, i, j, k);
                        continue;
                    }
                    if (Utils.getArea() == Area.DwarvenMines.GLACITE_MINESHAFTS) {
                        PickobulusHelper.handleGlaciteMineshafts(pos, state, i, j, k);
                        continue;
                    }
                    switch (Utils.getLocation()) {
                        case GOLD_MINE: 
                        case DEEP_CAVERNS: 
                        case DWARVEN_MINES: {
                            PickobulusHelper.handleConvertIntoBedrock(pos, state, i, j, k);
                            continue block10;
                        }
                        case CRYSTAL_HOLLOWS: {
                            PickobulusHelper.handleCrystalHollows(pos, state, i, j, k);
                            continue block10;
                        }
                        case GLACITE_MINESHAFTS: {
                            PickobulusHelper.handleGlaciteMineshafts(pos, state, i, j, k);
                        }
                    }
                }
            }
        }
    }

    private static void handleBreakable(class_2338 pos, int i, int j, int k) {
        PickobulusHelper.blocks[i][j][k] = class_2246.field_10124.method_9564();
        breakBlocks.add(pos.method_10069(i - 4, j - 4, k - 4));
    }

    private static void handleConvertIntoBedrock(class_2338 pos, class_2680 state, int i, int j, int k) {
        if (CONVERT_INTO_BEDROCK_BLOCKS.contains(state.method_26204()) || STAINED_GLASS_BLOCKS.contains(state.method_26204())) {
            breakBlocks.add(pos.method_10069(i - 4, j - 4, k - 4));
        }
    }

    private static void handleCrystalHollows(class_2338 pos, class_2680 state, int i, int j, int k) {
        if (STAINED_GLASS_BLOCKS.contains(state.method_26204())) {
            int n = MiningDrop.GEMSTONES.ordinal();
            drops[n] = drops[n] + 1;
        } else if (state.method_27852(class_2246.field_10135)) {
            int n = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n] = drops[n] + 3;
        } else if (state.method_27852(class_2246.field_10006)) {
            int n = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n] = drops[n] + 3;
        } else if (state.method_27852(class_2246.field_10297)) {
            int n = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n] = drops[n] + 3;
        } else if (state.method_27852(class_2246.field_10294)) {
            int n = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n] = drops[n] + 5;
        } else if (state.method_27852(class_2246.field_10423)) {
            int n = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n] = drops[n] + 1;
        } else if (state.method_27852(class_2246.field_10235)) {
            int n = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n] = drops[n] + 1;
        }
        PickobulusHelper.handleBreakable(pos, i, j, k);
    }

    private static void handleGlaciteTunnels(class_2338 pos, class_2680 state, int i, int j, int k) {
        if (state.method_27852(class_2246.field_10225)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n2 = MiningDrop.ICE.ordinal();
            drops[n2] = drops[n2] + 1;
            PickobulusHelper.blocks[i][j][k] = class_2246.field_10124.method_9564();
        } else if (STAINED_GLASS_BLOCKS.contains(state.method_26204())) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n3 = MiningDrop.GEMSTONES.ordinal();
            drops[n3] = drops[n3] + 1;
            PickobulusHelper.blocks[i][j][k] = class_2246.field_10124.method_9564();
        } else if (state.method_27852(class_2246.field_10346)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 4;
            int n4 = MiningDrop.TITANIUM.ordinal();
            drops[n4] = drops[n4] + 1;
        } else if (state.method_27852(class_2246.field_10277)) {
            int n = MiningDrop.HARDSTONE.ordinal();
            drops[n] = drops[n] + 1;
        } else if (state.method_27852(class_2246.field_10209)) {
            int n = MiningDrop.HARDSTONE.ordinal();
            drops[n] = drops[n] + 1;
        } else if (state.method_27852(class_2246.field_10135)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 1;
            int n5 = MiningDrop.MITHRIL.ordinal();
            drops[n5] = drops[n5] + 1;
            int n6 = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n6] = drops[n6] + 3;
        } else if (state.method_27852(class_2246.field_10006)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 1;
            int n7 = MiningDrop.MITHRIL.ordinal();
            drops[n7] = drops[n7] + 1;
            int n8 = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n8] = drops[n8] + 3;
        } else if (state.method_27852(class_2246.field_10297)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 1;
            int n9 = MiningDrop.MITHRIL.ordinal();
            drops[n9] = drops[n9] + 1;
            int n10 = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n10] = drops[n10] + 3;
        } else if (state.method_27852(class_2246.field_10294)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 1;
            int n11 = MiningDrop.MITHRIL.ordinal();
            drops[n11] = drops[n11] + 1;
            int n12 = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n12] = drops[n12] + 5;
        } else if (state.method_27852(class_2246.field_10423)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 1;
            int n13 = MiningDrop.MITHRIL.ordinal();
            drops[n13] = drops[n13] + 1;
            int n14 = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n14] = drops[n14] + 1;
        } else if (state.method_27852(class_2246.field_10235)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 1;
            int n15 = MiningDrop.MITHRIL.ordinal();
            drops[n15] = drops[n15] + 1;
            int n16 = MiningDrop.MITHRIL_POWDER.ordinal();
            drops[n16] = drops[n16] + 1;
        } else if (state.method_27852(class_2246.field_10123)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n17 = MiningDrop.UMBER.ordinal();
            drops[n17] = drops[n17] + 1;
        } else if (state.method_27852(class_2246.field_10415)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n18 = MiningDrop.UMBER.ordinal();
            drops[n18] = drops[n18] + 1;
        } else if (state.method_27852(class_2246.field_10483)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n19 = MiningDrop.UMBER.ordinal();
            drops[n19] = drops[n19] + 1;
        } else if (state.method_27852(class_2246.field_10492)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n20 = MiningDrop.TUNGSTEN.ordinal();
            drops[n20] = drops[n20] + 1;
        } else if (state.method_27852(class_2246.field_10460)) {
            int n = MiningDrop.MINESHAFT_PITY.ordinal();
            drops[n] = drops[n] + 2;
            int n21 = MiningDrop.TUNGSTEN.ordinal();
            drops[n21] = drops[n21] + 1;
        } else {
            return;
        }
        breakBlocks.add(pos.method_10069(i - 4, j - 4, k - 4));
    }

    private static void handleGlaciteMineshafts(class_2338 pos, class_2680 state, int i, int j, int k) {
        if (state.method_27852(class_2246.field_10340)) {
            int n = MiningDrop.HARDSTONE.ordinal();
            drops[n] = drops[n] + 1;
        }
        PickobulusHelper.handleBreakable(pos, i, j, k);
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().mining.enablePickobulusHelper) {
            return;
        }
        for (class_2338 breakPos : breakBlocks) {
            collector.submitOutlinedBox(breakPos, LIGHT_BLUE, 2.0f, false);
        }
    }

    static {
        blocks = new class_2680[8][8][8];
        breakBlocks = new HashSet<class_2338>();
        drops = new int[MiningDrop.values().length];
    }

    static enum MiningDrop {
        MINESHAFT_PITY("Mineshaft Pity"),
        HARDSTONE("Hardstone"),
        ICE("Ice"),
        TUNGSTEN("Tungsten"),
        UMBER("Umber"),
        MITHRIL("Mithril"),
        TITANIUM("Titanium"),
        GEMSTONES("Gemstones"),
        MITHRIL_POWDER("Mithril Powder");

        private final String friendlyName;

        private MiningDrop(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String friendlyName() {
            return this.friendlyName;
        }
    }
}

