/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dwarven.PickobulusHelper;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import de.hysky.skyblocker.utils.Location;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jspecify.annotations.Nullable;

@RegisterWidget
public class PickobulusHudWidget
extends ComponentBasedWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Pickobulus").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067});
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.GOLD_MINE, Location.DEEP_CAVERNS, Location.DWARVEN_MINES, Location.CRYSTAL_HOLLOWS, Location.GLACITE_MINESHAFTS);
    private static @Nullable PickobulusHudWidget instance;

    public PickobulusHudWidget() {
        super(TITLE, class_124.field_1078.method_532(), "hud_pickobulus");
        instance = this;
        this.update();
    }

    public static PickobulusHudWidget getInstance() {
        if (instance == null) {
            new PickobulusHudWidget();
        }
        return instance;
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    @Override
    public void updateContent() {
        class_2561 errorMessage = PickobulusHelper.getErrorMessage();
        if (errorMessage != null) {
            this.addComponent(new PlainTextComponent(errorMessage));
            return;
        }
        this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)("Total Blocks: " + PickobulusHelper.getTotalBlocks()))));
        int[] drops = PickobulusHelper.getDrops();
        for (PickobulusHelper.MiningDrop drop : PickobulusHelper.MiningDrop.values()) {
            int count = drops[drop.ordinal()];
            if (count <= 0) continue;
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)(drop.friendlyName() + ": " + count))));
        }
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public boolean shouldRender(Location location) {
        return super.shouldRender(location) && PickobulusHelper.shouldRender();
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return AVAILABLE_LOCATIONS.contains((Object)location) && SkyblockerConfigManager.get().mining.pickobulusHelper.enablePickobulusHud;
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"skyblocker.config.mining.pickobulusHelper");
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!AVAILABLE_LOCATIONS.contains((Object)location)) {
            return;
        }
        SkyblockerConfigManager.get().mining.pickobulusHelper.enablePickobulusHud = enabled;
    }
}

