/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.skyblock.dwarven.CrystalsLocationsManager;
import de.hysky.skyblocker.skyblock.dwarven.MiningLocationLabel;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class WishingCompassSolver {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Map<Zone, class_238> ZONE_BOUNDING_BOXES = Map.of(Zone.CRYSTAL_NUCLEUS, new class_238(462.0, 63.0, 461.0, 564.0, 181.0, 565.0), Zone.JUNGLE, new class_238(201.0, 63.0, 201.0, 513.0, 189.0, 513.0), Zone.MITHRIL_DEPOSITS, new class_238(512.0, 63.0, 201.0, 824.0, 189.0, 513.0), Zone.GOBLIN_HOLDOUT, new class_238(201.0, 63.0, 512.0, 513.0, 189.0, 824.0), Zone.PRECURSOR_REMNANTS, new class_238(512.0, 63.0, 512.0, 824.0, 189.0, 824.0), Zone.MAGMA_FIELDS, new class_238(201.0, 30.0, 201.0, 824.0, 64.0, 824.0));
    private static final class_243 JUNGLE_TEMPLE_DOOR_OFFSET = new class_243(-57.0, 36.0, -21.0);
    private static final long PARTICLES_PER_LINE = 25L;
    private static final long PARTICLES_MAX_DELAY = 500L;
    private static final double PARTICLES_MAX_DISTANCE = 0.9;
    private static final long DISTANCE_BETWEEN_USES = 8L;
    private static final double DISTANCE_TOLERANCE = 5.0;
    private static SolverStates currentState = SolverStates.NOT_STARTED;
    private static class_243 startPosOne = class_243.field_1353;
    private static class_243 startPosTwo = class_243.field_1353;
    private static class_243 directionOne = class_243.field_1353;
    private static class_243 directionTwo = class_243.field_1353;
    private static long particleUsedCountOne = 0L;
    private static long particleUsedCountTwo = 0L;
    private static long particleLastUpdate = System.currentTimeMillis();
    private static class_243 particleLastPos = class_243.field_1353;

    @Init
    public static void init() {
        UseItemCallback.EVENT.register(WishingCompassSolver::onItemInteract);
        UseBlockCallback.EVENT.register(WishingCompassSolver::onBlockInteract);
        ClientReceiveMessageEvents.ALLOW_GAME.register(WishingCompassSolver::failMessageListener);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> WishingCompassSolver.reset());
        ParticleEvents.FROM_SERVER.register(WishingCompassSolver::onParticle);
    }

    private static boolean failMessageListener(class_2561 text, boolean b) {
        if (!Utils.isInCrystalHollows()) {
            return true;
        }
        if (class_124.method_539((String)text.getString()).equals("The Wishing Compass can't seem to locate anything!")) {
            currentState = SolverStates.NOT_STARTED;
        }
        return true;
    }

    private static void reset() {
        currentState = SolverStates.NOT_STARTED;
        startPosOne = class_243.field_1353;
        startPosTwo = class_243.field_1353;
        directionOne = class_243.field_1353;
        directionTwo = class_243.field_1353;
        particleUsedCountOne = 0L;
        particleUsedCountTwo = 0L;
        particleLastUpdate = System.currentTimeMillis();
        particleLastPos = class_243.field_1353;
    }

    private static boolean isKingsScentPresent() {
        if (WishingCompassSolver.CLIENT.field_1724 == null) {
            return false;
        }
        if (PlayerListManager.getPlayerStringList().stream().noneMatch(entry -> entry.startsWith("Active Effects:"))) {
            WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.enableTabEffectsMessage")), false);
            return false;
        }
        return PlayerListManager.getPlayerStringList().stream().anyMatch(entry -> entry.startsWith("King's Scent"));
    }

    private static boolean isKeyInInventory() {
        return WishingCompassSolver.CLIENT.field_1724 != null && WishingCompassSolver.CLIENT.field_1724.method_31548().method_67533().stream().anyMatch(stack -> stack != null && stack.getSkyblockId().equals("JUNGLE_KEY"));
    }

    private static Zone getZoneOfLocation(class_243 location) {
        return ZONE_BOUNDING_BOXES.entrySet().stream().filter(zone -> ((class_238)zone.getValue()).method_1006(location)).findFirst().map(Map.Entry::getKey).orElse(Zone.CRYSTAL_NUCLEUS);
    }

    private static Boolean isZoneComplete(Zone zone) {
        if (CLIENT.method_1562() == null || WishingCompassSolver.CLIENT.field_1724 == null) {
            return false;
        }
        if (PlayerListManager.getPlayerStringList().stream().noneMatch(entry -> entry.equals("Crystals:"))) {
            WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.enableTabMessage")), false);
            return false;
        }
        Stream displayNameStream = PlayerListManager.getPlayerStringList().stream();
        return switch (zone.ordinal()) {
            case 1 -> displayNameStream.noneMatch(entry -> entry.equals("Amethyst: \u2716 Not Found"));
            case 2 -> displayNameStream.noneMatch(entry -> entry.equals("Jade: \u2716 Not Found"));
            case 3 -> displayNameStream.noneMatch(entry -> entry.equals("Amber: \u2716 Not Found"));
            case 4 -> displayNameStream.noneMatch(entry -> entry.equals("Sapphire: \u2716 Not Found"));
            case 5 -> displayNameStream.noneMatch(entry -> entry.equals("Topaz: \u2716 Not Found"));
            default -> false;
        };
    }

    private static MiningLocationLabel.CrystalHollowsLocationsCategory getTargetLocation(Zone startingZone) {
        if (WishingCompassSolver.isZoneComplete(startingZone).booleanValue()) {
            return MiningLocationLabel.CrystalHollowsLocationsCategory.UNKNOWN;
        }
        return switch (startingZone.ordinal()) {
            case 1 -> {
                if (WishingCompassSolver.isKeyInInventory()) {
                    yield MiningLocationLabel.CrystalHollowsLocationsCategory.JUNGLE_TEMPLE;
                }
                yield MiningLocationLabel.CrystalHollowsLocationsCategory.ODAWA;
            }
            case 2 -> MiningLocationLabel.CrystalHollowsLocationsCategory.MINES_OF_DIVAN;
            case 3 -> {
                if (WishingCompassSolver.isKingsScentPresent()) {
                    yield MiningLocationLabel.CrystalHollowsLocationsCategory.GOBLIN_QUEENS_DEN;
                }
                yield MiningLocationLabel.CrystalHollowsLocationsCategory.KING_YOLKAR;
            }
            case 4 -> MiningLocationLabel.CrystalHollowsLocationsCategory.LOST_PRECURSOR_CITY;
            case 5 -> MiningLocationLabel.CrystalHollowsLocationsCategory.KHAZAD_DUM;
            default -> MiningLocationLabel.CrystalHollowsLocationsCategory.UNKNOWN;
        };
    }

    private static Boolean verifyLocation(Zone startingZone, class_243 pos) {
        return ZONE_BOUNDING_BOXES.get((Object)startingZone).method_1009(100.0, 0.0, 100.0).method_1006(pos);
    }

    private static void onParticle(class_2675 packet) {
        if (!Utils.isInCrystalHollows() || !class_2398.field_11211.equals(packet.method_11551().method_10295())) {
            return;
        }
        class_243 particlePos = new class_243(packet.method_11544(), packet.method_11547(), packet.method_11546());
        particleLastUpdate = System.currentTimeMillis();
        if (particlePos.method_1022(particleLastPos) > 0.9) {
            return;
        }
        particleLastPos = particlePos;
        switch (currentState.ordinal()) {
            case 1: {
                class_243 particleDirection = particlePos.method_1020(startPosOne).method_1029();
                directionOne = directionOne.method_1019(particleDirection.method_1021(0.04));
                if (++particleUsedCountOne < 25L) break;
                currentState = SolverStates.WAITING_FOR_SECOND;
                if (WishingCompassSolver.CLIENT.field_1724 == null) break;
                WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.wishingCompassUsedMessage").method_27692(class_124.field_1060)), false);
                break;
            }
            case 3: {
                class_243 particleDirection = particlePos.method_1020(startPosTwo).method_1029();
                directionTwo = directionTwo.method_1019(particleDirection.method_1021(0.04));
                if (++particleUsedCountTwo < 25L) break;
                WishingCompassSolver.processSolution();
            }
        }
    }

    private static void processSolution() {
        if (WishingCompassSolver.CLIENT.field_1724 == null) {
            WishingCompassSolver.reset();
            return;
        }
        class_243 targetLocation = WishingCompassSolver.solve(startPosOne, startPosTwo, directionOne, directionTwo);
        if (targetLocation == null) {
            WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.somethingWentWrongMessage").method_27692(class_124.field_1061)), false);
        } else {
            Zone playerZone = WishingCompassSolver.getZoneOfLocation(startPosOne);
            MiningLocationLabel.CrystalHollowsLocationsCategory location = WishingCompassSolver.getTargetLocation(playerZone);
            if (!WishingCompassSolver.verifyLocation(playerZone, targetLocation).booleanValue()) {
                location = MiningLocationLabel.CrystalHollowsLocationsCategory.UNKNOWN;
                WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.targetLocationToFar").method_27692(class_124.field_1061)), false);
            }
            if (location == MiningLocationLabel.CrystalHollowsLocationsCategory.JUNGLE_TEMPLE) {
                targetLocation = targetLocation.method_1019(JUNGLE_TEMPLE_DOOR_OFFSET);
            }
            WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.foundMessage").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)location.getName()).method_54663(location.getColor())).method_10852((class_2561)class_2561.method_43470((String)(": " + (int)targetLocation.method_10216() + " " + (int)targetLocation.method_10214() + " " + (int)targetLocation.method_10215()))), false);
            CrystalsLocationsManager.addCustomWaypoint(location.getName(), class_2338.method_49638((class_2374)targetLocation));
        }
        WishingCompassSolver.reset();
    }

    protected static class_243 solve(class_243 startPosOne, class_243 startPosTwo, class_243 directionOne, class_243 directionTwo) {
        if (directionOne.equals((Object)directionTwo)) {
            return null;
        }
        Vector3D lineOneStart = new Vector3D(startPosOne.field_1352, startPosOne.field_1351, startPosOne.field_1350);
        Vector3D lineOneEnd = new Vector3D(directionOne.field_1352, directionOne.field_1351, directionOne.field_1350).add((Vector)lineOneStart);
        Vector3D lineTwoStart = new Vector3D(startPosTwo.field_1352, startPosTwo.field_1351, startPosTwo.field_1350);
        Vector3D lineTwoEnd = new Vector3D(directionTwo.field_1352, directionTwo.field_1351, directionTwo.field_1350).add((Vector)lineTwoStart);
        Line line = new Line(lineOneStart, lineOneEnd, 1.0);
        Line lineTwo = new Line(lineTwoStart, lineTwoEnd, 1.0);
        Vector3D close = line.closestPoint(lineTwo);
        Vector3D closeTwo = lineTwo.closestPoint(line);
        double distance = close.distance((Vector)closeTwo);
        class_243 intersection = null;
        if (distance < 5.0) {
            class_243 c1 = new class_243(close.getX(), close.getY(), close.getZ());
            class_243 c2 = new class_243(close.getX(), close.getY(), close.getZ());
            intersection = c1.method_1019(c2).method_1021(0.5);
        }
        return intersection;
    }

    private static class_1269 onBlockInteract(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (WishingCompassSolver.CLIENT.field_1724 == null) {
            return null;
        }
        class_1799 stack = WishingCompassSolver.CLIENT.field_1724.method_5998(hand);
        if (!(Utils.isInCrystalHollows() && SkyblockerConfigManager.get().mining.crystalsWaypoints.wishingCompassSolver && stack.getSkyblockId().equals("WISHING_COMPASS"))) {
            return class_1269.field_5811;
        }
        if (WishingCompassSolver.useCompass()) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onItemInteract(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        if (WishingCompassSolver.CLIENT.field_1724 == null) {
            return null;
        }
        class_1799 stack = WishingCompassSolver.CLIENT.field_1724.method_5998(hand);
        if (!(Utils.isInCrystalHollows() && SkyblockerConfigManager.get().mining.crystalsWaypoints.wishingCompassSolver && stack.getSkyblockId().equals("WISHING_COMPASS"))) {
            return class_1269.field_5811;
        }
        if (WishingCompassSolver.useCompass()) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static boolean useCompass() {
        if (WishingCompassSolver.CLIENT.field_1724 == null) {
            return true;
        }
        class_243 playerPos = WishingCompassSolver.CLIENT.field_1724.method_33571();
        Zone currentZone = WishingCompassSolver.getZoneOfLocation(playerPos);
        switch (currentState.ordinal()) {
            case 0: {
                if (currentZone == Zone.CRYSTAL_NUCLEUS) {
                    WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.useOutsideNucleusMessage")), false);
                    return true;
                }
                WishingCompassSolver.startNewState(SolverStates.PROCESSING_FIRST_USE);
                break;
            }
            case 2: {
                if (startPosOne.method_24802((class_2374)playerPos, 8.0)) {
                    WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.moveFurtherMessage")), false);
                    return true;
                }
                if (currentZone != WishingCompassSolver.getZoneOfLocation(startPosOne)) {
                    WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.changingZoneMessage")), false);
                    WishingCompassSolver.reset();
                    WishingCompassSolver.startNewState(SolverStates.PROCESSING_FIRST_USE);
                    break;
                }
                WishingCompassSolver.startNewState(SolverStates.PROCESSING_SECOND_USE);
                break;
            }
            case 1: 
            case 3: {
                if (System.currentTimeMillis() - particleLastUpdate < 500L) {
                    WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.waitLongerMessage").method_27692(class_124.field_1061)), false);
                    return true;
                }
                WishingCompassSolver.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.crystalsWaypoints.wishingCompassSolver.couldNotDetectLastUseMessage").method_27692(class_124.field_1061)), false);
                WishingCompassSolver.reset();
                WishingCompassSolver.startNewState(SolverStates.PROCESSING_FIRST_USE);
            }
        }
        return false;
    }

    private static void startNewState(SolverStates newState) {
        if (WishingCompassSolver.CLIENT.field_1724 == null) {
            return;
        }
        class_243 playerPos = WishingCompassSolver.CLIENT.field_1724.method_73189().method_1031(0.0, 1.62, 0.0);
        if (newState == SolverStates.PROCESSING_FIRST_USE) {
            currentState = SolverStates.PROCESSING_FIRST_USE;
            startPosOne = playerPos;
            particleLastUpdate = System.currentTimeMillis();
            particleLastPos = playerPos;
        } else if (newState == SolverStates.PROCESSING_SECOND_USE) {
            currentState = SolverStates.PROCESSING_SECOND_USE;
            startPosTwo = playerPos;
            particleLastUpdate = System.currentTimeMillis();
            particleLastPos = playerPos;
        }
    }

    private static enum SolverStates {
        NOT_STARTED,
        PROCESSING_FIRST_USE,
        WAITING_FOR_SECOND,
        PROCESSING_SECOND_USE;

    }

    private static enum Zone {
        CRYSTAL_NUCLEUS,
        JUNGLE,
        MITHRIL_DEPOSITS,
        GOBLIN_HOLDOUT,
        PRECURSOR_REMNANTS,
        MAGMA_FIELDS;

    }
}

