/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.fossil;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dwarven.fossil.FossilCalculations;
import de.hysky.skyblocker.skyblock.dwarven.fossil.Structures;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.LineSmoothener;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.TooltipAdder;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jspecify.annotations.Nullable;

public class FossilSolver
extends SimpleContainerSolver
implements TooltipAdder {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile("Fossil Excavation Progress: (\\d{1,2}.\\d)%");
    private static final Pattern CHARGES_PATTERN = Pattern.compile("Chisel Charges Remaining: (\\d{1,2})");
    private static String percentage;
    private static double[] probability;
    private static int chiselLeft;

    public FossilSolver() {
        super("Fossil Excavator");
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        Structures.TileGrid mainTileGrid = FossilCalculations.convertItemsToTiles(slots);
        chiselLeft = !slots.isEmpty() ? this.getChiselLeft((class_1799)slots.values().stream().findAny().get()) : -1;
        if (percentage == null) {
            percentage = this.getFossilPercentage(slots);
        }
        probability = FossilCalculations.getFossilChance(mainTileGrid, percentage);
        return FossilSolver.convertChanceToColor(probability);
    }

    private int getChiselLeft(class_1799 itemStack) {
        for (class_2561 line : itemStack.method_7950(class_1792.class_9635.field_51353, (class_1657)FossilSolver.CLIENT.field_1724, (class_1836)class_1836.field_41070)) {
            Matcher matcher = CHARGES_PATTERN.matcher(line.getString());
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private String getFossilPercentage(Int2ObjectMap<class_1799> slots) {
        for (class_1799 item : slots.values()) {
            for (class_2561 line : item.method_7950(class_1792.class_9635.field_51353, (class_1657)FossilSolver.CLIENT.field_1724, (class_1836)class_1836.field_41070)) {
                Matcher matcher = PERCENTAGE_PATTERN.matcher(line.getString());
                if (!matcher.matches()) continue;
                return matcher.group(1);
            }
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().mining.glacite.fossilSolver;
    }

    private static List<ColorHighlight> convertChanceToColor(double[] chances) {
        ArrayList<ColorHighlight> outputColors = new ArrayList<ColorHighlight>();
        Color gradientColor = Color.BLUE;
        OptionalDouble highProbability = Arrays.stream(chances).max();
        for (int i = 0; i < chances.length; ++i) {
            double chance = chances[i];
            if (Double.isNaN(chances[i]) || chances[i] == 0.0) continue;
            if (chances[i] == highProbability.getAsDouble()) {
                outputColors.add(ColorHighlight.green(i));
                continue;
            }
            outputColors.add(new ColorHighlight(i, (int)(chance * 255.0) << 24 | gradientColor.getRed() << 16 | gradientColor.getGreen() << 8 | gradientColor.getBlue()));
        }
        return outputColors;
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (stack.method_7909() != class_1802.field_8871 && stack.method_7909() != class_1802.field_8501) {
            return;
        }
        lines.add(LineSmoothener.createSmoothLine());
        if (FossilCalculations.permutations == 0) {
            lines.add((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.glacite.fossilSolver.toolTip.noFossilFound").method_27692(class_124.field_1065));
            return;
        }
        lines.add((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.glacite.fossilSolver.toolTip.possiblePatterns").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(FossilCalculations.permutations)).method_27692(class_124.field_1054)));
        lines.add((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.glacite.fossilSolver.toolTip.minimumTilesLeft").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(FossilCalculations.minimumTiles)).method_27692(chiselLeft >= FossilCalculations.minimumTiles ? class_124.field_1054 : class_124.field_1061)));
        if (focusedSlot != null && probability != null && probability.length > focusedSlot.method_34266() && stack.method_7909() == class_1802.field_8501) {
            lines.add((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.glacite.fossilSolver.toolTip.probability").method_10852((class_2561)class_2561.method_43470((String)(Math.round(probability[focusedSlot.method_34266()] * 100.0) + "%")).method_27692(class_124.field_1054)));
        }
        if (FossilCalculations.fossilName != null && percentage != null) {
            lines.add((class_2561)class_2561.method_43471((String)"skyblocker.config.mining.glacite.fossilSolver.toolTip.foundFossil").method_10852((class_2561)class_2561.method_43470((String)FossilCalculations.fossilName).method_27692(class_124.field_1054)));
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void reset() {
        chiselLeft = -1;
        percentage = null;
    }

    static {
        chiselLeft = -1;
    }
}

