/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.skyblock.dwarven.CorpseType;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseProfitTracker;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.Reward;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorpseLoot {
    public static final Codec<CorpseLoot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CorpseType.CODEC.fieldOf("corpseType").forGetter(CorpseLoot::corpseType), (App)Reward.CODEC.listOf().fieldOf("rewards").forGetter(CorpseLoot::rewards), (App)Codec.LONG.xmap(Instant::ofEpochMilli, Instant::toEpochMilli).fieldOf("timestamp").forGetter(CorpseLoot::timestamp), (App)Codec.DOUBLE.fieldOf("profit").forGetter(CorpseLoot::profit)).apply((Applicative)instance, CorpseLoot::new));
    public static final Logger LOGGER = LoggerFactory.getLogger(CorpseLoot.class);
    private final CorpseType corpseType;
    private final List<Reward> rewards;
    private final Instant timestamp;
    private double profit;
    private boolean isPriceDataComplete = true;

    CorpseLoot(CorpseType corpseType, List<Reward> rewards, Instant timestamp, double profit) {
        this.corpseType = corpseType;
        this.rewards = rewards;
        this.timestamp = timestamp;
        this.profit = profit;
    }

    CorpseLoot(CorpseType corpseType, List<Reward> rewards, Instant timestamp) {
        this(corpseType, rewards, timestamp, 0.0);
    }

    public CorpseType corpseType() {
        return this.corpseType;
    }

    public List<Reward> rewards() {
        return this.rewards;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public double profit() {
        return this.profit;
    }

    public void profit(double profit) {
        this.profit = profit;
    }

    public void addLoot(String itemName, int amount) {
        String itemId = CorpseLoot.getItemId(itemName);
        if (itemId.isEmpty()) {
            LOGGER.error("No matching item id for name `{}`. Report this!", (Object)itemName);
            return;
        }
        Reward reward = new Reward(amount, itemId);
        this.rewards.add(reward);
        if (CorpseProfitTracker.PRICELESS_ITEMS.contains(itemId)) {
            return;
        }
        DoubleBooleanPair price = ItemUtils.getItemPrice(itemId);
        if (!price.rightBoolean()) {
            LOGGER.warn("No price found for item `{}`.", (Object)itemId);
            if (this.isPriceDataComplete) {
                LOGGER.warn("Profit calculation will not be accurate due to missing item price, therefore it will not be sent to chat. It will still be added to the corpse history.");
            }
            this.markPriceDataIncomplete();
            return;
        }
        this.profit += price.leftDouble() * (double)amount;
        reward.pricePerUnit(price.leftDouble());
    }

    public boolean isPriceDataComplete() {
        return this.isPriceDataComplete;
    }

    public void markPriceDataIncomplete() {
        this.isPriceDataComplete = false;
    }

    public void markPriceDataComplete() {
        this.isPriceDataComplete = true;
    }

    private static String getItemId(String itemName) {
        return (String)CorpseProfitTracker.getName2IdMap().getOrDefault((Object)itemName, (Object)"");
    }
}

