/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ItemPriceUpdateEvent;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.dwarven.CorpseType;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.AbstractProfitTracker;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseLoot;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.CorpseProfitScreen;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.corpse.Reward;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorpseProfitTracker
extends AbstractProfitTracker {
    public static final String GLACITE_POWDER = "GLACITE_POWDER";
    public static final String OPAL_CRYSTAL = "OPAL_CRYSTAL";
    public static final String ONYX_CRYSTAL = "ONYX_CRYSTAL";
    public static final String AQUAMARINE_CRYSTAL = "AQUAMARINE_CRYSTAL";
    public static final String PERIDOT_CRYSTAL = "PERIDOT_CRYSTAL";
    public static final String CITRINE_CRYSTAL = "CITRINE_CRYSTAL";
    public static final String RUBY_CRYSTAL = "RUBY_CRYSTAL";
    public static final String JASPER_CRYSTAL = "JASPER_CRYSTAL";
    public static final String ENCHANTMENT_ICE_COLD_1 = "ENCHANTMENT_ICE_COLD_1";
    public static final @Unmodifiable List<String> PRICELESS_ITEMS = List.of("GLACITE_POWDER", "OPAL_CRYSTAL", "ONYX_CRYSTAL", "AQUAMARINE_CRYSTAL", "PERIDOT_CRYSTAL", "CITRINE_CRYSTAL", "RUBY_CRYSTAL", "JASPER_CRYSTAL");
    public static final String CORPSE_PROFIT_MESSAGE = "Corpse Profit: %s";
    public static final CorpseProfitTracker INSTANCE = new CorpseProfitTracker();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Corpse Profit Tracker");
    private static final Pattern CORPSE_PATTERN = Pattern.compile(" {2}(LAPIS|UMBER|TUNGSTEN|VANGUARD) CORPSE LOOT! *");
    private static final Object2ObjectArrayMap<String, String> NAME2ID_MAP = new Object2ObjectArrayMap(50);
    private ObjectArrayList<CorpseLoot> currentProfileRewards = new ObjectArrayList();
    private final ProfiledData<ObjectArrayList<CorpseLoot>> allRewards = new ProfiledData(this.getRewardFilePath("corpse-profits.json"), CorpseLoot.CODEC.listOf().xmap(ObjectArrayList::new, Function.identity()));
    private boolean insideRewardMessage = false;
    private @Nullable CorpseLoot lastCorpseLoot = null;

    private CorpseProfitTracker() {
    }

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(INSTANCE::onChatMessage);
        CorpseProfitTracker.INSTANCE.allRewards.init();
        SkyblockEvents.PROFILE_CHANGE.register(INSTANCE::onProfileChange);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"rewardTrackers").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"corpse").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").then(ClientCommandManager.argument((String)"summaryView", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            Scheduler.queueOpenScreen(new CorpseProfitScreen(((FabricClientCommandSource)ctx.getSource()).getClient().field_1755, BoolArgumentType.getBool((CommandContext)ctx, (String)"summaryView")));
            return 1;
        }))).executes(ctx -> {
            Scheduler.queueOpenScreen(new CorpseProfitScreen(((FabricClientCommandSource)ctx.getSource()).getClient().field_1755));
            return 1;
        }))).then(ClientCommandManager.literal((String)"reset").executes(ctx -> {
            CorpseProfitTracker.INSTANCE.currentProfileRewards.clear();
            CorpseProfitTracker.INSTANCE.allRewards.save();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.corpseTracker.historyReset").method_27692(class_124.field_1060)));
            return 1;
        }))))));
        ItemPriceUpdateEvent.ON_PRICE_UPDATE.register(INSTANCE::recalculateAll);
    }

    private void onProfileChange(String prevProfileId, String newProfileId) {
        if (!this.isEnabled()) {
            return;
        }
        this.currentProfileRewards = this.allRewards.computeIfAbsent(ObjectArrayList::new);
        this.recalculateAll();
    }

    public boolean isEnabled() {
        return SkyblockerConfigManager.get().mining.glacite.enableCorpseProfitTracker;
    }

    private boolean onChatMessage(class_2561 text, boolean overlay) {
        if (Utils.getLocation() != Location.GLACITE_MINESHAFTS || !INSTANCE.isEnabled() || overlay) {
            return true;
        }
        String message = text.getString();
        if (this.insideRewardMessage && message.equals("\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac")) {
            if (this.lastCorpseLoot == null) {
                LOGGER.error("Received a reward message end without a corresponding start. Report this!");
                return true;
            }
            this.currentProfileRewards.add((Object)this.lastCorpseLoot);
            if (!this.lastCorpseLoot.isPriceDataComplete()) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.corpseTracker.somethingWentWrong").method_27692(class_124.field_1065)));
            } else if (!SkyblockerConfigManager.get().mining.glacite.forceEnglishCorpseProfitTracker) {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.corpseTracker.corpseProfit", (Object[])new Object[]{class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(this.lastCorpseLoot.profit())).method_27692(this.lastCorpseLoot.profit() > 0.0 ? class_124.field_1060 : class_124.field_1061)})).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"skyblocker.corpseTracker.hoverText").method_27692(class_124.field_1060))).method_10958((class_2558)new class_2558.class_10609("/skyblocker rewardTrackers corpse list false"))));
            } else {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)String.format(CORPSE_PROFIT_MESSAGE, Formatters.INTEGER_NUMBERS.format(this.lastCorpseLoot.profit()))).method_27692(this.lastCorpseLoot.profit() > 0.0 ? class_124.field_1060 : class_124.field_1061)).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"skyblocker.corpseTracker.hoverText").method_27692(class_124.field_1060))).method_10958((class_2558)new class_2558.class_10609("/skyblocker rewardTrackers corpse list false"))));
            }
            this.lastCorpseLoot = null;
            this.insideRewardMessage = false;
            return true;
        }
        Matcher matcher = CORPSE_PATTERN.matcher(message);
        if (!this.insideRewardMessage && matcher.matches()) {
            CorpseType type;
            String corpse = matcher.group(1);
            try {
                type = CorpseType.valueOf(corpse.toUpperCase(Locale.ENGLISH));
                this.lastCorpseLoot = new CorpseLoot(type, (List<Reward>)new ObjectArrayList(), Instant.now());
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Unknown corpse type `{}` for message: `{}`. Report this!", (Object)corpse, (Object)message);
                return true;
            }
            try {
                this.lastCorpseLoot.profit(this.lastCorpseLoot.profit() - type.getKeyPrice());
            }
            catch (IllegalStateException e) {
                LOGGER.warn("No key price found for corpse type `{}`. Profit calculation will not be accurate, therefore it will not be sent to chat. It will still be added to the corpse history.", (Object)corpse);
                this.lastCorpseLoot.markPriceDataIncomplete();
            }
            this.insideRewardMessage = true;
            return true;
        }
        if (!this.insideRewardMessage || this.lastCorpseLoot == null || !matcher.usePattern(REWARD_PATTERN).matches()) {
            return true;
        }
        String itemName = matcher.group(1);
        int amount = NumberUtils.toInt((String)matcher.group(2).replace(",", ""), (int)1);
        if (matcher.usePattern(HOTM_XP_PATTERN).matches()) {
            return true;
        }
        this.lastCorpseLoot.addLoot(itemName, amount);
        return true;
    }

    private void recalculateAll() {
        for (CorpseLoot corpseLoot : this.currentProfileRewards) {
            corpseLoot.profit(0.0);
            corpseLoot.markPriceDataComplete();
            for (Reward reward : corpseLoot.rewards()) {
                if (PRICELESS_ITEMS.contains(reward.itemId())) continue;
                DoubleBooleanPair price = ItemUtils.getItemPrice(reward.itemId());
                if (!price.rightBoolean()) {
                    LOGGER.warn("No price found for item `{}`.", (Object)reward.itemId());
                    corpseLoot.markPriceDataIncomplete();
                    continue;
                }
                corpseLoot.profit(corpseLoot.profit() + price.leftDouble() * (double)reward.amount());
                reward.pricePerUnit(price.leftDouble());
            }
            try {
                corpseLoot.profit(corpseLoot.profit() - corpseLoot.corpseType().getKeyPrice());
            }
            catch (IllegalStateException e) {
                LOGGER.warn("No key price found for corpse type `{}`. Profit calculation will not be accurate.", (Object)corpseLoot.corpseType());
                corpseLoot.markPriceDataIncomplete();
            }
        }
    }

    public static @UnmodifiableView List<CorpseLoot> getCurrentProfileRewards() {
        return ObjectLists.unmodifiable(CorpseProfitTracker.INSTANCE.currentProfileRewards);
    }

    public static @UnmodifiableView Object2ObjectMap<String, String> getName2IdMap() {
        return Object2ObjectMaps.unmodifiable(NAME2ID_MAP);
    }

    static {
        NAME2ID_MAP.put((Object)"\u2620 Flawed Onyx Gemstone", (Object)"FLAWED_ONYX_GEM");
        NAME2ID_MAP.put((Object)"\u2620 Fine Onyx Gemstone", (Object)"FINE_ONYX_GEM");
        NAME2ID_MAP.put((Object)"\u2620 Flawless Onyx Gemstone", (Object)"FLAWLESS_ONYX_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Flawed Peridot Gemstone", (Object)"FLAWED_PERIDOT_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Fine Peridot Gemstone", (Object)"FINE_PERIDOT_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Flawless Peridot Gemstone", (Object)"FLAWLESS_PERIDOT_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Flawed Citrine Gemstone", (Object)"FLAWED_CITRINE_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Fine Citrine Gemstone", (Object)"FINE_CITRINE_GEM");
        NAME2ID_MAP.put((Object)"\u2618 Flawless Citrine Gemstone", (Object)"FLAWLESS_CITRINE_GEM");
        NAME2ID_MAP.put((Object)"\u03b1 Flawed Aquamarine Gemstone", (Object)"FLAWED_AQUAMARINE_GEM");
        NAME2ID_MAP.put((Object)"\u03b1 Fine Aquamarine Gemstone", (Object)"FINE_AQUAMARINE_GEM");
        NAME2ID_MAP.put((Object)"\u03b1 Flawless Aquamarine Gemstone", (Object)"FLAWLESS_AQUAMARINE_GEM");
        NAME2ID_MAP.put((Object)"Goblin Egg", (Object)"GOBLIN_EGG");
        NAME2ID_MAP.put((Object)"Green Goblin Egg", (Object)"GOBLIN_EGG_GREEN");
        NAME2ID_MAP.put((Object)"Blue Goblin Egg", (Object)"GOBLIN_EGG_BLUE");
        NAME2ID_MAP.put((Object)"Red Goblin Egg", (Object)"GOBLIN_EGG_RED");
        NAME2ID_MAP.put((Object)"Yellow Goblin Egg", (Object)"GOBLIN_EGG_YELLOW");
        NAME2ID_MAP.put((Object)"Enchanted Glacite", (Object)"ENCHANTED_GLACITE");
        NAME2ID_MAP.put((Object)"Enchanted Umber", (Object)"ENCHANTED_UMBER");
        NAME2ID_MAP.put((Object)"Enchanted Tungsten", (Object)"ENCHANTED_TUNGSTEN");
        NAME2ID_MAP.put((Object)"Refined Umber", (Object)"REFINED_UMBER");
        NAME2ID_MAP.put((Object)"Refined Tungsten", (Object)"REFINED_TUNGSTEN");
        NAME2ID_MAP.put((Object)"Refined Mithril", (Object)"REFINED_MITHRIL");
        NAME2ID_MAP.put((Object)"Refined Titanium", (Object)"REFINED_TITANIUM");
        NAME2ID_MAP.put((Object)"Umber Plate", (Object)"UMBER_PLATE");
        NAME2ID_MAP.put((Object)"Tungsten Plate", (Object)"TUNGSTEN_PLATE");
        NAME2ID_MAP.put((Object)"Glacite Amalgamation", (Object)"GLACITE_AMALGAMATION");
        NAME2ID_MAP.put((Object)"Bejeweled Handle", (Object)"BEJEWELED_HANDLE");
        NAME2ID_MAP.put((Object)"Umber Key", (Object)"UMBER_KEY");
        NAME2ID_MAP.put((Object)"Tungsten Key", (Object)"TUNGSTEN_KEY");
        NAME2ID_MAP.put((Object)"Glacite Jewel", (Object)"GLACITE_JEWEL");
        NAME2ID_MAP.put((Object)"Suspicious Scrap", (Object)"SUSPICIOUS_SCRAP");
        NAME2ID_MAP.put((Object)"Enchanted Book (Ice Cold I)", (Object)ENCHANTMENT_ICE_COLD_1);
        NAME2ID_MAP.put((Object)"Dwarven O's Metallic Minis", (Object)"DWARVEN_OS_METALLIC_MINIS");
        NAME2ID_MAP.put((Object)"Shattered Locket", (Object)"SHATTERED_PENDANT");
        NAME2ID_MAP.put((Object)"Frozen Scute", (Object)"FROZEN_SCUTE");
        NAME2ID_MAP.put((Object)"Frostbitten Dye", (Object)"DYE_FROSTBITTEN");
        NAME2ID_MAP.put((Object)"Opal Crystal", (Object)OPAL_CRYSTAL);
        NAME2ID_MAP.put((Object)"Onyx Crystal", (Object)ONYX_CRYSTAL);
        NAME2ID_MAP.put((Object)"Aquamarine Crystal", (Object)AQUAMARINE_CRYSTAL);
        NAME2ID_MAP.put((Object)"Peridot Crystal", (Object)PERIDOT_CRYSTAL);
        NAME2ID_MAP.put((Object)"Citrine Crystal", (Object)CITRINE_CRYSTAL);
        NAME2ID_MAP.put((Object)"Ruby Crystal", (Object)RUBY_CRYSTAL);
        NAME2ID_MAP.put((Object)"Jasper Crystal", (Object)JASPER_CRYSTAL);
        NAME2ID_MAP.put((Object)"Glacite Powder", (Object)GLACITE_POWDER);
    }
}

