/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.end;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.end.EndHudWidget;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1560;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheEnd {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TheEnd.class);
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("end.json");
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern END_STONE_PROTECTOR_TREMOR = Pattern.compile("^You feel a tremor from beneath the earth!$");
    private static final Pattern END_STONE_PROTECTOR_RISES = Pattern.compile("^The ground begins to shake as an End Stone Protector rises from below!$");
    private static final Pattern END_STONE_PROTECTOR_FIGHT_STARTS = Pattern.compile("^BEWARE - An End Stone Protector has risen!$");
    private static final Pattern SPECIAL_ZEALOT_SPAWNED = Pattern.compile("^A special Zealot has spawned nearby!$");
    private static final List<ProtectorLocation> PROTECTOR_LOCATIONS = List.of(new ProtectorLocation(-649, -219, (class_2561)class_2561.method_43471((String)"skyblocker.end.hud.protectorLocations.left")), new ProtectorLocation(-644, -269, (class_2561)class_2561.method_43471((String)"skyblocker.end.hud.protectorLocations.front")), new ProtectorLocation(-689, -273, (class_2561)class_2561.method_43471((String)"skyblocker.end.hud.protectorLocations.center")), new ProtectorLocation(-727, -284, (class_2561)class_2561.method_43471((String)"skyblocker.end.hud.protectorLocations.back")), new ProtectorLocation(-639, -328, (class_2561)class_2561.method_43471((String)"skyblocker.end.hud.protectorLocations.rightFront")), new ProtectorLocation(-678, -332, (class_2561)class_2561.method_43471((String)"skyblocker.end.hud.protectorLocations.rightBack")));
    private static final Set<UUID> HIT_ZEALOTS = new ObjectOpenHashSet();
    public static final ProfiledData<EndStats> PROFILES_STATS = new ProfiledData<EndStats>(FILE, EndStats.CODEC);
    public static @Nullable ProtectorLocation currentProtectorLocation = null;
    public static int stage = 0;

    @Init
    public static void init() {
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1560 enderman;
            if (entity instanceof class_1560 && TheEnd.isZealot(enderman = (class_1560)entity)) {
                HIT_ZEALOTS.add(enderman.method_5667());
            }
            return class_1269.field_5811;
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            block1: {
                ProtectorLocation protectorLocation;
                Area area = Utils.getArea();
                if (!Utils.isInTheEnd() && !area.equals(Area.TheEnd.THE_END) && !area.equals(Area.TheEnd.DRAGONS_NEST)) break block1;
                class_1923 pos = chunk.method_12004();
                class_238 box = new class_238((double)pos.method_8326(), 0.0, (double)pos.method_8328(), (double)(pos.method_8327() + 1), 1.0, (double)(pos.method_8329() + 1));
                Iterator<ProtectorLocation> iterator = PROTECTOR_LOCATIONS.iterator();
                while (!(!iterator.hasNext() || box.method_1008((double)(protectorLocation = iterator.next()).x(), 0.5, (double)protectorLocation.z()) && TheEnd.isProtectorHere(world, protectorLocation))) {
                }
            }
        });
        SkyblockEvents.PROFILE_CHANGE.register((prev, profile) -> EndHudWidget.getInstance().update());
        SkyblockEvents.LOCATION_CHANGE.register(location -> {
            TheEnd.resetLocation();
            HIT_ZEALOTS.clear();
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            if (!Utils.isInTheEnd() || overlay) {
                return true;
            }
            TheEnd.onMessage(message.getString());
            return true;
        });
        WorldRenderExtractionCallback.EVENT.register(TheEnd::extractRendering);
        PROFILES_STATS.init();
    }

    private static void onMessage(String text) {
        if (END_STONE_PROTECTOR_TREMOR.matcher(text).matches()) {
            if (stage == 0) {
                TheEnd.checkAllProtectorLocations();
            } else {
                ++stage;
            }
        } else if (END_STONE_PROTECTOR_RISES.matcher(text).matches()) {
            if (currentProtectorLocation == null) {
                TheEnd.checkAllProtectorLocations();
            }
            stage = 5;
        } else if (END_STONE_PROTECTOR_FIGHT_STARTS.matcher(text).matches()) {
            TheEnd.resetLocation();
        } else if (SPECIAL_ZEALOT_SPAWNED.matcher(text).matches()) {
            TheEnd.onSpecialZealot();
        }
        EndHudWidget.getInstance().update();
    }

    private static void checkAllProtectorLocations() {
        ProtectorLocation protectorLocation;
        class_638 world = TheEnd.CLIENT.field_1687;
        if (world == null) {
            return;
        }
        Iterator<ProtectorLocation> iterator = PROTECTOR_LOCATIONS.iterator();
        while (!(!iterator.hasNext() || world.method_8393((protectorLocation = iterator.next()).x() >> 4, protectorLocation.z() >> 4) && TheEnd.isProtectorHere(world, protectorLocation))) {
        }
    }

    private static boolean isProtectorHere(class_638 world, ProtectorLocation protectorLocation) {
        for (int i = 0; i < 5; ++i) {
            if (!world.method_8320(new class_2338(protectorLocation.x, i + 5, protectorLocation.z)).method_27852(class_2246.field_10432)) continue;
            stage = i + 1;
            currentProtectorLocation = protectorLocation;
            EndHudWidget.getInstance().update();
            return true;
        }
        return false;
    }

    private static void resetLocation() {
        stage = 0;
        currentProtectorLocation = null;
    }

    public static void onEntityDeath(class_1297 entity) {
        class_1560 enderman;
        if (!(entity instanceof class_1560) || !TheEnd.isZealot(enderman = (class_1560)entity)) {
            return;
        }
        if (HIT_ZEALOTS.contains(enderman.method_5667())) {
            EndStats stats = PROFILES_STATS.computeIfAbsent(EndStats.EMPTY);
            PROFILES_STATS.put(new EndStats(stats.totalZealotKills() + 1, stats.zealotsSinceLastEye() + 1, stats.eyes()));
            HIT_ZEALOTS.remove(enderman.method_5667());
            EndHudWidget.getInstance().update();
        }
    }

    public static void onSpecialZealot() {
        EndStats stats = PROFILES_STATS.computeIfAbsent(EndStats.EMPTY);
        PROFILES_STATS.put(new EndStats(stats.totalZealotKills(), 0, stats.eyes() + 1));
    }

    public static boolean isZealot(class_1560 enderman) {
        if (enderman.method_5477().getString().toLowerCase(Locale.ENGLISH).contains("zealot")) {
            return true;
        }
        assert (TheEnd.CLIENT.field_1687 != null);
        List entities = TheEnd.CLIENT.field_1687.method_8390(class_1531.class, enderman.method_18377(enderman.method_18376()).method_30757(enderman.method_73189()).method_1014(1.0), armorStandEntity -> armorStandEntity.method_5477().getString().toLowerCase(Locale.ENGLISH).contains("zealot"));
        return !entities.isEmpty();
    }

    public static boolean isSpecialZealot(class_1560 enderman) {
        class_2680 carriedBlock = enderman.method_7027();
        return carriedBlock != null && carriedBlock.method_27852(class_2246.field_10398) && TheEnd.isZealot(enderman);
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().otherLocations.end.waypoint) {
            return;
        }
        if (currentProtectorLocation == null || stage != 5) {
            return;
        }
        currentProtectorLocation.waypoint().extractRendering(collector);
    }

    public record ProtectorLocation(int x, int z, class_2561 name, Waypoint waypoint) {
        public ProtectorLocation(int x, int z, class_2561 name) {
            this(x, z, name, new Waypoint(new class_2338(x, 0, z), Waypoint.Type.WAYPOINT, ColorUtils.getFloatComponents(class_1767.field_7958)));
        }
    }

    public record EndStats(int totalZealotKills, int zealotsSinceLastEye, int eyes) {
        private static final Codec<EndStats> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("totalZealotKills").forGetter(EndStats::totalZealotKills), (App)Codec.INT.fieldOf("zealotsSinceLastEye").forGetter(EndStats::zealotsSinceLastEye), (App)Codec.INT.fieldOf("eyes").forGetter(EndStats::eyes)).apply((Applicative)instance, EndStats::new));
        public static final Supplier<EndStats> EMPTY = () -> new EndStats(0, 0, 0);
    }
}

