/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.entity;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.LividColor;
import de.hysky.skyblocker.skyblock.entity.MobGlow;
import de.hysky.skyblocker.skyblock.entity.glow.adder.DungeonGlowAdder;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.Renderable;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_238;

public class MobBoundingBoxes {
    private static final ObjectOpenHashSet<RenderableBox> BOXES_2_RENDER = new ObjectOpenHashSet();

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(MobBoundingBoxes::extractRendering);
    }

    public static boolean shouldDrawMobBoundingBox(class_1297 entity) {
        if (Utils.isInDungeons() && !entity.method_5767()) {
            boolean bl;
            String name = entity.method_5477().getString();
            class_1297 class_12972 = entity;
            Objects.requireNonNull(class_12972);
            class_1297 class_12973 = class_12972;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1657.class, class_1657.class, class_1531.class}, (Object)class_12973, n)) {
                    case 0: {
                        class_1657 _p = (class_1657)class_12973;
                        if (!(name.equals("Lost Adventurer") || name.equals("Shadow Assassin") || name.equals("Diamond Guy"))) {
                            n = 1;
                            continue block5;
                        }
                        bl = SkyblockerConfigManager.get().dungeons.starredMobBoundingBoxes;
                        break block5;
                    }
                    case 1: {
                        class_1657 _p = (class_1657)class_12973;
                        if (entity.method_5628() != LividColor.getCorrectLividId()) {
                            n = 2;
                            continue block5;
                        }
                        bl = LividColor.shouldDrawBoundingBox(name);
                        break block5;
                    }
                    case 2: {
                        class_1531 _armorStand = (class_1531)class_12973;
                        bl = false;
                        break block5;
                    }
                    default: {
                        if (SkyblockerConfigManager.get().dungeons.starredMobBoundingBoxes && DungeonGlowAdder.isStarred(entity)) {
                            bl = true;
                            break block5;
                        }
                        bl = false;
                        break block5;
                    }
                }
                break;
            }
            return bl;
        }
        return false;
    }

    public static float[] getBoxColor(class_1297 entity) {
        int color = MobGlow.getMobGlow(entity);
        return ColorUtils.getFloatComponents(color);
    }

    public static void submitBox2BeRendered(class_238 box, float[] colorComponents) {
        BOXES_2_RENDER.add((Object)new RenderableBox(box, colorComponents));
    }

    private static void extractRendering(PrimitiveCollector collector) {
        for (RenderableBox box : BOXES_2_RENDER) {
            box.extractRendering(collector);
        }
        BOXES_2_RENDER.clear();
    }

    private record RenderableBox(class_238 box, float[] colorComponents) implements Renderable
    {
        @Override
        public void extractRendering(PrimitiveCollector collector) {
            collector.submitOutlinedBox(this.box, this.colorComponents, 6.0f, false);
        }
    }
}

