/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.events;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.EventNotificationsConfig;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.events.EventToast;
import de.hysky.skyblocker.skyblock.events.JacobEventToast;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_368;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class EventNotifications {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String JACOBS = "Jacob's Farming Contest";
    public static final IntArrayList DEFAULT_REMINDERS = new IntArrayList(IntList.of((int)60, (int)300));
    public static final Map<String, class_1799> eventIcons = Map.ofEntries(Map.entry("Dark Auction", new class_1799((class_1935)class_1802.field_8729)), Map.entry("Bonus Fishing Festival", new class_1799((class_1935)class_1802.field_8378)), Map.entry("Bonus Mining Fiesta", new class_1799((class_1935)class_1802.field_8403)), Map.entry("Jacob's Farming Contest", new class_1799((class_1935)class_1802.field_8609)), Map.entry("New Year Celebration", new class_1799((class_1935)class_1802.field_17534)), Map.entry("Election Over!", new class_1799((class_1935)class_1802.field_8565)), Map.entry("Election Booth Opens", new class_1799((class_1935)class_1802.field_8565)), Map.entry("Spooky Festival", new class_1799((class_1935)class_1802.field_8693)), Map.entry("Season of Jerry", new class_1799((class_1935)class_1802.field_8543)), Map.entry("Jerry's Workshop Opens", new class_1799((class_1935)class_1802.field_8246)), Map.entry("Traveling Zoo", new class_1799((class_1935)class_1802.field_17528)));
    private static long currentTime = System.currentTimeMillis() / 1000L;
    private static final Map<String, LinkedList<SkyblockEvent>> events = new ConcurrentHashMap<String, LinkedList<SkyblockEvent>>();

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(EventNotifications::timeUpdate, 20);
        SkyblockEvents.JOIN.register(EventNotifications::refreshEvents);
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> debugToasts() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"toasts").then(ClientCommandManager.argument((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0)).then(ClientCommandManager.argument((String)"jacob", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            long time = System.currentTimeMillis() / 1000L + (long)((Integer)context.getArgument("time", Integer.TYPE)).intValue();
            if (((Boolean)context.getArgument("jacob", Boolean.class)).booleanValue()) {
                class_310.method_1551().method_1566().method_1999((class_368)new JacobEventToast(time, "Jacob's farming contest", new String[]{"Cactus", "Cocoa Beans", "Pumpkin"}));
            } else {
                class_310.method_1551().method_1566().method_1999((class_368)new EventToast(time, "Jacob's or something idk", new class_1799((class_1935)class_1802.field_8407)));
            }
            return 0;
        })));
    }

    public static Map<String, LinkedList<SkyblockEvent>> getEvents() {
        return events;
    }

    public static void refreshEvents() {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                JsonArray jsonElements = SkyblockerMod.GSON.fromJson(Http.sendGetRequest("https://hysky.de/api/calendar"), JsonArray.class);
                return jsonElements.asList().stream().map(JsonElement::getAsJsonObject).toList();
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to download events list", (Throwable)e);
                return List.of();
            }
        }, Executors.newVirtualThreadPerTaskExecutor()).thenAccept(eventsList -> {
            events.clear();
            for (JsonObject jsonObject : eventsList) {
                if (jsonObject.get("timestamp").getAsLong() + (long)jsonObject.get("duration").getAsInt() < currentTime) continue;
                SkyblockEvent skyblockEvent = SkyblockEvent.of(jsonObject);
                events.computeIfAbsent(jsonObject.get("event").getAsString(), s -> new LinkedList()).add(skyblockEvent);
            }
            for (Map.Entry entry : events.entrySet()) {
                ((LinkedList)entry.getValue()).sort(Comparator.comparingLong(SkyblockEvent::start));
            }
            for (String string : events.keySet()) {
                SkyblockerConfigManager.get().eventNotifications.eventsReminderTimes.computeIfAbsent(string, s1 -> DEFAULT_REMINDERS);
            }
        })).exceptionally(EventNotifications::itBorked);
    }

    private static Void itBorked(Throwable throwable) {
        LOGGER.error("[Skyblocker] Event loading borked, sowwy :(", throwable);
        return null;
    }

    private static void timeUpdate() {
        long newTime = System.currentTimeMillis() / 1000L;
        block0: for (Map.Entry<String, LinkedList<SkyblockEvent>> entry : events.entrySet()) {
            String eventName;
            List reminderTimes;
            LinkedList<SkyblockEvent> nextEvents = entry.getValue();
            SkyblockEvent skyblockEvent = nextEvents.peekFirst();
            if (skyblockEvent == null) continue;
            if (newTime > skyblockEvent.start() + (long)skyblockEvent.duration()) {
                nextEvents.pollFirst();
                skyblockEvent = nextEvents.peekFirst();
                if (skyblockEvent == null) continue;
            }
            if ((reminderTimes = (List)SkyblockerConfigManager.get().eventNotifications.eventsReminderTimes.getOrDefault(eventName = entry.getKey(), DEFAULT_REMINDERS)).isEmpty()) continue;
            Iterator iterator = reminderTimes.iterator();
            while (iterator.hasNext()) {
                class_3414 soundEvent;
                int reminderTime = (Integer)iterator.next();
                if (!EventNotifications.criterionMet() || currentTime + (long)reminderTime >= skyblockEvent.start() || newTime + (long)reminderTime < skyblockEvent.start()) continue;
                class_310 instance = class_310.method_1551();
                if (eventName.equals(JACOBS)) {
                    instance.method_1566().method_1999((class_368)new JacobEventToast(skyblockEvent.start(), eventName, skyblockEvent.extras()));
                } else {
                    instance.method_1566().method_1999((class_368)new EventToast(skyblockEvent.start(), eventName, eventIcons.getOrDefault(eventName, new class_1799((class_1935)class_1802.field_8407))));
                }
                if ((soundEvent = SkyblockerConfigManager.get().eventNotifications.reminderSound.getSoundEvent()) == null) continue block0;
                instance.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)1.0f, (float)1.0f));
                continue block0;
            }
        }
        currentTime = newTime;
    }

    private static boolean criterionMet() {
        return switch (SkyblockerConfigManager.get().eventNotifications.criterion) {
            default -> throw new MatchException(null, null);
            case EventNotificationsConfig.Criterion.NONE -> false;
            case EventNotificationsConfig.Criterion.SKYBLOCK -> Utils.isOnSkyblock();
            case EventNotificationsConfig.Criterion.HYPIXEL -> Utils.isOnHypixel();
            case EventNotificationsConfig.Criterion.EVERYWHERE -> true;
        };
    }

    public record SkyblockEvent(long start, int duration, String[] extras, @Nullable String warpCommand) {
        public static SkyblockEvent of(JsonObject jsonObject) {
            String location = jsonObject.get("location").getAsString();
            location = location.isBlank() ? null : location;
            return new SkyblockEvent(jsonObject.get("timestamp").getAsLong(), jsonObject.get("duration").getAsInt(), (String[])jsonObject.get("extras").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toArray(String[]::new), location);
        }
    }
}

