/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.experiment;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.HelperConfig;
import de.hysky.skyblocker.skyblock.experiment.ChronomatronSolver;
import de.hysky.skyblocker.skyblock.experiment.SuperpairsSolver;
import de.hysky.skyblocker.skyblock.experiment.UltrasequencerSolver;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.StackDisplayModifier;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_476;
import org.intellij.lang.annotations.Language;

public abstract sealed class ExperimentSolver
extends SimpleContainerSolver
implements StackDisplayModifier
permits ChronomatronSolver, SuperpairsSolver, UltrasequencerSolver {
    private State state = State.REMEMBER;
    private final Int2ObjectMap<class_1799> slots = new Int2ObjectOpenHashMap();

    protected ExperimentSolver(@Language(value="RegExp") String containerName) {
        super(containerName);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Int2ObjectMap<class_1799> getSlots() {
        return this.slots;
    }

    @Override
    public final boolean isEnabled() {
        return this.isEnabled(SkyblockerConfigManager.get().helpers.experiments);
    }

    protected abstract boolean isEnabled(HelperConfig.Experiments var1);

    protected boolean shouldBlockIncorrectClicks() {
        return SkyblockerConfigManager.get().helpers.experiments.blockIncorrectClicks;
    }

    @Override
    public void start(class_476 screen) {
        this.state = State.REMEMBER;
        ScreenEvents.afterTick((class_437)screen).register(ignored -> this.tick(screen));
    }

    @Override
    public void reset() {
        this.state = State.REMEMBER;
        this.slots.clear();
    }

    protected abstract void tick(class_476 var1);

    @Override
    public class_1799 modifyDisplayStack(int slotIndex, class_1799 stack) {
        if ((this instanceof SuperpairsSolver || this instanceof UltrasequencerSolver) && this.getState() == State.SHOW) {
            class_1799 displayStack = (class_1799)this.getSlots().get(slotIndex);
            return displayStack != null ? displayStack : stack;
        }
        return stack;
    }

    public static enum State {
        REMEMBER,
        WAIT,
        SHOW,
        END;

    }
}

