/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fancybars;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.StatusBarTracker;
import de.hysky.skyblocker.skyblock.fancybars.FancyStatusBars;
import de.hysky.skyblocker.utils.Utils;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class VanillaStyleManaBar {
    private static int lastManaValue;
    private static int manaValueBlinkStart;
    private static int lastOverflowValue;
    private static int overflowValueBlinkStart;
    private static long blinkEndTime;
    private static final class_2960 MANABAR_FOOD_HUD_ID;
    private static final class_2960 MANABAR_MOUNT_HUD_ID;
    private static final class_2960 CONTAINER_TEXTURE;
    private static final class_2960 MANA_FULL_TEXTURE;
    private static final class_2960 MANA_HALF_TEXTURE;
    private static final class_2960 OVERFLOW_FULL_TEXTURE;
    private static final class_2960 OVERFLOW_HALF_TEXTURE;
    private static final class_2960 OVERFLOW_DARK_FULL_TEXTURE;
    private static final class_2960 OVERFLOW_DARK_HALF_TEXTURE;
    private static final class_2960 CONTAINER_BLINK_TEXTURE;
    private static final class_2960 MANA_FULL_BLINK_TEXTURE;
    private static final class_2960 MANA_HALF_BLINK_TEXTURE;
    private static final class_2960 OVERFLOW_FULL_BLINK_TEXTURE;
    private static final class_2960 OVERFLOW_HALF_BLINK_TEXTURE;
    private static final class_2960 OVERFLOW_DARK_FULL_BLINK_TEXTURE;
    private static final class_2960 OVERFLOW_DARK_HALF_BLINK_TEXTURE;

    @Init
    public static void init() {
        Function<HudElement, HudElement> hideIfVanillaStyleManaBarEnabled = hudElement -> {
            if (VanillaStyleManaBar.isEnabled()) {
                return (context, tickCounter) -> {};
            }
            return hudElement;
        };
        HudElementRegistry.replaceElement((class_2960)VanillaHudElements.FOOD_BAR, hideIfVanillaStyleManaBarEnabled);
        HudElementRegistry.replaceElement((class_2960)VanillaHudElements.MOUNT_HEALTH, hideIfVanillaStyleManaBarEnabled);
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.FOOD_BAR, (class_2960)MANABAR_FOOD_HUD_ID, (context, tickCounter) -> {
            if (VanillaStyleManaBar.isEnabled()) {
                VanillaStyleManaBar.render(context);
            }
        });
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.MOUNT_HEALTH, (class_2960)MANABAR_MOUNT_HUD_ID, (context, tickCounter) -> {
            if (VanillaStyleManaBar.isEnabled()) {
                VanillaStyleManaBar.render(context);
            }
        });
    }

    private static boolean isEnabled() {
        return Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.bars.enableVanillaStyleManaBar && !FancyStatusBars.isEnabled();
    }

    private static void drawNotch(class_332 context, int column, int row, NotchType notchtype, boolean isHalf, boolean isBlinking) {
        int top = context.method_51443() - 39;
        int right = context.method_51421() / 2 + 91;
        class_2960 texture = switch (notchtype.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (isBlinking) {
                    yield CONTAINER_BLINK_TEXTURE;
                }
                yield CONTAINER_TEXTURE;
            }
            case 1 -> {
                if (!isHalf) {
                    if (isBlinking) {
                        yield MANA_FULL_BLINK_TEXTURE;
                    }
                    yield MANA_FULL_TEXTURE;
                }
                if (isBlinking) {
                    yield MANA_HALF_BLINK_TEXTURE;
                }
                yield MANA_HALF_TEXTURE;
            }
            case 2 -> {
                if (!isHalf) {
                    if (isBlinking) {
                        yield OVERFLOW_FULL_BLINK_TEXTURE;
                    }
                    yield OVERFLOW_FULL_TEXTURE;
                }
                if (isBlinking) {
                    yield OVERFLOW_HALF_BLINK_TEXTURE;
                }
                yield OVERFLOW_HALF_TEXTURE;
            }
            case 3 -> {
                if (!isHalf) {
                    if (isBlinking) {
                        yield OVERFLOW_DARK_FULL_BLINK_TEXTURE;
                    }
                    yield OVERFLOW_DARK_FULL_TEXTURE;
                }
                yield isBlinking ? OVERFLOW_DARK_HALF_BLINK_TEXTURE : OVERFLOW_DARK_HALF_TEXTURE;
            }
        };
        context.method_52706(class_10799.field_56883, texture, right - column * 8 - 9, top - row * 10, 9, 9);
    }

    public static boolean render(class_332 context) {
        boolean blinking;
        StatusBarTracker.Resource mana = StatusBarTracker.getMana();
        long currentTime = class_156.method_658();
        long BLINK_TIME_LENGTH = 1000L;
        long BLINK_FREQUENCY = 300L;
        if (lastManaValue + lastOverflowValue > mana.value() + mana.overflow() && mana.value() != mana.max()) {
            boolean justStartedBlinking;
            boolean bl = justStartedBlinking = blinkEndTime <= currentTime;
            if (justStartedBlinking) {
                manaValueBlinkStart = lastManaValue;
                overflowValueBlinkStart = lastOverflowValue;
            }
            blinkEndTime = blinkEndTime >= currentTime ? (currentTime + 1000L) / 300L * 300L + blinkEndTime % 300L : currentTime + 1000L;
        }
        boolean bl = blinking = blinkEndTime > currentTime && (blinkEndTime - currentTime) / 150L % 2L == 1L;
        if (blinkEndTime <= currentTime) {
            manaValueBlinkStart = 0;
            overflowValueBlinkStart = 0;
        }
        lastManaValue = mana.value();
        lastOverflowValue = mana.overflow();
        int MANA_NOTCH_COUNT = 20;
        int manaHalfNotches = mana.value() * 20 * 2 / mana.max();
        int manaNotches = (int)Math.ceil((double)manaHalfNotches / 2.0);
        int manaBlinkHalfNotches = manaValueBlinkStart * 20 * 2 / mana.max();
        int manaBlinkNotches = (int)Math.ceil((double)manaBlinkHalfNotches / 2.0);
        int overflowHalfNotches = mana.overflow() * 20 * 2 / mana.max();
        int overflowNotches = (int)Math.ceil((double)overflowHalfNotches / 2.0);
        int overflowBlinkHalfNotches = overflowValueBlinkStart * 20 * 2 / mana.max();
        int overflowBlinkNotches = (int)Math.ceil((double)overflowBlinkHalfNotches / 2.0);
        for (int i = 0; i < 20; ++i) {
            int row = i / 10;
            int column = i % 10;
            boolean manaNotch = i < manaNotches;
            boolean manaNotchIsHalf = manaNotch && manaNotches - 1 == i && manaHalfNotches % 2 == 1;
            boolean manaBlinkNotch = i < manaBlinkNotches;
            boolean manaBlinkNotchIsHalf = manaBlinkNotch && manaBlinkNotches - 1 == i && manaBlinkHalfNotches % 2 == 1;
            boolean overflowNotch = i < overflowNotches;
            boolean overflowNotchIsHalf = overflowNotch && overflowNotches - 1 == i && overflowHalfNotches % 2 == 1;
            boolean overflowBlinkNotch = i < overflowBlinkNotches;
            boolean overflowBlinkNotchIsHalf = overflowBlinkNotch && overflowBlinkNotches - 1 == i && overflowBlinkHalfNotches % 2 == 1;
            VanillaStyleManaBar.drawNotch(context, column, row, NotchType.CONTAINER, false, blinking);
            if (manaNotches > 0) {
                if (overflowNotch) {
                    VanillaStyleManaBar.drawNotch(context, column, row, NotchType.OVERFLOW_DARK, overflowNotchIsHalf, blinking);
                }
                if (manaBlinkNotch && blinking) {
                    VanillaStyleManaBar.drawNotch(context, column, row, NotchType.MANA, manaBlinkNotchIsHalf, true);
                }
                if (!manaNotch) continue;
                VanillaStyleManaBar.drawNotch(context, column, row, NotchType.MANA, manaNotchIsHalf, false);
                continue;
            }
            if (manaBlinkNotch && blinking) {
                VanillaStyleManaBar.drawNotch(context, column, row, NotchType.MANA, manaBlinkNotchIsHalf, true);
            }
            if (overflowBlinkNotch && blinking) {
                VanillaStyleManaBar.drawNotch(context, column, row, NotchType.OVERFLOW, overflowBlinkNotchIsHalf, true);
            }
            if (!overflowNotch) continue;
            VanillaStyleManaBar.drawNotch(context, column, row, NotchType.OVERFLOW, overflowNotchIsHalf, false);
        }
        return true;
    }

    static {
        MANABAR_FOOD_HUD_ID = SkyblockerMod.id("vanilla_style_mana_bar_food");
        MANABAR_MOUNT_HUD_ID = SkyblockerMod.id("vanilla_style_mana_bar_mount");
        CONTAINER_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/container");
        MANA_FULL_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/mana_full");
        MANA_HALF_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/mana_half");
        OVERFLOW_FULL_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_full");
        OVERFLOW_HALF_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_half");
        OVERFLOW_DARK_FULL_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_dark_full");
        OVERFLOW_DARK_HALF_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_dark_half");
        CONTAINER_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/container_blink");
        MANA_FULL_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/mana_full_blink");
        MANA_HALF_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/mana_half_blink");
        OVERFLOW_FULL_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_full_blink");
        OVERFLOW_HALF_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_half_blink");
        OVERFLOW_DARK_FULL_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_dark_full_blink");
        OVERFLOW_DARK_HALF_BLINK_TEXTURE = SkyblockerMod.id("bars/vanilla_mana/overflow_dark_half_blink");
    }

    static enum NotchType {
        CONTAINER,
        MANA,
        OVERFLOW,
        OVERFLOW_DARK;

    }
}

