/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.galatea.SweepDetailsHudWidget;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.chat.ChatFilterResult;
import de.hysky.skyblocker.utils.chat.ChatMessageListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;

public class SweepDetailsListener
implements ChatMessageListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final Pattern SWEEP_DETAILS = Pattern.compile("Sweep Details: ([\\d.]+)\u222e Sweep");
    protected static final Pattern TREE_TOUGHNESS = Pattern.compile("  (.+?) Tree Toughness: ([\\d.]+) ([\\d.]+) Logs");
    protected static final Pattern AXE_THROW_PENALTY = Pattern.compile("  Axe throw: (-\\d+)% Sweep ([\\d.]+) Logs");
    protected static final Pattern WRONG_STYLE_PENALTY = Pattern.compile("  Wrong Style: (-\\d+)% Sweep ([\\d.]+) Logs ([a-zA-Z ]*)!!");
    public static boolean active = false;
    public static float lastMatch = -1.0f;
    public static float maxSweep = -1.0f;
    public static float lastSweep = -1.0f;
    public static String lastTreeType = "Unknown";
    public static String toughness;
    public static String logs;
    public static boolean axePenalty;
    public static float axePenaltyAmount;
    public static boolean stylePenalty;
    public static float stylePenaltyAmount;
    public static String correctStyle;

    private static void resetStats() {
        active = false;
        lastMatch = -1.0f;
        maxSweep = -1.0f;
        lastSweep = -1.0f;
        lastTreeType = "Unknown";
        axePenalty = false;
        stylePenalty = false;
        toughness = "";
        logs = "";
        axePenaltyAmount = -1.0f;
        stylePenaltyAmount = -1.0f;
        correctStyle = "";
    }

    private static float parsePenalty(String rawPenaltyAmount) {
        float penaltyAmount;
        if (NumberUtils.isCreatable((String)rawPenaltyAmount)) {
            penaltyAmount = Float.parseFloat(rawPenaltyAmount);
            lastSweep *= 1.0f - -penaltyAmount / 100.0f;
        } else {
            penaltyAmount = -1.0f;
        }
        return penaltyAmount;
    }

    private static void logMessage(String chatMessage) {
        LOGGER.info("[CHAT] {}", (Object)chatMessage);
    }

    @Override
    public ChatFilterResult onMessage(class_2561 message, String asString) {
        if (!SweepDetailsHudWidget.LOCATIONS.contains((Object)Utils.getLocation())) {
            return ChatFilterResult.PASS;
        }
        if (!SkyblockerConfigManager.get().foraging.galatea.enableSweepDetailsWidget) {
            return ChatFilterResult.PASS;
        }
        String msg = message.getString();
        Matcher sweepDetails = SWEEP_DETAILS.matcher(msg);
        if (sweepDetails.matches()) {
            SweepDetailsListener.resetStats();
            active = true;
            lastMatch = System.currentTimeMillis();
            String rawMaxSweep = sweepDetails.group(1);
            maxSweep = NumberUtils.isCreatable((String)rawMaxSweep) ? Float.parseFloat(rawMaxSweep) : -1.0f;
            lastSweep = maxSweep;
            SweepDetailsListener.logMessage(msg);
            return ChatFilterResult.FILTER;
        }
        if (active && (float)System.currentTimeMillis() > lastMatch + 1000.0f) {
            active = false;
        }
        if (!active) {
            return ChatFilterResult.PASS;
        }
        Matcher treeToughness = TREE_TOUGHNESS.matcher(msg);
        if (treeToughness.matches()) {
            lastTreeType = treeToughness.group(1);
            toughness = treeToughness.group(2);
            logs = treeToughness.group(3);
            SweepDetailsListener.logMessage(msg);
            return ChatFilterResult.FILTER;
        }
        Matcher axeThrow = AXE_THROW_PENALTY.matcher(msg);
        if (axeThrow.matches()) {
            axePenalty = true;
            axePenaltyAmount = SweepDetailsListener.parsePenalty(axeThrow.group(1));
            logs = axeThrow.group(2);
            SweepDetailsListener.logMessage(msg);
            return ChatFilterResult.FILTER;
        }
        Matcher wrongStyle = WRONG_STYLE_PENALTY.matcher(msg);
        if (wrongStyle.matches()) {
            stylePenalty = true;
            stylePenaltyAmount = SweepDetailsListener.parsePenalty(wrongStyle.group(1));
            logs = wrongStyle.group(2);
            correctStyle = wrongStyle.group(3);
            SweepDetailsListener.logMessage(msg);
            return ChatFilterResult.FILTER;
        }
        return ChatFilterResult.PASS;
    }
}

