/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.galatea;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.PlaySoundEvents;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2767;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_476;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunerSolver
extends SimpleContainerSolver
implements SlotTextAdder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TunerSolver.class);
    public static final TunerSolver INSTANCE = new TunerSolver();
    private static final class_1792[] COLOR_CYCLE = new class_1792[]{class_1802.field_8669, class_1802.field_8273, class_1802.field_8192, class_1802.field_8131, class_1802.field_8330, class_1802.field_8632, class_1802.field_8296, class_1802.field_8759, class_1802.field_8116, class_1802.field_8408, class_1802.field_8264, class_1802.field_8324, class_1802.field_8492};
    private static final class_1792[] GLASS_CYCLE = new class_1792[]{class_1802.field_8119, class_1802.field_8196, class_1802.field_8703, class_1802.field_8581, class_1802.field_8500, class_1802.field_8085, class_1802.field_8739, class_1802.field_8747, class_1802.field_8501, class_1802.field_8656, class_1802.field_8879, class_1802.field_8736, class_1802.field_8761};
    private static final String[] PITCH_CYCLE = new String[]{"Low", "Normal", "High"};
    private static final float[] PITCH_VALUES = new float[]{0.0952381f, 0.7936508f, 1.4920635f};
    private static final int[] SPEED_CYCLE = new int[]{1, 2, 3, 4, 5};
    private static final int[][] SPEED_RANGES = new int[][]{{50, 64}, {40, 49}, {30, 39}, {20, 29}, {10, 19}};
    private int colorClicks = 0;
    private int speedClicks = 0;
    private int pitchClicks = 0;
    private boolean colorSolved = false;
    private boolean speedSolved = false;
    private boolean pitchSolved = false;
    private boolean hasProcessed = false;
    private boolean isInMenu = false;
    private String currentPitch = null;
    private final List<Float> recentPitches = new ArrayList<Float>();
    private static final int MAX_PITCH_SAMPLES = 5;
    private int lastTargetSlot = -1;
    private int ticksSinceLastMove = 0;
    private int targetSpeed = -1;
    private int lastSpeedTicks = 0;

    private TunerSolver() {
        super("^Tune Frequency$");
        PlaySoundEvents.FROM_SERVER.register(this::onSound);
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().foraging.galatea.enableTunerSolver;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        class_1799 dyeStack;
        if (!this.hasProcessed && (dyeStack = (class_1799)slots.get(46)) != null && !dyeStack.method_7960() && TunerSolver.isDye(dyeStack.method_7909())) {
            if (!this.colorSolved) {
                this.colorClicks = TunerSolver.computeColorClicks(slots);
                this.colorSolved = true;
            }
            if (!this.speedSolved) {
                this.maybeSolveSpeed(slots);
            }
            if (!this.pitchSolved) {
                this.currentPitch = TunerSolver.readCurrentPitch(slots);
            }
            this.hasProcessed = true;
        }
        return List.of();
    }

    @Override
    public void start(class_476 screen) {
        this.resetState();
        this.isInMenu = true;
        ScreenEvents.afterTick((class_437)screen).register(s -> {
            Int2ObjectMap<class_1799> slots = TunerSolver.getSlots(screen);
            this.trackTargetPaneMovement(slots);
        });
        ScreenEvents.remove((class_437)screen).register(s -> this.resetState());
    }

    @Override
    public void reset() {
        this.resetState();
    }

    @Override
    public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
        if (!this.isEnabled()) {
            return List.of();
        }
        if (slotId == 46 && this.colorSolved) {
            return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)String.valueOf(this.colorClicks)).method_54663(0x90EE90));
        }
        if (slotId == 48 && this.speedSolved) {
            return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)String.valueOf(this.speedClicks)).method_54663(0x90EE90));
        }
        if (slotId == 50 && this.pitchSolved) {
            return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)String.valueOf(this.pitchClicks)).method_54663(0x90EE90));
        }
        return List.of();
    }

    @Override
    public boolean onClickSlot(int slotId, class_1799 stack, int screenId, int button) {
        int delta;
        if (!SkyblockerConfigManager.get().foraging.galatea.enableTunerSolver) {
            return false;
        }
        if (!this.isInMenu) {
            return false;
        }
        if (button != 0 && button != 1) {
            return false;
        }
        int n = delta = button == 0 ? -1 : 1;
        if (this.colorSolved && slotId == 46) {
            this.colorClicks = TunerSolver.updateClicks(this.colorClicks, COLOR_CYCLE.length, delta);
        } else if (this.speedSolved && slotId == 48) {
            this.speedClicks = TunerSolver.updateClicks(this.speedClicks, SPEED_CYCLE.length, delta);
        } else if (this.pitchSolved && slotId == 50) {
            this.pitchClicks = TunerSolver.updateClicks(this.pitchClicks, PITCH_CYCLE.length, delta);
        }
        return false;
    }

    private static int updateClicks(int clicks, int cycleLength, int delta) {
        int forward = clicks >= 0 ? clicks : cycleLength + clicks;
        forward = (forward + delta + cycleLength) % cycleLength;
        int backward = cycleLength - forward;
        return forward <= backward ? forward : -backward;
    }

    private void resetState() {
        this.hasProcessed = false;
        this.isInMenu = false;
        this.colorSolved = false;
        this.speedSolved = false;
        this.pitchSolved = false;
        this.colorClicks = 0;
        this.speedClicks = 0;
        this.pitchClicks = 0;
        this.currentPitch = null;
        this.recentPitches.clear();
        this.lastTargetSlot = -1;
        this.ticksSinceLastMove = 0;
        this.targetSpeed = -1;
        this.lastSpeedTicks = 0;
    }

    private void trackTargetPaneMovement(Int2ObjectMap<class_1799> slots) {
        int currentTargetSlot = -1;
        for (int slot = 10; slot <= 16; ++slot) {
            class_1799 stack = (class_1799)slots.get(slot);
            if (stack == null || !TunerSolver.isStainedGlassPane(stack.method_7909())) continue;
            currentTargetSlot = slot;
            break;
        }
        if (currentTargetSlot != this.lastTargetSlot && this.lastTargetSlot != -1) {
            int ticks = this.ticksSinceLastMove;
            this.targetSpeed = -1;
            for (int i = 0; i < SPEED_RANGES.length; ++i) {
                if (ticks < SPEED_RANGES[i][0] || ticks > SPEED_RANGES[i][1]) continue;
                this.targetSpeed = SPEED_CYCLE[i];
                break;
            }
            if (this.targetSpeed == -1) {
                LOGGER.warn("Tick interval {} does not match any speed range", (Object)ticks);
            }
            this.lastSpeedTicks = ticks;
            this.ticksSinceLastMove = 0;
            if (!this.speedSolved) {
                this.maybeSolveSpeed(slots);
            }
        } else if (currentTargetSlot != -1) {
            ++this.ticksSinceLastMove;
        }
        this.lastTargetSlot = currentTargetSlot;
    }

    private static int computeColorClicks(Int2ObjectMap<class_1799> slots) {
        class_1799 dyeStack = (class_1799)slots.get(46);
        if (dyeStack == null || dyeStack.method_7960()) {
            LOGGER.warn("No dye found in slot 46");
            return 0;
        }
        class_1792 dyeItem = dyeStack.method_7909();
        int dyeIndex = TunerSolver.getColorIndex(dyeItem, COLOR_CYCLE);
        if (dyeIndex == -1) {
            LOGGER.warn("Invalid dye item in slot 46: {}", (Object)dyeItem);
            return 0;
        }
        class_1799 movingPane = null;
        int movingSlot = -1;
        for (int slot = 28; slot <= 34; ++slot) {
            class_1799 stack = (class_1799)slots.get(slot);
            if (stack == null || !TunerSolver.isStainedGlassPane(stack.method_7909())) continue;
            movingPane = stack;
            movingSlot = slot;
            break;
        }
        if (movingPane == null) {
            LOGGER.warn("No stained glass pane found in slots 28\u201334");
            return 0;
        }
        class_1792 movingItem = movingPane.method_7909();
        int movingIndex = TunerSolver.getColorIndex(movingItem, GLASS_CYCLE);
        if (movingIndex == -1) {
            LOGGER.warn("Invalid glass pane item in slot {}: {}", (Object)movingSlot, (Object)movingItem);
            return 0;
        }
        class_1799 targetPane = null;
        int targetSlot = -1;
        for (int slot = 10; slot <= 16; ++slot) {
            class_1799 stack = (class_1799)slots.get(slot);
            if (stack == null || !TunerSolver.isStainedGlassPane(stack.method_7909())) continue;
            targetPane = stack;
            targetSlot = slot;
            break;
        }
        if (targetPane == null) {
            LOGGER.warn("No stained glass pane found in slots 10\u201316");
            return 0;
        }
        class_1792 targetItem = targetPane.method_7909();
        int targetIndex = TunerSolver.getColorIndex(targetItem, GLASS_CYCLE);
        if (targetIndex == -1) {
            LOGGER.warn("Invalid glass pane item in slot {}: {}", (Object)targetSlot, (Object)targetItem);
            return 0;
        }
        int clicks = TunerSolver.calculateClicks(dyeIndex, targetIndex);
        LOGGER.info("Color solved: Dye={}, Target={}, Required clicks={}", new Object[]{dyeStack.method_7964().getString(), targetPane.method_7964().getString(), clicks >= 0 ? "+" + clicks : Integer.valueOf(clicks)});
        return clicks;
    }

    private void onSound(class_2767 packet) {
        if (!(SkyblockerConfigManager.get().foraging.galatea.enableTunerSolver && !this.pitchSolved && Utils.isInGalatea() && this.isInMenu && ((class_3414)packet.method_11894().comp_349()).comp_3319().equals((Object)((class_3414)class_3417.field_14624.comp_349()).comp_3319()))) {
            return;
        }
        float packetPitch = packet.method_11892();
        this.recentPitches.add(Float.valueOf(packetPitch));
        int sampleCount = this.recentPitches.size();
        String name = TunerSolver.getPitchName(packetPitch);
        if (this.currentPitch == null) {
            LOGGER.warn("Current pitch not set, cannot compare");
            this.recentPitches.clear();
            return;
        }
        float expectedPitch = TunerSolver.getPitchValue(this.currentPitch);
        if (Math.abs(packetPitch - expectedPitch) > 1.0E-4f) {
            String targetPitch = name;
            if (targetPitch == null) {
                LOGGER.warn("Invalid pitch value received: {}", (Object)Float.valueOf(packetPitch));
                this.recentPitches.clear();
                return;
            }
            int currentIndex = TunerSolver.getPitchIndex(this.currentPitch);
            int targetIndex = TunerSolver.getPitchIndex(targetPitch);
            if (currentIndex == -1 || targetIndex == -1) {
                LOGGER.warn("Invalid pitch indices: current={}, target={}", (Object)this.currentPitch, (Object)targetPitch);
                this.recentPitches.clear();
                return;
            }
            int clicks = TunerSolver.calculatePitchClicks(currentIndex, targetIndex);
            LOGGER.info("Pitch solved: Current={}, Target={}, Required clicks={}", new Object[]{this.currentPitch, targetPitch, clicks >= 0 ? "+" + clicks : Integer.valueOf(clicks)});
            this.pitchClicks = clicks;
            this.pitchSolved = true;
            this.recentPitches.clear();
            return;
        }
        if (sampleCount >= 5) {
            this.pitchClicks = 0;
            this.pitchSolved = true;
            LOGGER.info("Pitch solved: Current={}, Target={}, Required clicks=+0 (all samples match)", (Object)this.currentPitch, (Object)this.currentPitch);
            this.recentPitches.clear();
        }
    }

    private static int readCurrentSpeed(Int2ObjectMap<class_1799> slots) {
        List lore;
        class_1799 speedStack = (class_1799)slots.get(48);
        if (speedStack != null && !speedStack.method_7960() && (lore = speedStack.skyblocker$getLoreStrings()).size() >= 4) {
            try {
                String speedText = (String)lore.get(3);
                String[] parts = speedText.split(": ");
                int currentSpeed = Integer.parseInt(parts[1].trim());
                if (currentSpeed >= 1 && currentSpeed <= 5) {
                    return currentSpeed;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String readCurrentPitch(Int2ObjectMap<class_1799> slots) {
        List lore;
        class_1799 pitchStack = (class_1799)slots.get(50);
        if (pitchStack != null && !pitchStack.method_7960() && (lore = pitchStack.skyblocker$getLoreStrings()).size() >= 3) {
            String pitchText = (String)lore.get(2);
            if (pitchText.contains("Low")) {
                return "Low";
            }
            if (pitchText.contains("Normal")) {
                return "Normal";
            }
            if (pitchText.contains("High")) {
                return "High";
            }
        }
        return null;
    }

    private void maybeSolveSpeed(Int2ObjectMap<class_1799> slots) {
        int currentSpeed = TunerSolver.readCurrentSpeed(slots);
        if (currentSpeed > 0 && this.targetSpeed != -1) {
            int currentIndex = TunerSolver.getSpeedIndex(currentSpeed);
            int targetIndex = TunerSolver.getSpeedIndex(this.targetSpeed);
            if (currentIndex != -1 && targetIndex != -1) {
                this.speedClicks = TunerSolver.calculateSpeedClicks(currentIndex, targetIndex);
                this.speedSolved = true;
                LOGGER.info("Speed solved: Current={}, Target={}, Ticks={}, Required clicks={}", new Object[]{currentSpeed, this.targetSpeed, this.lastSpeedTicks, this.speedClicks >= 0 ? "+" + this.speedClicks : Integer.valueOf(this.speedClicks)});
            } else {
                LOGGER.warn("Invalid speed indices: current={}, target={}", (Object)currentSpeed, (Object)this.targetSpeed);
            }
        }
    }

    private static int getSpeedIndex(int speed) {
        for (int i = 0; i < SPEED_CYCLE.length; ++i) {
            if (SPEED_CYCLE[i] != speed) continue;
            return i;
        }
        return -1;
    }

    private static int calculateSpeedClicks(int fromIndex, int toIndex) {
        int forward = (toIndex - fromIndex + SPEED_CYCLE.length) % SPEED_CYCLE.length;
        int backward = (fromIndex - toIndex + SPEED_CYCLE.length) % SPEED_CYCLE.length;
        return forward <= backward ? forward : -backward;
    }

    private static float getPitchValue(String pitch) {
        for (int i = 0; i < PITCH_CYCLE.length; ++i) {
            if (!PITCH_CYCLE[i].equals(pitch)) continue;
            return PITCH_VALUES[i];
        }
        return 0.0f;
    }

    private static String getPitchName(float pitch) {
        for (int i = 0; i < PITCH_VALUES.length; ++i) {
            if (!(Math.abs(pitch - PITCH_VALUES[i]) < 1.0E-4f)) continue;
            return PITCH_CYCLE[i];
        }
        return null;
    }

    private static int getPitchIndex(String pitch) {
        for (int i = 0; i < PITCH_CYCLE.length; ++i) {
            if (!PITCH_CYCLE[i].equals(pitch)) continue;
            return i;
        }
        return -1;
    }

    private static int calculatePitchClicks(int fromIndex, int toIndex) {
        int forward = (toIndex - fromIndex + PITCH_CYCLE.length) % PITCH_CYCLE.length;
        int backward = (fromIndex - toIndex + PITCH_CYCLE.length) % PITCH_CYCLE.length;
        return forward <= backward ? forward : -backward;
    }

    private static boolean isDye(class_1792 item) {
        for (class_1792 dye : COLOR_CYCLE) {
            if (item != dye) continue;
            return true;
        }
        return false;
    }

    private static boolean isStainedGlassPane(class_1792 item) {
        for (class_1792 glass : GLASS_CYCLE) {
            if (item != glass) continue;
            return true;
        }
        return false;
    }

    private static int getColorIndex(class_1792 item, class_1792[] cycle) {
        for (int i = 0; i < cycle.length; ++i) {
            if (cycle[i] != item) continue;
            return i;
        }
        return -1;
    }

    private static int calculateClicks(int fromIndex, int toIndex) {
        int forward = (toIndex - fromIndex + COLOR_CYCLE.length) % COLOR_CYCLE.length;
        int backward = (fromIndex - toIndex + COLOR_CYCLE.length) % COLOR_CYCLE.length;
        return forward <= backward ? forward : -backward;
    }

    private static Int2ObjectMap<class_1799> getSlots(class_476 screen) {
        Int2ObjectOpenHashMap slots = new Int2ObjectOpenHashMap();
        class_1707 handler = (class_1707)screen.method_17577();
        int containerSize = handler.method_17388() * 9;
        for (class_1735 slot : handler.field_7761.subList(0, containerSize)) {
            slots.put(slot.field_7874, (Object)slot.method_7677());
        }
        return slots;
    }
}

