/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.garden.FarmingHud;
import de.hysky.skyblocker.skyblock.garden.LowerSensitivity;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jspecify.annotations.Nullable;

@RegisterWidget
public class FarmingHudWidget
extends ComponentBasedWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Farming").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.GARDEN);
    public static final Map<String, String> FARMING_TOOLS = Map.ofEntries(Map.entry("THEORETICAL_HOE_WHEAT_1", "WHEAT"), Map.entry("THEORETICAL_HOE_WHEAT_2", "WHEAT"), Map.entry("THEORETICAL_HOE_WHEAT_3", "WHEAT"), Map.entry("THEORETICAL_HOE_CARROT_1", "CARROT_ITEM"), Map.entry("THEORETICAL_HOE_CARROT_2", "CARROT_ITEM"), Map.entry("THEORETICAL_HOE_CARROT_3", "CARROT_ITEM"), Map.entry("THEORETICAL_HOE_POTATO_1", "POTATO_ITEM"), Map.entry("THEORETICAL_HOE_POTATO_2", "POTATO_ITEM"), Map.entry("THEORETICAL_HOE_POTATO_3", "POTATO_ITEM"), Map.entry("THEORETICAL_HOE_CANE_1", "SUGAR_CANE"), Map.entry("THEORETICAL_HOE_CANE_2", "SUGAR_CANE"), Map.entry("THEORETICAL_HOE_CANE_3", "SUGAR_CANE"), Map.entry("THEORETICAL_HOE_SUNFLOWER_1", "DOUBLE_PLANT"), Map.entry("THEORETICAL_HOE_SUNFLOWER_2", "DOUBLE_PLANT"), Map.entry("THEORETICAL_HOE_SUNFLOWER_3", "DOUBLE_PLANT"), Map.entry("THEORETICAL_HOE_WILD_ROSE_1", "WILD_ROSE"), Map.entry("THEORETICAL_HOE_WILD_ROSE_2", "WILD_ROSE"), Map.entry("THEORETICAL_HOE_WILD_ROSE_3", "WILD_ROSE"), Map.entry("THEORETICAL_HOE_WARTS_1", "NETHER_STALK"), Map.entry("THEORETICAL_HOE_WARTS_2", "NETHER_STALK"), Map.entry("THEORETICAL_HOE_WARTS_3", "NETHER_STALK"), Map.entry("FUNGI_CUTTER", "RED_MUSHROOM"), Map.entry("FUNGI_CUTTER_2", "RED_MUSHROOM"), Map.entry("FUNGI_CUTTER_3", "RED_MUSHROOM"), Map.entry("CACTUS_KNIFE", "CACTUS"), Map.entry("CACTUS_KNIFE_2", "CACTUS"), Map.entry("CACTUS_KNIFE_3", "CACTUS"), Map.entry("MELON_DICER", "MELON"), Map.entry("MELON_DICER_2", "MELON"), Map.entry("MELON_DICER_3", "MELON"), Map.entry("PUMPKIN_DICER", "PUMPKIN"), Map.entry("PUMPKIN_DICER_2", "PUMPKIN"), Map.entry("PUMPKIN_DICER_3", "PUMPKIN"), Map.entry("COCO_CHOPPER", "INK_SACK:3"), Map.entry("COCO_CHOPPER_2", "INK_SACK:3"), Map.entry("COCO_CHOPPER_3", "INK_SACK:3"), Map.entry("BASIC_GARDENING_HOE", ""), Map.entry("ADVANCED_GARDENING_HOE", ""));
    private static @Nullable FarmingHudWidget instance = null;
    private final class_310 client = class_310.method_1551();

    public static FarmingHudWidget getInstance() {
        if (instance == null) {
            instance = new FarmingHudWidget();
        }
        return instance;
    }

    public FarmingHudWidget() {
        super(TITLE, class_124.field_1054.method_532(), "hud_farming");
        instance = this;
        this.update();
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    @Override
    public void updateContent() {
        if (this.client.field_1724 == null || this.client.field_1687 == null) {
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"Nothing to show :p")));
            return;
        }
        class_1799 farmingToolStack = this.client.field_1724.method_6047();
        String itemId = farmingToolStack.getSkyblockId();
        String cropItemId = FARMING_TOOLS.getOrDefault(itemId, "");
        if (cropItemId.equals("DOUBLE_PLANT") && this.client.field_1687.method_8532() >= 12000L) {
            cropItemId = "MOONFLOWER";
        }
        class_1799 cropStack = ItemRepository.getItemStack(cropItemId.replace(":", "-"));
        String counterText = FarmingHud.counterText();
        String counterNumber = FarmingHud.NUMBER_FORMAT.format(FarmingHud.counter());
        if (FarmingHud.CounterType.NONE.matchesText(counterText)) {
            counterNumber = "";
        }
        this.addSimpleIcoText(cropStack, counterText, class_124.field_1054, counterNumber);
        float cropsPerMinute = FarmingHud.cropsPerMinute();
        this.addSimpleIconTranslatableText(cropStack, "skyblocker.config.farming.general.cropsPerMin", class_124.field_1054, FarmingHud.NUMBER_FORMAT.format((int)cropsPerMinute / 10 * 10));
        this.addSimpleIconTranslatableText(Ico.GOLD, "skyblocker.config.farming.general.coinsPerHour", class_124.field_1065, this.getPriceText(cropItemId, cropsPerMinute));
        this.addSimpleIconTranslatableText(cropStack, "skyblocker.config.farming.general.blocksPerSec", class_124.field_1054, Double.toString(FarmingHud.blockBreaks()));
        this.addComponent(Components.progressComponent(Ico.LANTERN, (class_2561)class_2561.method_43471((String)"skyblocker.config.farming.general.farmingLevel"), FarmingHud.farmingXpPercentProgress(), class_124.field_1065.method_532()));
        this.addSimpleIconTranslatableText(Ico.LIME_DYE, "skyblocker.config.farming.general.farmingXPPerHour", class_124.field_1054, FarmingHud.NUMBER_FORMAT.format(FarmingHud.farmingXpPerHour()));
        class_1297 cameraEntity = this.client.method_1560();
        class_5250 yaw = cameraEntity == null ? class_2561.method_43471((String)"skyblocker.config.farming.general.noCameraEntity") : class_2561.method_43470((String)String.format("%.2f", Float.valueOf(class_3532.method_15393((float)cameraEntity.method_36454()))));
        class_5250 pitch = cameraEntity == null ? class_2561.method_43471((String)"skyblocker.config.farming.general.noCameraEntity") : class_2561.method_43470((String)String.format("%.2f", Float.valueOf(class_3532.method_15393((float)cameraEntity.method_36455()))));
        this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.config.farming.general.yaw", (Object[])new Object[]{yaw}).method_27692(class_124.field_1065)));
        this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.config.farming.general.pitch", (Object[])new Object[]{pitch}).method_27692(class_124.field_1065)));
        if (LowerSensitivity.isSensitivityLowered()) {
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43471((String)"skyblocker.garden.hud.mouseLocked").method_27692(class_124.field_1056)));
        }
    }

    private class_2561 getPriceText(String cropItemId, float cropsPerMinute) {
        DoubleBooleanPair itemBazaarPrice = ItemUtils.getItemPrice(cropItemId);
        double bazaarPrice = itemBazaarPrice.leftDouble();
        boolean hasBazaarData = itemBazaarPrice.rightBoolean();
        double itemNpcPrice = TooltipInfoType.NPC.hasOrNullWarning(cropItemId) ? TooltipInfoType.NPC.getData().getDouble((Object)cropItemId) : Double.MIN_VALUE;
        double priceToUse = 0.0;
        class_5250 sourceLabel = null;
        boolean hasValidPrice = false;
        switch (SkyblockerConfigManager.get().farming.garden.farmingHud.type) {
            case NPC: {
                if (!(itemNpcPrice > 0.0) || itemNpcPrice == Double.MIN_VALUE) break;
                priceToUse = itemNpcPrice;
                sourceLabel = class_2561.method_43470((String)" (").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.farming.garden.farmingHud.type.NPC")).method_27693(")");
                hasValidPrice = true;
                break;
            }
            case BAZAAR: {
                if (!hasBazaarData) break;
                priceToUse = bazaarPrice;
                sourceLabel = class_2561.method_43470((String)" (").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.farming.garden.farmingHud.type.BAZAAR")).method_27693(")");
                hasValidPrice = true;
                break;
            }
            case BOTH: {
                if (itemNpcPrice > bazaarPrice && itemNpcPrice != Double.MIN_VALUE) {
                    priceToUse = itemNpcPrice;
                    sourceLabel = class_2561.method_43470((String)" (").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.farming.garden.farmingHud.type.NPC")).method_27693(")");
                    hasValidPrice = true;
                    break;
                }
                if (!hasBazaarData) break;
                priceToUse = bazaarPrice;
                sourceLabel = class_2561.method_43470((String)" (").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.config.farming.garden.farmingHud.type.BAZAAR")).method_27693(")");
                hasValidPrice = true;
            }
        }
        return hasValidPrice ? class_2561.method_43470((String)FarmingHud.NUMBER_FORMAT.format((int)(priceToUse * (double)cropsPerMinute * 0.6) * 100)).method_10852((class_2561)sourceLabel) : class_2561.method_43471((String)"skyblocker.config.farming.general.noData");
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return location.equals((Object)Location.GARDEN) && SkyblockerConfigManager.get().farming.garden.farmingHud.enableHud;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!location.equals((Object)Location.GARDEN)) {
            return;
        }
        SkyblockerConfigManager.get().farming.garden.farmingHud.enableHud = enabled;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"Farming HUD");
    }
}

