/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.skyblock.garden.GardenPlotsWidget;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_490;
import net.minecraft.class_6880;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GardenPlots {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Garden Plots");
    private static final Path FOLDER = SkyblockerMod.CONFIG_DIR.resolve("garden_plots");
    public static final @Nullable GardenPlot[] GARDEN_PLOTS = new GardenPlot[25];

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_476) {
                class_476 containerScreen = (class_476)screen;
                if (screen.method_25440().getString().trim().equals("Configure Plots")) {
                    ScreenEvents.remove((class_437)screen).register(ignored -> {
                        class_1707 screenHandler = (class_1707)containerScreen.method_17577();
                        for (int row = 0; row < 5; ++row) {
                            for (int i = row * 9 + 2; i < row * 9 + 7; ++i) {
                                class_1735 slot;
                                class_1799 stack;
                                if (i == 22 || (stack = (slot = (class_1735)screenHandler.field_7761.get(i)).method_7677()).method_7960() || stack.method_31574(class_1802.field_8879) || stack.method_31574(class_1802.field_8780) || stack.method_31574(class_1802.field_8157)) continue;
                                String name = class_124.method_539((String)stack.method_7964().getString());
                                String[] parts = name.split("-", 2);
                                if (parts.length < 2) {
                                    LOGGER.warn("Invalid plot name: {}", (Object)name);
                                    continue;
                                }
                                int index = i / 9 * 5 + (i % 9 - 2);
                                Either icon = stack.getNeuName().isBlank() ? Either.left((Object)stack.method_7909()) : Either.right((Object)stack.getNeuName());
                                String plotName = parts[1].trim();
                                GardenPlot plot = GARDEN_PLOTS[index];
                                GardenPlots.GARDEN_PLOTS[index] = plot == null ? new GardenPlot((Either<class_1792, String>)icon, plotName) : plot.withIconName((Either<class_1792, String>)icon, plotName);
                            }
                        }
                    });
                    return;
                }
            }
            if (!(screen instanceof class_490)) return;
            class_490 inventoryScreen = (class_490)screen;
            if (!Utils.getLocation().equals((Object)Location.GARDEN)) return;
            if (!SkyblockerConfigManager.get().farming.garden.gardenPlotsWidget) return;
            GardenPlotsWidget widget = new GardenPlotsWidget(((AbstractContainerScreenAccessor)inventoryScreen).getX() + ((AbstractContainerScreenAccessor)inventoryScreen).getImageWidth() + 4, ((AbstractContainerScreenAccessor)inventoryScreen).getY());
            Screens.getButtons((class_437)inventoryScreen).add(widget);
            inventoryScreen.registerRecipeBookToggleCallback(() -> widget.method_48229(((AbstractContainerScreenAccessor)inventoryScreen).getX() + ((AbstractContainerScreenAccessor)inventoryScreen).getImageWidth() + 4, ((AbstractContainerScreenAccessor)inventoryScreen).getY()));
        });
        SkyblockEvents.PROFILE_CHANGE.register((prevProfileId, profileId) -> {
            if (!prevProfileId.isEmpty()) {
                CompletableFuture.runAsync(() -> GardenPlots.save(prevProfileId), Executors.newVirtualThreadPerTaskExecutor()).thenRun(() -> GardenPlots.load(profileId));
            } else {
                GardenPlots.load(profileId);
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client1 -> {
            String profileId = Utils.getProfileId();
            if (!profileId.isBlank()) {
                CompletableFuture.runAsync(() -> GardenPlots.save(profileId), Executors.newVirtualThreadPerTaskExecutor());
            }
        });
    }

    private static void save(String profileId) {
        try {
            Files.createDirectories(FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to create folder for garden plots!", (Throwable)e);
        }
        Path resolve = FOLDER.resolve(profileId + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(resolve, new OpenOption[0]);){
            JsonArray elements = new JsonArray();
            Arrays.stream(GARDEN_PLOTS).map(gardenPlot -> {
                if (gardenPlot == null) {
                    return null;
                }
                return GardenPlot.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, gardenPlot).result().orElse(null);
            }).forEach(elements::add);
            SkyblockerMod.GSON.toJson((JsonElement)elements, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to save Garden Plots data", (Throwable)e);
        }
    }

    private static void load(String profileId) {
        Path resolve = FOLDER.resolve(profileId + ".json");
        CompletableFuture.supplyAsync(() -> {
            block10: {
                GardenPlot[] gardenPlotArray;
                block9: {
                    BufferedReader reader2 = Files.newBufferedReader(resolve);
                    try {
                        gardenPlotArray = (GardenPlot[])SkyblockerMod.GSON.fromJson((Reader)reader2, JsonArray.class).asList().stream().map(jsonElement -> {
                            if (jsonElement == null || jsonElement.isJsonNull()) {
                                return null;
                            }
                            return GardenPlot.CODEC.decode((DynamicOps)JsonOps.INSTANCE, jsonElement).result().map(Pair::getFirst).orElseThrow();
                        }).toArray(GardenPlot[]::new);
                        if (reader2 == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader2 != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (NoSuchFileException reader2) {
                            break block10;
                        }
                        catch (Exception e) {
                            LOGGER.error("[Skyblocker] Failed to load Equipment data", (Throwable)e);
                        }
                    }
                    reader2.close();
                }
                return gardenPlotArray;
            }
            return new GardenPlot[25];
        }, Executors.newVirtualThreadPerTaskExecutor()).thenAccept(newPlots -> class_310.method_1551().execute(() -> System.arraycopy(newPlots, 0, GARDEN_PLOTS, 0, Math.min(((GardenPlot[])newPlots).length, 25))));
    }

    public record GardenPlot(Either<class_1792, String> icon, String name, Optional<String> customIcon) {
        public static final Codec<GardenPlot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)class_1792.field_54952.xmap(class_6880::comp_349, class_1792::method_40131), (Codec)Codec.STRING).fieldOf("icon").forGetter(GardenPlot::icon), (App)Codec.STRING.fieldOf("name").forGetter(GardenPlot::name), (App)Codec.STRING.optionalFieldOf("customIcon").forGetter(GardenPlot::customIcon)).apply((Applicative)instance, GardenPlot::new));

        public GardenPlot(Either<class_1792, String> icon, String name) {
            this(icon, name, Optional.empty());
        }

        public GardenPlot withIconName(Either<class_1792, String> icon, String name) {
            return new GardenPlot(icon, name, this.customIcon);
        }

        public GardenPlot withCustomIcon(@Nullable String customIcon) {
            return new GardenPlot(this.icon, this.name, Optional.ofNullable(customIcon));
        }
    }
}

