/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.garden.GardenPlots;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.render.gui.ItemButtonWidget;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.tag.client.v1.ClientTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6382;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9017;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;
import org.jspecify.annotations.Nullable;

public class GardenPlotsWidget
extends class_9017 {
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = class_2960.method_60656((String)"container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/slot_highlight_front");
    public static final Int2IntMap GARDEN_PLOT_TO_SLOT = Int2IntMap.ofEntries((Int2IntMap.Entry[])new Int2IntMap.Entry[]{Int2IntMap.entry((int)1, (int)7), Int2IntMap.entry((int)2, (int)11), Int2IntMap.entry((int)3, (int)13), Int2IntMap.entry((int)4, (int)17), Int2IntMap.entry((int)5, (int)6), Int2IntMap.entry((int)6, (int)8), Int2IntMap.entry((int)7, (int)16), Int2IntMap.entry((int)8, (int)18), Int2IntMap.entry((int)9, (int)2), Int2IntMap.entry((int)10, (int)10), Int2IntMap.entry((int)11, (int)14), Int2IntMap.entry((int)12, (int)22), Int2IntMap.entry((int)13, (int)1), Int2IntMap.entry((int)14, (int)3), Int2IntMap.entry((int)15, (int)5), Int2IntMap.entry((int)16, (int)9), Int2IntMap.entry((int)17, (int)15), Int2IntMap.entry((int)18, (int)19), Int2IntMap.entry((int)19, (int)21), Int2IntMap.entry((int)20, (int)23), Int2IntMap.entry((int)21, (int)0), Int2IntMap.entry((int)22, (int)4), Int2IntMap.entry((int)23, (int)20), Int2IntMap.entry((int)24, (int)24)});
    private static final @Nullable String[] CUSTOM_ICON_OPTIONS = new String[]{null, "WHEAT", "CARROT_ITEM", "POTATO_ITEM", "SUGAR_CANE", "DOUBLE_PLANT", "MOONFLOWER", "WILD_ROSE", "NETHER_STALK", "RED_MUSHROOM", "CACTUS", "MELON", "PUMPKIN", "INK_SACK-3"};
    private static final class_2960 BACKGROUND_TEXTURE = SkyblockerMod.id("textures/gui/garden_plots.png");
    private static final class_5250 GROSS_PEST_TEXT = class_2561.method_43471((String)"skyblocker.gardenPlots.pests").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private static final class_5250 TP_TEXT = class_2561.method_43471((String)"skyblocker.gardenPlots.tp").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private final ItemButtonWidget[] widgets;
    private final IntList infectedPlots = new IntArrayList(8);
    private final class_1799 noneItem = new class_1799((class_6880)class_1802.field_8077.method_40131(), 1, class_9326.method_57841().method_57854(class_9334.field_50239, (Object)class_2561.method_43470((String)"None")).method_57852());
    private @Nullable class_1799[] items;
    private int hoveredSlot = -1;
    private int editingSlotIcon = -1;
    private long updateFromTabTime = System.currentTimeMillis();
    private class_1799[] customIconOptionsItems = new class_1799[0];

    public GardenPlotsWidget(int x, int y) {
        super(x, y, 104, 132, (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots"));
        this.updatePlotItems();
        this.updateInfestedFromTab();
        ItemButtonWidget deskButton = new ItemButtonWidget(this.method_46426() + 7, this.method_55443() - 24, new class_1799((class_1935)class_1802.field_8529), (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots.openDesk"), button -> MessageScheduler.INSTANCE.sendMessageAfterCooldown("/desk", true));
        ItemButtonWidget spawnButton = new ItemButtonWidget(this.method_55442() - 7 - 40 - 2, this.method_55443() - 24, new class_1799((class_1935)class_1802.field_8449), (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots.spawn"), button -> MessageScheduler.INSTANCE.sendMessageAfterCooldown("/warp garden", true));
        ItemButtonWidget setSpawnButton = new ItemButtonWidget(this.method_55442() - 7 - 20, this.method_55443() - 24, new class_1799((class_1935)(Math.random() < 0.001 ? class_1802.field_8417 : class_1802.field_8789)), (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots.setSpawn"), button -> MessageScheduler.INSTANCE.sendMessageAfterCooldown("/setspawn", true));
        this.widgets = new ItemButtonWidget[]{deskButton, spawnButton, setSpawnButton};
    }

    private void updatePlotItems() {
        this.items = (class_1799[])Arrays.stream(GardenPlots.GARDEN_PLOTS).map(gardenPlot -> {
            if (gardenPlot == null) {
                return null;
            }
            class_1799 itemStack = gardenPlot.customIcon().map(s -> ItemRepository.getItemStack(s, ItemUtils.getItemIdPlaceholder(s))).orElseGet(() -> (class_1799)gardenPlot.icon().map(class_1799::new, s -> ItemRepository.getItemStack(s, ItemUtils.getItemIdPlaceholder(s)))).method_7972();
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)gardenPlot.name()).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            return itemStack;
        }).toArray(class_1799[]::new);
        this.items[12] = new class_1799((class_1935)class_1802.field_23256);
        this.items[12].method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)"The Barn"));
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)this.method_46426(), (float)this.method_46427());
        context.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        context.method_51439(textRenderer, (class_2561)(this.editingSlotIcon < 0 ? this.method_25369() : class_2561.method_43470((String)"Custom Icon")), 8, 6, -12566464, false);
        this.hoveredSlot = -1;
        long timeMillis = System.currentTimeMillis();
        @Nullable class_1799[] stacks = this.editingSlotIcon >= 0 ? this.customIconOptionsItems : this.items;
        for (int i = 0; i < stacks.length; ++i) {
            boolean hovered;
            class_1799 item = stacks[i];
            if (item == null) continue;
            int slotX = 7 + i % 5 * 18;
            int slotY = 17 + i / 5 * 18;
            boolean bl = hovered = slotX + this.method_46426() <= mouseX && mouseX < slotX + this.method_46426() + 18 && slotY + this.method_46427() <= mouseY && mouseY < slotY + this.method_46427() + 18;
            if (hovered) {
                context.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_SPRITE, slotX - 3, slotY - 3, 24, 24);
                if (ClientTags.isInLocal((class_6862)ConventionalItemTags.GLASS_PANES, (class_5321)item.method_7909().method_40131().method_40237())) {
                    context.method_51427(item, slotX + 1, slotY + 1);
                } else {
                    matrices.pushMatrix();
                    matrices.translate((float)slotX, (float)slotY);
                    matrices.scale(1.125f, 1.125f);
                    context.method_51427(item, 0, 0);
                    matrices.popMatrix();
                }
                context.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, slotX - 3, slotY - 3, 24, 24);
                this.hoveredSlot = i;
            } else {
                context.method_51427(item, slotX + 1, slotY + 1);
            }
            if (this.editingSlotIcon >= 0) {
                if (!hovered) continue;
                context.method_51434(textRenderer, List.of(item.method_7964()), mouseX, mouseY);
                continue;
            }
            boolean infested = this.infectedPlots.contains(i);
            if (infested && (timeMillis & 0x200L) != 0L) {
                HudHelper.drawBorder(context, slotX + 1, slotY + 1, 16, 16, -65536);
            }
            if (!hovered) continue;
            List<class_5250> tooltip = infested ? List.of(class_2561.method_43469((String)"skyblocker.gardenPlots.plot", (Object[])new Object[]{item.method_7964()}), GROSS_PEST_TEXT, class_2561.method_43473(), TP_TEXT) : (i == 12 ? List.of(item.method_7964(), class_2561.method_43473(), TP_TEXT) : List.of(class_2561.method_43469((String)"skyblocker.gardenPlots.plot", (Object[])new Object[]{item.method_7964()}), class_2561.method_43473(), TP_TEXT));
            context.method_51434(textRenderer, tooltip, mouseX, mouseY);
        }
        matrices.popMatrix();
        for (ItemButtonWidget widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, delta);
        }
        if (timeMillis - this.updateFromTabTime > 3000L) {
            this.updateFromTabTime = timeMillis;
            this.updateInfestedFromTab();
        }
    }

    private void updateInfestedFromTab() {
        this.infectedPlots.clear();
        for (int i = 0; i < PlayerListManager.getPlayerStringList().size(); ++i) {
            String[] split;
            String string = PlayerListManager.getPlayerStringList().get(i);
            if (!string.startsWith("Plots:")) continue;
            for (String s : split = string.split(":")[1].split(",")) {
                try {
                    this.infectedPlots.add(GARDEN_PLOT_TO_SLOT.getOrDefault(Integer.parseInt(s.strip()), -1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            break;
        }
    }

    public void method_25348(class_11909 click, boolean doubled) {
        super.method_25348(click, doubled);
        if (this.hoveredSlot == -1) {
            return;
        }
        if (this.editingSlotIcon >= 0) {
            GardenPlots.GardenPlot plot = GardenPlots.GARDEN_PLOTS[this.editingSlotIcon];
            if (plot != null) {
                GardenPlots.GARDEN_PLOTS[this.editingSlotIcon] = plot.withCustomIcon(CUSTOM_ICON_OPTIONS[this.hoveredSlot]);
            }
            this.editingSlotIcon = -1;
            this.updatePlotItems();
            return;
        }
        if (click.method_74245() == 1) {
            this.editingSlotIcon = this.hoveredSlot;
            this.customIconOptionsItems = (class_1799[])Arrays.stream(CUSTOM_ICON_OPTIONS).map(s -> {
                if (s == null) {
                    return this.noneItem;
                }
                class_1799 stack = ItemRepository.getItemStack(s);
                if (stack == null) {
                    return ItemUtils.getItemIdPlaceholder(s);
                }
                return stack;
            }).toArray(class_1799[]::new);
            return;
        }
        if (SkyblockerConfigManager.get().farming.garden.closeScreenOnPlotClick && class_310.method_1551().field_1755 != null) {
            class_310.method_1551().field_1755.method_25419();
        }
        if (this.hoveredSlot == 12) {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/plottp barn", true);
        } else {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/plottp " + GardenPlots.GARDEN_PLOTS[this.hoveredSlot].name(), true);
        }
    }

    protected boolean method_25351(class_11910 input) {
        return (super.method_25351(input) || input.comp_4801() == 1) && this.hoveredSlot != -1;
    }

    protected void method_47399(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return List.of(this.widgets);
    }

    protected int method_44395() {
        return this.method_25364();
    }

    protected double method_44393() {
        return 0.0;
    }

    public void method_46421(int x) {
        int prevX = this.method_46426();
        super.method_46421(x);
        int diff = x - prevX;
        for (ItemButtonWidget widget : this.widgets) {
            widget.method_46421(widget.method_46426() + diff);
        }
    }

    public void method_46419(int y) {
        int prevY = this.method_46427();
        super.method_46419(y);
        int diff = y - prevY;
        for (ItemButtonWidget widget : this.widgets) {
            widget.method_46419(widget.method_46427() + diff);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.method_25405(click.comp_4798(), click.comp_4799()) && this.method_25351(click.comp_4800())) {
            this.method_25348(click, doubled);
            return true;
        }
        return super.method_25402(click, doubled);
    }
}

