/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden.visitor;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.garden.visitor.Visitor;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import io.github.moulberry.repo.data.NEUItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;

public class VisitorHelper
extends class_339 {
    private static final Set<Visitor> activeVisitors = new HashSet<Visitor>();
    private static final Map<String, class_1799> cachedItems = new HashMap<String, class_1799>();
    private static final Object2IntMap<class_2561> groupedItems = new Object2IntOpenHashMap();
    private static final Map<class_2561, List<Visitor>> visitorsByItem = new LinkedHashMap<class_2561, List<Visitor>>();
    private static int xOffset = 4;
    private static int yOffset = 4;
    private static int exclusionZoneWidth = 215;
    private static int exclusionZoneHeight = 215;
    private static final int ICON_SIZE = 16;
    private static final int LINE_HEIGHT = 3;
    private static final int PADDING = 4;
    private static final Object2LongMap<class_2561> copiedTimestamps = new Object2LongOpenHashMap();
    private static boolean processVisitor = false;
    private int dragStartX;
    private int dragStartY;

    public VisitorHelper(int x, int y) {
        super(x, y, 0, 0, (class_2561)class_2561.method_43470((String)"Visitor Helper"));
    }

    @Init
    public static void initialize() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            class_465 handledScreen;
            block3: {
                block2: {
                    if (!(screen instanceof class_465)) break block2;
                    handledScreen = (class_465)screen;
                    if (VisitorHelper.shouldRender()) break block3;
                }
                return;
            }
            processVisitor = true;
            ScreenEvents.afterTick((class_437)screen).register(_screen -> VisitorHelper.updateVisitors(handledScreen.method_17577()));
            Screens.getButtons((class_437)screen).add(new VisitorHelper(xOffset, yOffset));
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, _buildContext) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"garden").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"visitors").then(ClientCommandManager.literal((String)"removeAll").executes(ctx -> {
            activeVisitors.clear();
            VisitorHelper.updateItems();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.farming.visitorHelper.command.clearedAllVisitors")));
            return 1;
        }))).then(ClientCommandManager.literal((String)"remove").then((ArgumentBuilder)((RequiredArgumentBuilder)ClientCommandManager.argument((String)"visitor", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String name = ((String)ctx.getArgument("visitor", String.class)).toLowerCase(Locale.ENGLISH);
            Optional<Visitor> visitor = activeVisitors.stream().filter(v -> v.name().getString().toLowerCase(Locale.ENGLISH).equals(name)).findAny();
            if (visitor.isEmpty()) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.farming.visitorHelper.command.unableToRemoveVisitor")));
                return 1;
            }
            activeVisitors.remove(visitor.get());
            VisitorHelper.updateItems();
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_54159((String)"skyblocker.farming.visitorHelper.command.removedVisitor", (Object[])new Object[]{visitor.get().name()})));
            return 1;
        })).suggests((ctx, builder) -> class_2172.method_9264(activeVisitors.stream().map(Visitor::name).map(class_2561::getString), (SuggestionsBuilder)builder))))))));
    }

    public static boolean shouldRender() {
        boolean isHelperEnabled = SkyblockerConfigManager.get().farming.visitorHelper.visitorHelper;
        boolean isGardenMode = SkyblockerConfigManager.get().farming.visitorHelper.visitorHelperGardenOnly;
        return isHelperEnabled && (!isGardenMode || Utils.isInGarden() || Utils.getArea() == Area.Hub.BAZAAR);
    }

    public static List<class_8030> getExclusionZones() {
        if (activeVisitors.isEmpty()) {
            return List.of();
        }
        return List.of(new class_8030(new class_8029(xOffset, yOffset), exclusionZoneWidth, exclusionZoneHeight));
    }

    private static void updateVisitors(class_1703 handler) {
        if (!processVisitor) {
            return;
        }
        class_1799 visitorHead = handler.method_7611(13).method_7677();
        if (visitorHead.method_7960() || !visitorHead.method_57826(class_9334.field_49632) || ItemUtils.getLoreLineIf(visitorHead, t -> t.contains("Times Visited")) == null) {
            return;
        }
        class_2561 visitorName = visitorHead.method_7964();
        if (activeVisitors.stream().map(Visitor::name).anyMatch(arg_0 -> ((class_2561)visitorName).equals(arg_0))) {
            return;
        }
        Visitor newVisitor = new Visitor(visitorName, visitorHead.method_7972());
        VisitorHelper.extractRequiredItems(handler, newVisitor);
        if (!newVisitor.requiredItems().isEmpty()) {
            activeVisitors.add(newVisitor);
        }
        VisitorHelper.updateItems();
    }

    private static void extractRequiredItems(class_1703 handler, Visitor visitor) {
        class_1799 acceptButton = handler.method_7611(29).method_7677();
        if (acceptButton.method_7960() || ItemUtils.getLoreLineIf(acceptButton, t -> t.contains("Items Required")) == null) {
            return;
        }
        acceptButton.skyblocker$getLoreStrings().stream().map(String::trim).dropWhile(lore -> !lore.contains("Items Required")).skip(1L).takeWhile(lore -> !lore.isEmpty()).forEach(requirement -> {
            String[] split = requirement.split(" x");
            class_2561 item = class_2561.method_30163((String)split[0].trim());
            if (split.length == 1) {
                visitor.addRequiredItem(item, 1);
            } else {
                visitor.addRequiredItem(item, Formatters.parseNumber(split[1].trim()).intValue());
            }
        });
    }

    private static void updateItems() {
        groupedItems.clear();
        visitorsByItem.clear();
        for (Visitor visitor : activeVisitors) {
            for (Object2IntMap.Entry entry : visitor.requiredItems().object2IntEntrySet()) {
                class_2561 itemName = (class_2561)entry.getKey();
                int amount = entry.getIntValue();
                groupedItems.put((Object)itemName, groupedItems.getOrDefault((Object)itemName, 0) + amount);
                visitorsByItem.computeIfAbsent(itemName, k -> new LinkedList()).add(visitor);
            }
        }
    }

    private static class_1799 getCachedItem(String itemName) {
        String cleanName = class_124.method_539((String)itemName);
        return cachedItems.computeIfAbsent(cleanName, name -> {
            if (NEURepoManager.isLoading() || !ItemRepository.filesImported()) {
                return ItemUtils.getNamedPlaceholder(itemName);
            }
            return NEURepoManager.getItemByName(itemName).stream().findFirst().map(NEUItem::getSkyblockItemId).map(ItemRepository::getItemStack).orElseGet(() -> ItemUtils.getNamedPlaceholder(itemName));
        });
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (activeVisitors.isEmpty()) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        int index = 0;
        int newWidth = 0;
        int x = this.method_46426() + 4;
        int n = this.method_46427();
        Objects.requireNonNull(textRenderer);
        int y = n - (int)(9.0f / 2.0f - 7.6f) + 4;
        context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), 0x18808080);
        for (Object2IntMap.Entry entry : groupedItems.object2IntEntrySet()) {
            class_5250 itemText;
            int yPosition;
            class_2561 itemName = (class_2561)entry.getKey();
            int totalAmount = entry.getIntValue();
            List<Visitor> visitors = visitorsByItem.get(itemName);
            if (visitors == null || visitors.isEmpty()) continue;
            for (Visitor visitor : visitors) {
                Objects.requireNonNull(textRenderer);
                yPosition = y + index * (3 + 9);
                context.method_51448().pushMatrix();
                Matrix3x2fStack matrix3x2fStack = context.method_51448();
                float f = x;
                float f2 = yPosition;
                Objects.requireNonNull(textRenderer);
                matrix3x2fStack.translate(f, f2 + 9.0f / 2.0f - 7.6f);
                context.method_51448().scale(0.95f, 0.95f);
                context.method_51427(visitor.head(), 0, 0);
                context.method_51448().popMatrix();
                context.method_51439(textRenderer, visitor.name(), x + 15 + 4, yPosition, -1, true);
                ++index;
            }
            int iconX = x + 12;
            int textX = iconX + 15 + 4;
            Objects.requireNonNull(textRenderer);
            yPosition = y + index * (3 + 9);
            class_1799 cachedStack = VisitorHelper.getCachedItem(itemName.getString());
            context.method_51448().pushMatrix();
            Matrix3x2fStack matrix3x2fStack = context.method_51448();
            float f = iconX;
            float f3 = yPosition;
            Objects.requireNonNull(textRenderer);
            matrix3x2fStack.translate(f, f3 + 9.0f / 2.0f - 7.6f);
            context.method_51448().scale(0.95f, 0.95f);
            context.method_51427(cachedStack, 0, 0);
            context.method_51448().popMatrix();
            class_5250 name = cachedStack.method_7964().method_27661();
            class_5250 class_52502 = itemText = SkyblockerConfigManager.get().farming.visitorHelper.showStacksInVisitorHelper && totalAmount >= 64 ? name.method_27693(" x" + totalAmount / 64 + " stacks + " + totalAmount % 64) : name.method_27693(" x" + totalAmount);
            if (copiedTimestamps.containsKey((Object)itemName)) {
                long timeSinceCopy = System.currentTimeMillis() - copiedTimestamps.getLong((Object)itemName);
                if (timeSinceCopy < 1000L) {
                    itemText.method_10852((class_2561)class_2561.method_43470((String)" \u2714 ").method_27692(class_124.field_1060));
                } else {
                    copiedTimestamps.removeLong((Object)itemName);
                }
            }
            newWidth = Math.max(newWidth, textX + textRenderer.method_27525((class_5348)itemText) - x);
            VisitorHelper.drawTextWithHoverUnderline(context, textRenderer, (class_2561)itemText, textX, yPosition, mouseX, mouseY);
            ++index;
        }
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.method_53533(index * (3 + 9) + 8);
        this.method_25358(newWidth + 8);
        exclusionZoneWidth = this.method_25368();
        exclusionZoneHeight = this.method_25364();
    }

    protected void method_25349(class_11909 click, double offsetX, double offsetY) {
        if (activeVisitors.isEmpty()) {
            return;
        }
        xOffset = (int)click.comp_4798() - this.dragStartX;
        yOffset = (int)click.comp_4799() - this.dragStartY;
        this.method_48229(xOffset, yOffset);
    }

    public void method_25348(class_11909 click, boolean doubled) {
        if (activeVisitors.isEmpty()) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.dragStartX = (int)click.comp_4798() - this.method_46426();
        this.dragStartY = (int)click.comp_4799() - this.method_46427();
        int index = 0;
        int n = this.method_46427();
        Objects.requireNonNull(textRenderer);
        int y = n - (int)(9.0f / 2.0f - 7.6f) + 4;
        for (Object2IntMap.Entry entry : groupedItems.object2IntEntrySet()) {
            class_5250 itemText;
            class_2561 itemName = (class_2561)entry.getKey();
            int totalAmount = entry.getIntValue();
            List<Visitor> visitors = visitorsByItem.get(itemName);
            if (visitors == null || visitors.isEmpty()) continue;
            int iconX = this.method_46426() + 12;
            int textX = iconX + 15 + 4;
            Objects.requireNonNull(textRenderer);
            int yPosition = y + (index += visitors.size()) * (3 + 9);
            class_5250 name = itemName.method_27661();
            class_5250 class_52502 = itemText = SkyblockerConfigManager.get().farming.visitorHelper.showStacksInVisitorHelper && totalAmount >= 64 ? name.method_27693(" x" + totalAmount / 64 + " stacks + " + totalAmount % 64) : name.method_27693(" x" + totalAmount);
            if (VisitorHelper.isMouseOverText(textRenderer, (class_2561)itemText, textX, yPosition, click.comp_4798(), click.comp_4799())) {
                class_310.method_1551().field_1774.method_1455(String.valueOf(totalAmount));
                copiedTimestamps.put((Object)itemName, System.currentTimeMillis());
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("/bz " + itemName.getString(), true);
                return;
            }
            ++index;
        }
    }

    public static void onSlotClick(class_1735 slot, int slotId, String title, class_1735 visitorHeadSlot) {
        if ((slotId == 29 || slotId == 13 || slotId == 33) && slot.method_7681() && ItemUtils.getLoreLineIf(slot.method_7677(), s -> s.equals("Click to give!") || s.equals("Click to refuse!")) != null) {
            activeVisitors.removeIf(entry -> entry.name().getString().equals(title) && visitorHeadSlot.method_7681() && ItemUtils.getHeadTexture(visitorHeadSlot.method_7677()).equals(ItemUtils.getHeadTexture(entry.head())));
            processVisitor = false;
        }
        VisitorHelper.updateItems();
    }

    private static void drawTextWithHoverUnderline(class_332 context, class_327 textRenderer, class_2561 text, int x, int y, double mouseX, double mouseY) {
        context.method_51439(textRenderer, text, x, y, -1, true);
        if (VisitorHelper.isMouseOverText(textRenderer, text, x, y, mouseX, mouseY)) {
            int n = x + textRenderer.method_27525((class_5348)text);
            Objects.requireNonNull(textRenderer);
            context.method_51738(x, n, y + 9, -1);
        }
    }

    private static boolean isMouseOverText(class_327 textRenderer, class_2561 text, int x, int y, double mouseX, double mouseY) {
        double d = x;
        double d2 = y;
        double d3 = x + textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(textRenderer);
        return HudHelper.pointIsInArea(mouseX, mouseY, d, d2, d3, y + 9);
    }

    protected void method_47399(class_6382 builder) {
    }
}

