/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.hunting;

import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.hunting.AttributesFile;
import de.hysky.skyblocker.utils.NEURepoManager;
import io.github.moulberry.repo.NEURepoFile;
import java.io.InputStream;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Attributes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static List<Attribute> attributes = List.of();

    @Init
    public static void init() {
        NEURepoManager.runAsyncAfterLoad(Attributes::loadShards);
    }

    private static void loadShards() {
        NEURepoFile file = NEURepoManager.file("constants/attribute_shards.json");
        if (file == null) {
            return;
        }
        try (InputStream stream = file.stream();){
            attributes = ((AttributesFile)AttributesFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(new String(stream.readAllBytes()))).getOrThrow()).attributes();
            LOGGER.info("[Skyblocker Attributes] Successfully loaded attributes!");
        }
        catch (Exception ex) {
            LOGGER.error("[Skyblocker Attributes] Failed to load attributes!", (Throwable)ex);
        }
    }

    public static @Nullable Attribute getAttributeFromItemName(class_9322 stack) {
        if (!stack.method_57826(class_9334.field_49631)) {
            return null;
        }
        String name = ((class_2561)stack.method_58694(class_9334.field_49631)).getString();
        return Attributes.getAttributeFromItemName(name);
    }

    public static @Nullable Attribute getAttributeFromItemName(String name) {
        int index = name.indexOf("Shard");
        if (index > -1) {
            name = name.substring(0, index - 1);
        }
        name = name.replace("BUY ", "").replace("SELL ", "");
        for (Attribute attribute : attributes) {
            if (!attribute.shardName().equals(name)) continue;
            return attribute;
        }
        return null;
    }
}

