/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.hunting;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.ContainerSolverManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.slf4j.Logger;

public class AttributesDebug {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final List<Attribute> DUMPED_ATTRIBUTES = new ArrayList<Attribute>();
    private static final Pattern SOURCE_PATTERN = Pattern.compile("Source: (?<shardName>[A-za-z ]+) Shard \\((?<id>[CUREL]\\d+)\\)");
    private static final Path ATTRIBUTE_EXPORT_DEST = SkyblockerMod.CONFIG_DIR.resolve("attribute_export.json");

    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((screen1, input) -> {
            if (input.comp_4795() == 71) {
                AttributesDebug.dumpAttributes();
            } else if (input.comp_4795() == 74) {
                AttributesDebug.exportAttributes();
            }
        }));
    }

    private static void dumpAttributes() {
        class_465 screen;
        class_437 class_4372 = AttributesDebug.CLIENT.field_1755;
        if (class_4372 instanceof class_465 && (screen = (class_465)class_4372).method_25440().getString().equals("Attribute Menu")) {
            Int2ObjectMap<class_1799> slots = ContainerSolverManager.slotMap(screen.method_17577().field_7761.subList(0, ((class_1707)screen.method_17577()).method_17388() * 9));
            ContainerSolver.trimEdges(slots, 6);
            for (class_1799 stack : slots.values()) {
                if (stack.method_7960()) continue;
                String name = stack.method_7964().getString();
                Matcher sourceMatcher = ItemUtils.getLoreLineIfMatch(stack, SOURCE_PATTERN);
                ArrayList<String> words = new ArrayList<String>(Arrays.asList(name.split(" ")));
                if (RomanNumerals.isValidRomanNumeral(((String)words.getLast()).strip())) {
                    words.removeLast();
                    name = String.join((CharSequence)" ", words);
                }
                if (sourceMatcher != null) {
                    String shardName = sourceMatcher.group("shardName");
                    String id = sourceMatcher.group("id");
                    String apiIdGuess = "SHARD_" + shardName.replace(' ', '_').toUpperCase(Locale.ENGLISH);
                    String neuIdGuess = "ATTRIBUTE_SHARD" + name.replace(' ', '_').toUpperCase(Locale.ENGLISH) + ";1";
                    boolean hasDataForId = TooltipInfoType.BAZAAR.getData().containsKey((Object)apiIdGuess);
                    if (!hasDataForId) {
                        LOGGER.warn("[Skyblocker Attributes Debug] No data found for shard. Shard Name: {}", (Object)shardName);
                    }
                    Attribute attribute = new Attribute(name, shardName, id, apiIdGuess, neuIdGuess);
                    DUMPED_ATTRIBUTES.add(attribute);
                    continue;
                }
                LOGGER.warn("[Skyblocker Attributes Debug] Failed to match shard! Name: {}", (Object)name);
            }
        }
    }

    private static void exportAttributes() {
        class_465 screen;
        class_437 class_4372 = AttributesDebug.CLIENT.field_1755;
        if (class_4372 instanceof class_465 && (screen = (class_465)class_4372).method_25440().getString().equals("Attribute Menu")) {
            List copy = DUMPED_ATTRIBUTES.stream().distinct().toList();
            CompletableFuture.runAsync(() -> {
                try {
                    Files.writeString(ATTRIBUTE_EXPORT_DEST, (CharSequence)((JsonElement)Attribute.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)copy).getOrThrow()).toString(), new OpenOption[0]);
                }
                catch (Exception e) {
                    LOGGER.error("[Skyblocker Attributes Debug] Failed to export attributes!", (Throwable)e);
                }
            }, Executors.newVirtualThreadPerTaskExecutor());
        }
    }
}

