/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.TextTransformer;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import de.hysky.skyblocker.utils.render.gui.AbstractPopupScreen;
import io.github.moulberry.repo.data.NEUItem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.azureaaron.networth.Calculation;
import net.azureaaron.networth.NetworthResult;
import net.azureaaron.networth.utils.ItemConstants;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_11467;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7940;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.slf4j.Logger;

public class ValueBreakdownPopup
extends AbstractPopupScreen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_304 KEY_BINDING = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.skyblocker.valueBreadownPopup", 73, SkyblockerMod.KEYBINDING_CATEGORY));
    private static final Function<String, class_2561> EMPTY = s -> class_2561.method_43473();
    private static final Function<String, class_2561> ITEM_NAME = s -> {
        NEUItem neuItem = NEURepoManager.getItemByNeuId(s);
        if (neuItem == null) {
            return class_2561.method_43470((String)s);
        }
        return TextTransformer.fromLegacy(neuItem.getDisplayName());
    };
    private static final LayoutAppender EMPTY_APPENDER = (r, c, l) -> {};
    private static final Map<Calculation.Type, LayoutAppender> FORMATTERS = new EnumMap<Calculation.Type, LayoutAppender>(Map.ofEntries(Map.entry(Calculation.Type.STAR, new BasicListAppender((class_2561)class_2561.method_43470((String)"Star Upgrades"), ITEM_NAME)), Map.entry(Calculation.Type.GOD_ROLL, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"God Roll"), ITEM_NAME)), Map.entry(Calculation.Type.SHEN_AUCTION, EMPTY_APPENDER), Map.entry(Calculation.Type.WINNING_BID, EMPTY_APPENDER), Map.entry(Calculation.Type.ENCHANTMENT, new BasicListAppender((class_2561)class_2561.method_43470((String)"Enchantments"), s -> {
        String neuId = ItemRepository.getBazaarStocks().get("ENCHANTMENT_" + s);
        if (neuId == null) {
            return class_2561.method_43470((String)s);
        }
        NEUItem neuItem = NEURepoManager.getItemByNeuId(neuId);
        if (neuItem == null) {
            return class_2561.method_43470((String)s);
        }
        return TextTransformer.fromLegacy((String)neuItem.getLore().getFirst());
    })), Map.entry(Calculation.Type.SKIN, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Skin"), s -> {
        NEUItem neuItem = NEURepoManager.getItemByNeuId(s);
        if (neuItem == null) {
            neuItem = NEURepoManager.getItemByNeuId("PET_SKIN_" + s);
        }
        if (neuItem == null) {
            return class_2561.method_43470((String)s);
        }
        return TextTransformer.fromLegacy(neuItem.getDisplayName());
    })), Map.entry(Calculation.Type.SILEX, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Silex"), EMPTY)), Map.entry(Calculation.Type.GOLDEN_BOUNTY, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Golden Bounty"), EMPTY)), Map.entry(Calculation.Type.POCKET_SACK_IN_A_SACK, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Pocket Sack in a sack"), EMPTY)), Map.entry(Calculation.Type.WOOD_SINGULARITY, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Wood Singularity"), EMPTY)), Map.entry(Calculation.Type.JALAPENO_BOOK, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Jalapeno Book"), EMPTY)), Map.entry(Calculation.Type.TRANSMISSION_TUNER, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Transmission Tuner"), EMPTY)), Map.entry(Calculation.Type.MANA_DISINTEGRATOR, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Mana Disintegrator"), EMPTY)), Map.entry(Calculation.Type.THUNDER_IN_A_BOTTLE, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Thunder in a Bottle"), EMPTY)), Map.entry(Calculation.Type.RUNE, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Rune"), ITEM_NAME)), Map.entry(Calculation.Type.FUMING_POTATO_BOOK, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Fuming Potato Book"), EMPTY)), Map.entry(Calculation.Type.HOT_POTATO_BOOK, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Hot Potato Book"), EMPTY)), Map.entry(Calculation.Type.DYE, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Dye"), ITEM_NAME)), Map.entry(Calculation.Type.ART_OF_WAR, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Art of War"), EMPTY)), Map.entry(Calculation.Type.ART_OF_PEACE, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Art of Peace"), EMPTY)), Map.entry(Calculation.Type.FARMING_FOR_DUMMIES, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Farming For Dummies"), EMPTY)), Map.entry(Calculation.Type.TALISMAN_ENRICHMENT, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Talisman Enrichment"), EMPTY)), Map.entry(Calculation.Type.RECOMBOBULATOR, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Recombobulator"), EMPTY)), Map.entry(Calculation.Type.GEMSTONE_SLOT, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Gemstone Slot"), EMPTY)), Map.entry(Calculation.Type.GEMSTONE, new BasicListAppender((class_2561)class_2561.method_43470((String)"Gemstones"), ITEM_NAME)), Map.entry(Calculation.Type.POWER_SCROLL, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Power Scroll"), ITEM_NAME)), Map.entry(Calculation.Type.REFORGE, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Reforge"), s -> {
        String neuId = (String)ItemConstants.REFORGES.get(s);
        if (neuId == null) {
            return class_2561.method_43470((String)s);
        }
        return ITEM_NAME.apply(neuId);
    })), Map.entry(Calculation.Type.MASTER_STAR, new BasicListAppender((class_2561)class_2561.method_43470((String)"Master Stars"), ITEM_NAME)), Map.entry(Calculation.Type.WITHER_BLADE_SCROLL, new BasicListAppender((class_2561)class_2561.method_43470((String)"Wither Blade Scrolls"), ITEM_NAME)), Map.entry(Calculation.Type.DRILL_PART, new BasicListAppender((class_2561)class_2561.method_43470((String)"Drill Parts"), ITEM_NAME)), Map.entry(Calculation.Type.POLARVOID_BOOK, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Polarvoid Book"), EMPTY)), Map.entry(Calculation.Type.DIVAN_POWDER_COATING, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Divan Powder Coating"), EMPTY)), Map.entry(Calculation.Type.ETHERWARP_CONDUIT, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Etherwarp Conduit"), EMPTY)), Map.entry(Calculation.Type.NEW_YEAR_CAKES, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"New Year Cakes"), EMPTY)), Map.entry(Calculation.Type.PET_ITEM, new BasicSingleAppender((class_2561)class_2561.method_43470((String)"Pet Item"), ITEM_NAME))));
    private final NetworthResult networthResult;
    private final EnumMap<Calculation.Type, List<Calculation>> map;
    private class_11467 scrollable;

    @Init
    public static void initClass() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!Utils.isOnSkyblock()) {
                return;
            }
            if (screen instanceof class_465) {
                class_465 handledScreen = (class_465)screen;
                ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((screen1, key) -> {
                    if (!KEY_BINDING.method_1417(key)) {
                        return;
                    }
                    class_1735 slot = ((AbstractContainerScreenAccessor)handledScreen).getFocusedSlot();
                    if (slot == null || !slot.method_7681()) {
                        return;
                    }
                    NetworthResult networth = NetworthCalculator.getItemNetworth(slot.method_7677());
                    if (networth.price() > 0.0) {
                        client.method_1507((class_437)new ValueBreakdownPopup(screen, networth));
                    }
                });
            }
        });
    }

    protected ValueBreakdownPopup(class_437 backgroundScreen, NetworthResult networthResult) {
        super((class_2561)class_2561.method_43471((String)"skyblocker.valueBreakdownPopup"), backgroundScreen);
        this.networthResult = networthResult;
        this.map = new EnumMap(Calculation.Type.class);
        for (Calculation calculation : networthResult.calculations()) {
            this.map.computeIfAbsent(calculation.type(), ignored -> new ArrayList()).add(calculation);
        }
    }

    @Override
    protected void method_25426() {
        class_8667 layout = class_8667.method_52741();
        layout.method_52736((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)class_2561.method_43469((String)"skyblocker.valueBreakdownPopup.baseItemPrice", (Object[])new Object[]{ValueBreakdownPopup.getCoinsText(this.networthResult.base(), this.networthResult.price())}), this.field_22793));
        for (Map.Entry<Calculation.Type, List<Calculation>> entry : this.map.entrySet()) {
            LayoutAppender appender = FORMATTERS.get(entry.getKey());
            if (appender == EMPTY_APPENDER) continue;
            layout.method_52736((class_8021)class_7852.method_46513((int)5));
            if (appender != null) {
                appender.appendTo(this.networthResult, entry.getValue(), layout);
                continue;
            }
            layout.method_52736((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)class_2561.method_43470((String)entry.getKey().toString()), this.field_22793));
            for (Calculation calculation : entry.getValue()) {
                layout.method_52738((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)class_2561.method_43470((String)(calculation.id() + ": ")).method_10852(ValueBreakdownPopup.getCoinsText(calculation.price())), this.field_22793), p -> p.method_46469(20));
            }
        }
        layout.method_52736((class_8021)class_7852.method_46513((int)10));
        layout.method_52738((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)class_2561.method_43469((String)"skyblocker.valueBreakdownPopup.total", (Object[])new Object[]{ValueBreakdownPopup.getCoinsText(this.networthResult.price())}), this.field_22793), class_7847::method_46470);
        this.scrollable = new class_11467(this.field_22787, (class_8133)layout, 300);
        this.scrollable.method_71807(200);
        this.scrollable.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        super.method_25426();
    }

    @Override
    protected void method_48640() {
        super.method_48640();
        this.scrollable.method_48222();
        this.scrollable.method_48229((this.field_22789 - this.scrollable.method_25368()) / 2, (this.field_22790 - this.scrollable.method_25364()) / 2);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        ValueBreakdownPopup.drawPopupBackground(context, this.scrollable.method_46426(), this.scrollable.method_46427(), this.scrollable.method_25368(), this.scrollable.method_25364());
    }

    private static class_2561 getCoinsText(double price) {
        return ValueBreakdownPopup.getCoinsText(price, 0.0);
    }

    private static class_2561 getCoinsText(double price, double totalPrice) {
        class_5250 text = class_2561.method_43469((String)"skyblocker.valueBreakdownPopup.coins", (Object[])new Object[]{Formatters.FLOAT_NUMBERS.format(price)}).method_27692(class_124.field_1065);
        if (totalPrice > 0.0) {
            text.method_27696(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43469((String)"skyblocker.valueBreakdownPopup.totalPricePercent", (Object[])new Object[]{Formatters.FLOAT_NUMBERS.format(price / totalPrice * 100.0)}))));
        }
        return text;
    }

    private static class_7940 createTextWidget(class_2561 text, class_327 textRenderer) {
        class_7940 widget = new class_7940(text, textRenderer);
        widget.method_75797(s -> {});
        return widget;
    }

    public static interface LayoutAppender {
        public void appendTo(NetworthResult var1, List<Calculation> var2, class_8667 var3);

        default public void appendCountAndPrice(Calculation calc, double totalPrice, class_5250 empty) {
            if (calc.count() > 1) {
                empty.method_10852((class_2561)class_2561.method_43470((String)" x").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(calc.count())).method_27692(class_124.field_1054));
            }
            empty.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080));
            empty.method_10852(ValueBreakdownPopup.getCoinsText(calc.price(), totalPrice));
            empty.method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080));
        }
    }

    private record BasicListAppender(class_2561 displayName, Function<String, class_2561> idFormatter) implements LayoutAppender
    {
        @Override
        public void appendTo(NetworthResult networthResult, List<Calculation> calculations, class_8667 layout) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            layout.method_52736((class_8021)ValueBreakdownPopup.createTextWidget(this.displayName, textRenderer));
            double total = 0.0;
            for (Calculation calc : calculations) {
                class_5250 empty = class_2561.method_43473();
                class_2561 apply = this.idFormatter.apply(calc.id());
                empty.method_10852(apply);
                this.appendCountAndPrice(calc, networthResult.price(), empty);
                total += calc.price();
                layout.method_52738((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)empty, textRenderer), p -> p.method_46469(15));
            }
            layout.method_52738((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)class_2561.method_43469((String)"skyblocker.valueBreakdownPopup.total", (Object[])new Object[]{ValueBreakdownPopup.getCoinsText(total, networthResult.price())}), textRenderer), p -> p.method_46469(10));
        }
    }

    private record BasicSingleAppender(class_2561 displayName, Function<String, class_2561> idFormatter, boolean hideIfWorthNothing) implements LayoutAppender
    {
        private BasicSingleAppender(class_2561 displayName, Function<String, class_2561> idFormatter) {
            this(displayName, idFormatter, true);
        }

        @Override
        public void appendTo(NetworthResult networthResult, List<Calculation> calculations, class_8667 layout) {
            Calculation calc;
            if (calculations.size() > 1) {
                LOGGER.warn("More than one calculation was found for type {}", (Object)calculations.getFirst().type());
            }
            if ((calc = calculations.getFirst()).price() <= 0.0 && this.hideIfWorthNothing) {
                return;
            }
            class_5250 empty = class_2561.method_43473();
            empty.method_10852(this.displayName());
            class_2561 apply = this.idFormatter.apply(calc.id());
            if (!apply.getString().isBlank()) {
                empty.method_27693(": ").method_10852(apply);
            }
            this.appendCountAndPrice(calc, networthResult.price(), empty);
            layout.method_52736((class_8021)ValueBreakdownPopup.createTextWidget((class_2561)empty, class_310.method_1551().field_1772));
        }
    }
}

