/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom;

import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.EnumUtils;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.NEURepoManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_9296;
import org.apache.commons.text.WordUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CustomAnimatedHelmetTextures {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Object2ObjectOpenHashMap<String, AnimatedHead> ANIMATED_HEADS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<AnimatedHead, AnimatedHeadStateTracker> STATE_TRACKERS = new Object2ObjectOpenHashMap();
    private static int ticks = 0;

    @Init
    public static void init() {
        NEURepoManager.runAsyncAfterLoad(CustomAnimatedHelmetTextures::loadAnimatedHeads);
        ClientTickEvents.END_CLIENT_TICK.register(_client -> ++ticks);
    }

    private static void loadAnimatedHeads() {
        try (InputStream stream = NEURepoManager.file("constants/animatedskulls.json").stream();){
            String data = new String(stream.readAllBytes());
            Map animatedHeads = (Map)AnimatedHead.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(data).getAsJsonObject().get("skins")).getOrThrow();
            CLIENT.execute(() -> {
                ANIMATED_HEADS.clear();
                ANIMATED_HEADS.putAll(animatedHeads);
                STATE_TRACKERS.clear();
            });
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Custom Animated Helmet Textures] Failed to load animated heads file.", (Throwable)e);
        }
    }

    public static Set<String> getAnimatedHeadIds() {
        return ANIMATED_HEADS.keySet();
    }

    public static String formatName(String id) {
        return WordUtils.capitalizeFully((String)id.replace('_', ' '));
    }

    public static @Nullable class_9296 animateHeadTexture(String id) {
        AnimatedHead head = (AnimatedHead)ANIMATED_HEADS.get((Object)id);
        if (head != null) {
            AnimatedHeadStateTracker tracker = (AnimatedHeadStateTracker)STATE_TRACKERS.computeIfAbsent((Object)head, AnimatedHeadStateTracker::new);
            if (tracker.lastRecordedTick == ticks) {
                return tracker.getCurrentFrame();
            }
            tracker.advanceTo(ticks);
            tracker.lastRecordedTick = ticks;
            return tracker.getCurrentFrame();
        }
        return null;
    }

    private record AnimatedHead(int tickThreshold, List<class_9296> frames) {
        private static final Codec<class_9296> FRAME_CODEC = Codec.STRING.xmap(AnimatedHead::fromString, AnimatedHead::toString);
        private static final Codec<AnimatedHead> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.xmap(i -> Math.max(i, 1), Function.identity()).fieldOf("ticks").forGetter(AnimatedHead::tickThreshold), (App)FRAME_CODEC.listOf().validate(AnimatedHead::validateFrames).fieldOf("textures").forGetter(AnimatedHead::frames)).apply((Applicative)instance, AnimatedHead::new));
        private static final Codec<Map<String, AnimatedHead>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC);

        private static class_9296 fromString(String string) {
            String[] split = string.split(":");
            UUID uuid = UUID.fromString(split[0]);
            PropertyMap propertyMap = ItemUtils.propertyMapWithTexture(split[1]);
            return class_9296.method_73307((GameProfile)new GameProfile(uuid, "custom", propertyMap));
        }

        private static String toString(class_9296 profile) {
            return String.valueOf(profile.method_73313().id()) + ":" + ((Property)profile.method_73313().properties().get((Object)"textures").iterator().next()).value();
        }

        private static DataResult<List<class_9296>> validateFrames(List<class_9296> frames) {
            return !frames.isEmpty() ? DataResult.success(frames) : DataResult.error(() -> "Expected at least a single frame for an animated head but there was none!");
        }
    }

    private static class AnimatedHeadStateTracker {
        private final AnimatedHead head;
        private int lastRecordedTick = 0;
        private class_9296 currentFrame;

        private AnimatedHeadStateTracker(AnimatedHead head) {
            this.head = head;
            this.currentFrame = head.frames().getFirst();
        }

        private void advanceTo(int ticks) {
            int advancedIndex = ticks / this.head.tickThreshold();
            this.currentFrame = EnumUtils.cycle(this.head.frames(), advancedIndex);
        }

        private class_9296 getCurrentFrame() {
            return Objects.requireNonNull(this.currentFrame);
        }
    }
}

