/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomArmorTrims {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomArmorTrims.class);
    public static final Object2ObjectOpenHashMap<ArmorTrimId, class_8053> TRIMS_CACHE = new Object2ObjectOpenHashMap();
    private static boolean trimsInitialized = false;

    @Init
    public static void init() {
        SkyblockEvents.JOIN.register(CustomArmorTrims::initializeTrimCache);
        ClientCommandRegistrationCallback.EVENT.register(CustomArmorTrims::registerCommand);
    }

    private static void initializeTrimCache() {
        class_310 client = class_310.method_1551();
        if (trimsInitialized || client == null && !Debug.debugEnabled()) {
            return;
        }
        try {
            TRIMS_CACHE.clear();
            class_7225.class_7874 wrapperLookup = Utils.getRegistryWrapperLookup();
            for (class_6880.class_6883 material : wrapperLookup.method_46762(class_7924.field_42083).method_42017().toList()) {
                for (class_6880.class_6883 pattern : wrapperLookup.method_46762(class_7924.field_42082).method_42017().toList()) {
                    class_8053 trim = new class_8053((class_6880)material, (class_6880)pattern);
                    TRIMS_CACHE.put((Object)new ArmorTrimId(material.method_40237().method_29177(), pattern.method_40237().method_29177()), (Object)trim);
                }
            }
            LOGGER.info("[Skyblocker] Successfully cached all armor trims!");
            trimsInitialized = true;
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Encountered an exception while caching armor trims", (Throwable)e);
        }
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"custom").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"armorTrim").executes(context -> CustomArmorTrims.customizeTrim((FabricClientCommandSource)context.getSource(), null, null))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"material", (ArgumentType)class_2232.method_9441()).suggests(CustomArmorTrims.getIdSuggestionProvider(class_7924.field_42083)).executes(context -> CustomArmorTrims.customizeTrim((FabricClientCommandSource)context.getSource(), (class_2960)context.getArgument("material", class_2960.class), null))).then(ClientCommandManager.argument((String)"pattern", (ArgumentType)class_2232.method_9441()).suggests(CustomArmorTrims.getIdSuggestionProvider(class_7924.field_42082)).executes(context -> CustomArmorTrims.customizeTrim((FabricClientCommandSource)context.getSource(), (class_2960)context.getArgument("material", class_2960.class), (class_2960)context.getArgument("pattern", class_2960.class))))))));
    }

    private static SuggestionProvider<FabricClientCommandSource> getIdSuggestionProvider(class_5321<? extends class_2378<?>> registryKey) {
        return (context, builder) -> ((FabricClientCommandSource)context.getSource()).method_41213(registryKey, class_2172.class_7078.field_37263, builder, context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int customizeTrim(FabricClientCommandSource source, class_2960 material, class_2960 pattern) {
        class_1799 heldItem = source.getPlayer().method_6047();
        if (Utils.isOnSkyblock() && heldItem != null) {
            if (!heldItem.method_31573(class_3489.field_41890)) {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.notAnArmorPiece")));
                return 1;
            }
            String itemUuid = heldItem.getUuid();
            if (itemUuid.isEmpty()) {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.noItemUuid")));
                return 1;
            }
            Object2ObjectOpenHashMap<String, ArmorTrimId> customArmorTrims = SkyblockerConfigManager.get().general.customArmorTrims;
            if (material == null && pattern == null) {
                if (customArmorTrims.containsKey((Object)itemUuid)) {
                    SkyblockerConfigManager.update(config -> config.general.customArmorTrims.remove((Object)itemUuid));
                    source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.removed")));
                    return 1;
                }
                source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.neverHad")));
                return 1;
            }
            ArmorTrimId trimId = new ArmorTrimId(material, pattern);
            if (TRIMS_CACHE.get((Object)trimId) == null) {
                source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.invalidMaterialOrPattern")));
                return 1;
            }
            SkyblockerConfigManager.update(config -> config.general.customArmorTrims.put((Object)itemUuid, (Object)trimId));
            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.added")));
            return 1;
        }
        source.sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.customArmorTrims.unableToSetTrim")));
        return 1;
    }

    public record ArmorTrimId(class_2960 material, class_2960 pattern) implements Pair<class_2960, class_2960>
    {
        public static final Codec<ArmorTrimId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("material").forGetter(ArmorTrimId::material), (App)class_2960.field_25139.fieldOf("pattern").forGetter(ArmorTrimId::pattern)).apply((Applicative)instance, ArmorTrimId::new));

        public class_2960 left() {
            return this.material();
        }

        public class_2960 right() {
            return this.pattern();
        }
    }
}

