/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9296;
import org.slf4j.Logger;

public class CustomHelmetTextures {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final List<NamedTexture> TEXTURES = new ArrayList<NamedTexture>();
    public static final Object2ObjectOpenHashMap<String, class_9296> PROFILE_CACHE = new Object2ObjectOpenHashMap();
    private static final Pattern LEVEL_PATTERN = Pattern.compile("\\[Lvl[^\\]]*\\]");

    @Init
    public static void init() {
        ItemRepository.runAsyncAfterImport(CustomHelmetTextures::loadTextures);
    }

    private static void loadTextures() {
        try {
            if (!ItemRepository.filesImported()) {
                return;
            }
            TEXTURES.clear();
            ObjectOpenHashSet seen = new ObjectOpenHashSet();
            ItemRepository.getItemsStream().filter(stack -> stack.method_31574(class_1802.field_8575)).forEach(arg_0 -> CustomHelmetTextures.lambda$loadTextures$1((ObjectSet)seen, arg_0));
            TEXTURES.sort(Comparator.comparing(NamedTexture::internalName));
            LOGGER.info("[Skyblocker] Loaded and sorted {} helmet textures from repo", (Object)TEXTURES.size());
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to load helmet textures from repo", (Throwable)e);
        }
    }

    private static String cleanName(String name) {
        return LEVEL_PATTERN.matcher(name).replaceAll("").trim();
    }

    public static List<NamedTexture> getTextures() {
        return TEXTURES;
    }

    public static class_9296 getProfile(String texture) {
        return (class_9296)PROFILE_CACHE.computeIfAbsent((Object)texture, t -> class_9296.method_73307((GameProfile)new GameProfile(UUID.nameUUIDFromBytes(t.getBytes(StandardCharsets.UTF_8)), "custom", ItemUtils.propertyMapWithTexture(t))));
    }

    private static /* synthetic */ void lambda$loadTextures$1(ObjectSet seen, class_1799 stack) {
        String texture = ItemUtils.getHeadTexture(stack);
        if (texture.isEmpty() || !seen.add((Object)texture)) {
            return;
        }
        String name = CustomHelmetTextures.cleanName(stack.method_7964().getString());
        TEXTURES.add(new NamedTexture(name, texture, stack.getNeuName()));
    }

    public record NamedTexture(String name, String texture, String internalName) {
    }
}

