/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.custom.CustomAnimatedHelmetTextures;
import de.hysky.skyblocker.skyblock.item.custom.CustomHelmetTextures;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_9017;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

public class HeadSelectionWidget
extends class_9017 {
    private static final class_2960 INNER_SPACE_TEXTURE = SkyblockerMod.id("menu_inner_space");
    private final List<HeadButton> allButtons = new ArrayList<HeadButton>();
    private final List<HeadButton> visibleButtons = new ArrayList<HeadButton>();
    private final class_342 searchField;
    private final HeadButton noneButton;
    private int buttonsPerRow = 1;
    private class_1799 currentItem;
    private @Nullable HeadButton selectedButton;

    public HeadSelectionWidget(int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)"HeadSelection"));
        this.searchField = new class_342(class_310.method_1551().field_1772, x + 3, y + 3, width - 6, 12, (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"));
        this.searchField.method_1863(this::filterButtons);
        for (CustomHelmetTextures.NamedTexture tex : CustomHelmetTextures.getTextures()) {
            class_1799 head = ProfileViewerUtils.createSkull(tex.texture());
            HeadButton button = new HeadButton(tex.name(), tex.texture(), head, this::onClick);
            this.allButtons.add(button);
        }
        for (String id : CustomAnimatedHelmetTextures.getAnimatedHeadIds()) {
            AnimatedHeadButton button = new AnimatedHeadButton(id, this::onClick);
            this.allButtons.add(button);
        }
        this.noneButton = new HeadButton("", null, new class_1799((class_1935)class_1802.field_8077), _ignored -> this.onClick(null));
        this.filterButtons("");
    }

    private void layoutButtons() {
        this.buttonsPerRow = Math.max(1, (this.method_25368() - 6) / 20);
        int startY = this.searchField.method_55443() + 3;
        for (int i = 0; i < this.visibleButtons.size(); ++i) {
            HeadButton button = this.visibleButtons.get(i);
            button.method_48229(this.method_46426() + 3 + i % this.buttonsPerRow * 20, startY + i / this.buttonsPerRow * 20);
        }
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.searchField.method_46421(x + 3);
        this.layoutButtons();
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.searchField.method_46419(y + 3);
        this.layoutButtons();
    }

    public void method_25358(int width) {
        super.method_25358(width);
        this.searchField.method_25358(width - 6);
        this.layoutButtons();
    }

    private void onClick(HeadButton button) {
        this.selectedButton = button;
        this.updateConfig();
        this.updateButtons();
    }

    private void updateConfig() {
        if (this.currentItem == null) {
            return;
        }
        String uuid = this.currentItem.getUuid();
        SkyblockerConfigManager.updateOnly(config -> {
            HeadButton selector0$temp = this.selectedButton;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnimatedHeadButton.class, HeadButton.class}, (Object)((Object)selector0$temp), index$1)) {
                case -1: {
                    config.general.customHelmetTextures.remove((Object)uuid);
                    config.general.customAnimatedHelmetTextures.remove((Object)uuid);
                    break;
                }
                case 0: {
                    AnimatedHeadButton button = (AnimatedHeadButton)selector0$temp;
                    config.general.customAnimatedHelmetTextures.put((Object)uuid, (Object)button.id);
                    config.general.customHelmetTextures.remove((Object)uuid);
                    break;
                }
                default: {
                    HeadButton button = selector0$temp;
                    config.general.customHelmetTextures.put((Object)uuid, (Object)Objects.requireNonNull(button.texture));
                    config.general.customAnimatedHelmetTextures.remove((Object)uuid);
                }
            }
        });
    }

    private void updateButtons() {
        for (HeadButton b : this.allButtons) {
            b.selected = ((Object)((Object)b)).equals((Object)this.selectedButton);
        }
        this.noneButton.selected = this.selectedButton == null;
    }

    private void filterButtons(String search) {
        this.method_44382(0.0);
        String s = search.toLowerCase(Locale.ENGLISH);
        this.visibleButtons.clear();
        this.visibleButtons.add(this.noneButton);
        for (HeadButton b : this.allButtons) {
            if (!b.name.toLowerCase(Locale.ENGLISH).contains(s)) continue;
            this.visibleButtons.add(b);
        }
        this.layoutButtons();
        this.updateButtons();
    }

    public List<? extends class_364> method_25396() {
        int startY = this.searchField.method_55443() + 3;
        int endY = this.method_46427() + this.method_25364() - 2;
        int scrollY = (int)this.method_44387();
        ArrayList<HeadButton> list = new ArrayList<HeadButton>();
        for (HeadButton b : this.visibleButtons) {
            int y = b.method_46427() - scrollY;
            if (y + b.method_25364() <= startY || y >= endY) continue;
            list.add(b);
        }
        list.add((HeadButton)this.searchField);
        return list;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(class_10799.field_56883, INNER_SPACE_TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        int startY = this.searchField.method_55443() + 3;
        int startX = this.method_46426() + 2;
        int endX = this.method_46426() + this.method_25368() - 2;
        int endY = this.method_46427() + this.method_25364() - 2;
        context.method_44379(startX, startY, endX, endY);
        int scrollY = (int)this.method_44387();
        HeadButton hovered = null;
        for (HeadButton b : this.visibleButtons) {
            int originalY = b.method_46427();
            int y = originalY - scrollY;
            if (y + b.method_25364() <= startY || y >= endY) continue;
            b.method_46419(y);
            b.method_25394(context, mouseX, mouseY, delta);
            if (b.method_25405(mouseX, mouseY) && mouseX >= startX && mouseX < endX && mouseY >= startY && mouseY < endY) {
                hovered = b;
            }
            b.method_46419(originalY);
        }
        this.method_44396(context, mouseX, mouseY);
        context.method_44380();
        if (hovered != null && !hovered.name.isEmpty()) {
            context.method_51438(class_310.method_1551().field_1772, class_2561.method_30163((String)hovered.name), mouseX, mouseY);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.searchField.method_25402(click, doubled)) {
            this.method_25395((class_364)this.searchField);
            return true;
        }
        double adjustedMouseY = click.comp_4799() + this.method_44387();
        if (this.method_44392()) {
            int scrollbarX = this.method_65507();
            if (click.comp_4798() >= (double)scrollbarX && click.comp_4798() < (double)(scrollbarX + 6)) {
                int thumbY = this.method_65508();
                int thumbHeight = this.method_44394();
                if (click.comp_4799() >= (double)thumbY && click.comp_4799() < (double)(thumbY + thumbHeight)) {
                    adjustedMouseY = click.comp_4799();
                }
            }
        }
        return super.method_25402(new class_11909(click.comp_4798(), adjustedMouseY, click.comp_4800()), doubled);
    }

    public boolean method_25400(class_11905 input) {
        if (this.searchField.method_25370() && this.searchField.method_25400(input)) {
            return true;
        }
        return super.method_25400(input);
    }

    public boolean method_25404(class_11908 input) {
        if (this.searchField.method_25370() && this.searchField.method_25404(input)) {
            return true;
        }
        return super.method_25404(input);
    }

    protected int method_44395() {
        int rows = Math.ceilDiv(this.visibleButtons.size(), this.buttonsPerRow);
        return rows * 20 + this.searchField.method_25364() + 9;
    }

    protected double method_44393() {
        return 10.0;
    }

    protected void method_47399(class_6382 builder) {
    }

    public void setCurrentItem(class_1799 item) {
        this.currentItem = item;
        String uuid = item.getUuid();
        String animatedHeadId = (String)SkyblockerConfigManager.get().general.customAnimatedHelmetTextures.get((Object)uuid);
        String customHeadTexture = (String)SkyblockerConfigManager.get().general.customHelmetTextures.get((Object)uuid);
        HeadButton intendedSelected = animatedHeadId != null ? (HeadButton)this.allButtons.stream().filter(AnimatedHeadButton.class::isInstance).map(AnimatedHeadButton.class::cast).filter(animatedHead -> animatedHead.id.equals(animatedHeadId)).findFirst().orElse(null) : (customHeadTexture != null ? (HeadButton)this.allButtons.stream().filter(Predicate.not(AnimatedHeadButton.class::isInstance)).filter(head -> Objects.requireNonNull(head.texture).equals(customHeadTexture)).findFirst().orElse(null) : null);
        this.selectedButton = intendedSelected;
        this.updateButtons();
        this.filterButtons(this.searchField.method_1882());
    }

    private static class HeadButton
    extends class_339 {
        private final String name;
        private final @Nullable String texture;
        private final @Nullable class_1799 head;
        private final Consumer<HeadButton> onPress;
        private boolean selected = false;

        HeadButton(String name, @Nullable String texture, @Nullable class_1799 head, Consumer<HeadButton> onPress) {
            super(0, 0, 20, 20, (class_2561)class_2561.method_43473());
            this.name = name;
            this.texture = texture;
            this.head = head;
            this.onPress = onPress;
        }

        protected class_1799 getHead() {
            return Objects.requireNonNull(this.head);
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51427(this.getHead(), this.method_46426() + 2, this.method_46427() + 2);
            if (this.selected) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x3000FF00);
            }
            if (this.method_49606()) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), 0x20FFFFFF);
            }
            this.method_76256(context);
        }

        public void method_25348(class_11909 click, boolean doubled) {
            this.onPress.accept(this);
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private static class AnimatedHeadButton
    extends HeadButton {
        private final String id;

        AnimatedHeadButton(String id, Consumer<HeadButton> onPress) {
            super(CustomAnimatedHelmetTextures.formatName(id), null, null, onPress);
            this.id = id;
        }

        @Override
        protected class_1799 getHead() {
            class_9296 profile = CustomAnimatedHelmetTextures.animateHeadTexture(this.id);
            if (profile != null) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
                stack.method_57379(class_9334.field_49617, (Object)profile);
                return stack;
            }
            return Ico.BARRIER;
        }
    }
}

