/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public class BestiaryLevelAdder
extends SimpleSlotTextAdder {
    private static final Pattern BESTIARY = Pattern.compile("^[\\w '-]+ (?<level>[IVXLCDM]+)$");
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("bestiary_level", "skyblocker.config.uiAndVisuals.slotText.bestiaryLevel");

    public BestiaryLevelAdder() {
        super("(?:\\(\\d+\\/\\d+\\) )?(?:Bestiary|Fishing) \u279c .+", CONFIG_INFORMATION);
    }

    @Override
    public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
        if (!(slotId >= 10 && slotId <= 16 || slotId >= 19 && slotId <= 25 || slotId >= 28 && slotId <= 34 || slotId >= 37 && slotId <= 43)) {
            return List.of();
        }
        if (stack.method_7960() || stack.method_31574(class_1802.field_8298)) {
            return List.of();
        }
        Matcher matcher = BESTIARY.matcher(stack.method_7964().getString());
        if (matcher.matches()) {
            int level = RomanNumerals.romanToDecimal(matcher.group("level"));
            if (ItemUtils.getLoreLineIf(stack, s -> s.contains("Overall Progress: 100%")) != null) {
                return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)String.valueOf(level)).method_54663(15054859));
            }
            return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)String.valueOf(level)).method_54663(16768449));
        }
        return List.of();
    }
}

