/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.lang3.math.NumberUtils;
import org.jspecify.annotations.Nullable;

public class CatacombsLevelAdder {
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("catacombs_level", "skyblocker.config.uiAndVisuals.slotText.catacombsLevel");

    private CatacombsLevelAdder() {
    }

    public static String getBracketedLevelFromName(class_1799 itemStack) {
        String name = itemStack.method_7964().getString();
        if (!name.startsWith("[Lvl ")) {
            return null;
        }
        int index = name.indexOf(93);
        if (index == -1) {
            return null;
        }
        return name.substring(5, index);
    }

    public static class ReadyUp
    extends SimpleSlotTextAdder {
        public ReadyUp() {
            super("^Ready Up", CONFIG_INFORMATION);
        }

        @Override
        public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
            switch (slotId) {
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    String level = CatacombsLevelAdder.getBracketedLevelFromName(stack);
                    if (!NumberUtils.isDigits((String)level)) {
                        return List.of();
                    }
                    return SlotText.bottomLeftList((class_2561)class_2561.method_43470((String)level).method_54663(16768449));
                }
            }
            return List.of();
        }
    }

    public static class DungeonClasses
    extends SimpleSlotTextAdder {
        public DungeonClasses() {
            super("^Dungeon Classes", CONFIG_INFORMATION);
        }

        @Override
        public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
            switch (slotId) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    String level = CatacombsLevelAdder.getBracketedLevelFromName(stack);
                    if (!NumberUtils.isDigits((String)level)) {
                        return List.of();
                    }
                    return SlotText.bottomLeftList((class_2561)class_2561.method_43470((String)level).method_54663(16768449));
                }
            }
            return List.of();
        }
    }

    public static class Dungeoneering
    extends SimpleSlotTextAdder {
        private static final Pattern LEVEL_PATTERN = Pattern.compile(".*?(?:(?: (?<arabic>\\d+)| (?<roman>[IVXLC]+))(?: \u272f)?)?");

        public Dungeoneering() {
            super("^Dungeoneering", CONFIG_INFORMATION);
        }

        @Override
        public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
            switch (slotId) {
                case 12: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    String level;
                    Matcher matcher = LEVEL_PATTERN.matcher(stack.method_7964().getString());
                    if (!matcher.matches()) {
                        return List.of();
                    }
                    String arabic = matcher.group("arabic");
                    String roman = matcher.group("roman");
                    if (arabic == null && roman == null) {
                        return SlotText.bottomLeftList((class_2561)class_2561.method_43470((String)"0").method_54663(16768449));
                    }
                    if (arabic != null) {
                        if (!NumberUtils.isDigits((String)arabic)) {
                            return List.of();
                        }
                        level = arabic;
                    } else {
                        if (!RomanNumerals.isValidRomanNumeral(roman)) {
                            return List.of();
                        }
                        level = String.valueOf(RomanNumerals.romanToDecimal(roman));
                    }
                    return SlotText.bottomLeftList((class_2561)class_2561.method_43470((String)level).method_54663(16768449));
                }
            }
            return List.of();
        }
    }
}

