/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public class ChipLevelAdder
extends SimpleSlotTextAdder {
    private static final Pattern LEVEL = Pattern.compile("Level (?<level>\\d+)/?(?<max>\\d+)?");
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("chip_level", "skyblocker.config.uiAndVisuals.slotText.chipLevel", "skyblocker.config.uiAndVisuals.slotText.chipLevel.@tooltip");

    public ChipLevelAdder() {
        super("^Manage Chips$", CONFIG_INFORMATION);
    }

    @Override
    public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
        if (slotId < 18 || slotId > 35 || stack.method_31574(class_1802.field_8298)) {
            return List.of();
        }
        List lore = stack.skyblocker$getLoreStrings();
        if (lore.isEmpty()) {
            return List.of();
        }
        String levelLine = (String)lore.getFirst();
        Matcher matcher = LEVEL.matcher(levelLine);
        if (!matcher.matches()) {
            return List.of();
        }
        String level = matcher.group("level");
        String max = matcher.group("max");
        int color = 16768449;
        if (Objects.equals(level, max)) {
            switch (max) {
                case "10": {
                    color = 1936872;
                    break;
                }
                case "15": {
                    color = 10750946;
                    break;
                }
                case "20": {
                    color = 15054859;
                }
            }
        }
        return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)level).method_54663(color));
    }
}

