/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public class EssenceShopAdder
extends SimpleSlotTextAdder {
    private static final Pattern ESSENCELEVEL = Pattern.compile("^[\\w ]+ (?<level>[IVXLCDM]+)$");
    private static final Pattern UNLOCKED = Pattern.compile("UNLOCKED");
    private static final Pattern ESSENCE = Pattern.compile("Your \\w+ Essence: (?<essence>[\\d,]+)");
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("essence_shop", "skyblocker.config.uiAndVisuals.slotText.essenceShop", "skyblocker.config.uiAndVisuals.slotText.essenceShop.@Tooltip");

    public EssenceShopAdder() {
        super(".*Essence Shop", CONFIG_INFORMATION);
    }

    @Override
    public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
        if (slotId > 53) {
            return List.of();
        }
        Matcher essenceLevelMatcher = ESSENCELEVEL.matcher(stack.method_7964().getString());
        Matcher essenceAmountMatcher = ItemUtils.getLoreLineIfMatch(stack, ESSENCE);
        if (essenceLevelMatcher.matches()) {
            int level = RomanNumerals.romanToDecimal(essenceLevelMatcher.group("level"));
            Matcher unlockedMatcher = ItemUtils.getLoreLineIfMatch(stack, UNLOCKED);
            if (unlockedMatcher == null) {
                --level;
            }
            return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)String.valueOf(level)).method_54663(16768449));
        }
        if (essenceAmountMatcher == null) {
            return List.of();
        }
        String essenceAmount = essenceAmountMatcher.group("essence").replace(",", "");
        if (!essenceAmount.matches("-?\\d+")) {
            return List.of();
        }
        return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)Formatters.SHORT_FLOAT_NUMBERS.format(Integer.parseInt(essenceAmount))).method_54663(16768449));
    }
}

