/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.RomanNumerals;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public class MinionLevelAdder
extends SimpleSlotTextAdder {
    private static final Pattern MINION_PATTERN = Pattern.compile(".* Minion ([IVXLCDM]+)");
    private static final SlotTextAdder.ConfigInformation CONFIG_INFORMATION = new SlotTextAdder.ConfigInformation("minion_level", "skyblocker.config.uiAndVisuals.slotText.minionLevel");

    public MinionLevelAdder() {
        super(CONFIG_INFORMATION);
    }

    @Override
    public List<SlotText> getText(@Nullable class_1735 slot, class_1799 stack, int slotId) {
        if (!stack.method_31574(class_1802.field_8575)) {
            return List.of();
        }
        Matcher matcher = MINION_PATTERN.matcher(stack.method_7964().getString());
        if (!matcher.matches()) {
            return List.of();
        }
        String romanNumeral = matcher.group(1);
        if (!RomanNumerals.isValidRomanNumeral(romanNumeral)) {
            return List.of();
        }
        int level = RomanNumerals.romanToDecimal(romanNumeral);
        return SlotText.topRightList((class_2561)class_2561.method_43470((String)String.valueOf(level)).method_54663(16768449));
    }
}

