/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.item.ItemProtection;
import de.hysky.skyblocker.skyblock.item.background.ItemBackgroundManager;
import de.hysky.skyblocker.skyblock.item.slottext.SlotTextManager;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_6903;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackpackPreview {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackpackPreview.class);
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    private static final Pattern ECHEST_PATTERN = Pattern.compile("Ender Chest.*\\((\\d+)/\\d+\\)");
    private static final Pattern BACKPACK_PATTERN = Pattern.compile("Backpack.*\\(Slot #(\\d+)\\)");
    private static final int STORAGE_SIZE = 27;
    private static final Storage[] storages = new Storage[27];
    private static String loaded;
    private static volatile Path saveDir;

    private BackpackPreview() {
    }

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 handledScreen = (class_465)screen;
                ScreenEvents.remove((class_437)screen).register(screen1 -> BackpackPreview.updateStorage(handledScreen));
            }
        });
    }

    public static void tick() {
        if (Utils.isOnSkyblock()) {
            BackpackPreview.saveStorages();
            String id = class_310.method_1551().method_1548().method_44717().toString().replaceAll("-", "") + "/" + Utils.getProfileId();
            if (!id.equals(loaded)) {
                saveDir = SkyblockerMod.CONFIG_DIR.resolve("backpack-preview/" + id);
                CompletableFuture.runAsync(() -> {
                    try {
                        Files.createDirectories(saveDir, new FileAttribute[0]);
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker] Failed to create the backpack preview save directory! Path: {}", (Object)saveDir, (Object)e);
                    }
                }, Executors.newVirtualThreadPerTaskExecutor());
                loaded = id;
                BackpackPreview.loadStorages();
            }
        }
    }

    private static void loadStorages() {
        int index = 0;
        while (index < 27) {
            BackpackPreview.storages[index] = null;
            int index2 = index++;
            CompletableFuture.supplyAsync(() -> {
                Path storageFile = saveDir.resolve(index2 + ".nbt");
                if (Files.isRegularFile(storageFile, new LinkOption[0])) {
                    try {
                        return (Storage)Storage.CODEC.parse(BackpackPreview.getOps(), (Object)class_2507.method_10633((Path)storageFile)).getOrThrow();
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker] Failed to load backpack preview file: {}", (Object)storageFile.getFileName().toString(), (Object)e);
                    }
                }
                return null;
            }, Executors.newVirtualThreadPerTaskExecutor()).thenAcceptAsync(storage -> {
                BackpackPreview.storages[index2] = storage;
            }, (Executor)class_310.method_1551());
        }
    }

    private static class_6903<class_2520> getOps() {
        return Utils.getRegistryWrapperLookup().method_57093((DynamicOps)class_2509.field_11560);
    }

    private static void saveStorages() {
        for (int index = 0; index < 27; ++index) {
            if (storages[index] == null || !BackpackPreview.storages[index].dirty) continue;
            BackpackPreview.saveStorage(index);
        }
    }

    private static void saveStorage(int index) {
        Storage storage = storages[index];
        CompletableFuture.runAsync(() -> {
            Path storageFile = saveDir.resolve(index + ".nbt");
            try {
                class_2507.method_10630((class_2487)((class_2487)Storage.CODEC.encodeStart(BackpackPreview.getOps(), (Object)storage).getOrThrow()), (Path)storageFile);
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to save backpack preview file: {}", (Object)storageFile.getFileName(), (Object)e);
            }
        }, Executors.newVirtualThreadPerTaskExecutor()).thenRunAsync(() -> storage.markClean(), (Executor)class_310.method_1551());
    }

    private static void updateStorage(class_465<?> handledScreen) {
        String title = handledScreen.method_25440().getString();
        int index = BackpackPreview.getStorageIndexFromTitle(title);
        if (index != -1) {
            BackpackPreview.storages[index] = new Storage(((class_1735)handledScreen.method_17577().field_7761.getFirst()).field_7871, title, true);
        }
    }

    public static boolean renderPreview(class_332 context, class_437 screen, int index, int mouseX, int mouseY) {
        if (index >= 9 && index < 18) {
            index -= 9;
        } else if (index >= 27 && index < 45) {
            index -= 18;
        } else {
            return false;
        }
        if (storages[index] == null) {
            return false;
        }
        int rows = (storages[index].size() - 9) / 9;
        int x = mouseX + 184 >= screen.field_22789 ? mouseX - 188 : mouseX + 8;
        int y = Math.max(0, mouseY - 16);
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, 176, rows * 18 + 17, 256, 256);
        context.method_25290(class_10799.field_56883, TEXTURE, x, y + rows * 18 + 17, 0.0f, 215.0f, 176, 7, 256, 256);
        class_327 textRenderer = class_310.method_1551().field_1772;
        context.method_51433(textRenderer, storages[index].name(), x + 8, y + 6, -12566464, false);
        for (int i = 9; i < storages[index].size(); ++i) {
            class_1799 currentStack = storages[index].getStack(i);
            int itemX = x + (i - 9) % 9 * 18 + 8;
            int itemY = y + (i - 9) / 9 * 18 + 18;
            ItemBackgroundManager.drawBackgrounds(currentStack, context, itemX, itemY);
            if (ItemProtection.isItemProtected(currentStack)) {
                context.method_25290(class_10799.field_56883, ItemProtection.ITEM_PROTECTION_TEX, itemX, itemY, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            context.method_51427(currentStack, itemX, itemY);
            context.method_51431(textRenderer, currentStack, itemX, itemY);
            SlotTextManager.renderSlotText(context, textRenderer, null, currentStack, i, itemX, itemY);
        }
        return true;
    }

    private static int getStorageIndexFromTitle(String title) {
        Matcher echest = ECHEST_PATTERN.matcher(title);
        if (echest.find()) {
            return Integer.parseInt(echest.group(1)) - 1;
        }
        Matcher backpack = BACKPACK_PATTERN.matcher(title);
        if (backpack.find()) {
            return Integer.parseInt(backpack.group(1)) + 8;
        }
        return -1;
    }

    private static class Storage {
        private static final Codec<Storage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Storage::name), (App)ItemUtils.EMPTY_ALLOWING_ITEMSTACK_CODEC.listOf().fieldOf("items").forGetter(Storage::getItemList)).apply((Applicative)instance, Storage::create));
        private final class_1263 inventory;
        private final String name;
        private boolean dirty;

        private Storage(class_1263 inventory, String name, boolean dirty) {
            this.inventory = inventory;
            this.name = name;
            this.dirty = dirty;
        }

        private String name() {
            return this.name;
        }

        private int size() {
            return this.inventory.method_5439();
        }

        private class_1799 getStack(int index) {
            return this.inventory.method_5438(index);
        }

        private void markClean() {
            this.dirty = false;
        }

        private static Storage create(String name, List<class_1799> items) {
            class_1277 inventory = new class_1277((class_1799[])items.toArray(class_1799[]::new));
            return new Storage((class_1263)inventory, name, false);
        }

        private List<class_1799> getItemList() {
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (int i = 0; i < this.size(); ++i) {
                items.add(this.getStack(i));
            }
            return items;
        }
    }
}

