/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.GeneralConfig;
import de.hysky.skyblocker.events.ItemPriceUpdateEvent;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.CraftPriceTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.info.DataTooltipInfoType;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTooltip {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)ItemTooltip.class.getName());
    private static final class_310 client = class_310.method_1551();
    public static final Supplier<GeneralConfig.ItemTooltip> config = () -> SkyblockerConfigManager.get().general.itemTooltip;
    private static volatile boolean sentNullWarning = false;
    public static int minute = 0;

    @Deprecated(since="1.22.0", forRemoval=true)
    public static String getNeuName(String id, String apiId) {
        LOGGER.error("[Skyblocker Item Tooltip] ItemTooltip.getNeuName is deprecated and will not work. Use ItemStack#getNeuName instead.");
        return "";
    }

    public static void nullWarning() {
        if (!sentNullWarning && ItemTooltip.client.field_1724 != null) {
            LOGGER.warn(Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.itemTooltip.nullMessage").method_27692(class_124.field_1061)).getString());
            sentNullWarning = true;
        }
    }

    public static class_2561 getCoinsMessage(double price, int count) {
        return ItemTooltip.getCoinsMessage(price, count, false);
    }

    public static class_2561 getCoinsMessage(double price, int count, boolean preCounted) {
        String priceString = String.format(Locale.ENGLISH, "%1$,.1f", preCounted ? price / (double)count : price);
        if (count == 1) {
            return class_2561.method_43470((String)(priceString + " Coins")).method_27692(class_124.field_1062);
        }
        String priceStringTotal = String.format(Locale.ENGLISH, "%1$,.1f", preCounted ? price : price * (double)count);
        return class_2561.method_43470((String)(priceStringTotal + " Coins ")).method_27692(class_124.field_1062).method_10852((class_2561)class_2561.method_43470((String)("(" + priceString + " each)")).method_27692(class_124.field_1080));
    }

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(() -> {
            if (!Utils.isOnSkyblock() && 0 < minute) {
                sentNullWarning = false;
                return;
            }
            if (++minute % 60 == 0) {
                sentNullWarning = false;
            }
            ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.of(TooltipInfoType.NPC, TooltipInfoType.BAZAAR, TooltipInfoType.LOWEST_BINS, TooltipInfoType.ONE_DAY_AVERAGE, TooltipInfoType.THREE_DAY_AVERAGE, TooltipInfoType.MOTES, TooltipInfoType.MUSEUM, TooltipInfoType.COLOR, TooltipInfoType.ACCESSORIES).map(DataTooltipInfoType.class::cast).map(DataTooltipInfoType::downloadIfEnabled).toArray(CompletableFuture[]::new)).thenRun(((ItemPriceUpdateEvent)ItemPriceUpdateEvent.ON_PRICE_UPDATE.invoker())::onPriceUpdate)).exceptionally(e -> {
                LOGGER.error("[Skyblocker] Encountered unknown error while downloading tooltip data", e);
                return null;
            });
            CraftPriceTooltip.clearCache();
        }, 1200, true);
    }
}

