/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.TooltipAdder;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLongImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectLongPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BitsHelper
extends SimpleContainerSolver
implements TooltipAdder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern BITS_PATTERN = Pattern.compile("Cost (?<amount>[\\d,]+) Bits");
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("Click to browse!");
    @Language(value="RegExp")
    private static final String TITLE_PATTERN = ".*(?:Community Shop|Bits Shop).*";
    private static final String LOGS_PREFIX = "[Skyblocker Bits Helper] ";
    private static final List<String> GOOD_SELLING_ITEMS = List.of("KAT_FLOWER", "KAT_BOUQUET", "HEAT_CORE", "ULTIMATE_CARROT_CANDY_UPGRADE", "TALISMAN_ENRICHMENT_SWAPPER", "GOD_POTION_2", "KISMET_FEATHER", "MATRIARCH_PARFUM", "AUTOPET_RULES_2");
    private static final Object2IntMap<String> CAT_KAT = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"KAT_FLOWER", 500);
        map.put((Object)"KAT_BOUQUET", 2500);
    });
    private static final Object2IntMap<String> CAT_UPGRADE_COMPONENTS = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"HEAT_CORE", 3000);
        map.put((Object)"HYPER_CATALYST_UPGRADE", 300);
        map.put((Object)"ULTIMATE_CARROT_CANDY_UPGRADE", 8000);
        map.put((Object)"COLOSSAL_EXP_BOTTLE_UPGRADE", 1200);
        map.put((Object)"JUMBO_BACKPACK_UPGRADE", 4000);
        map.put((Object)"MINION_STORAGE_EXPANDER", 1500);
    });
    private static final Object2IntMap<String> CAT_SACKS = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"POCKET_SACK_IN_A_SACK", 8000);
        map.put((Object)"LARGE_DUNGEON_SACK", 14000);
        map.put((Object)"RUNE_SACK", 14000);
        map.put((Object)"FLOWER_SACK", 14000);
        map.put((Object)"DWARVEN_MINES_SACK", 14000);
        map.put((Object)"CRYSTAL_HOLLOWS_SACK", 14000);
    });
    private static final Object2IntMap<String> CAT_ABIPHONE = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"TRIO_CONTACTS_ADDON", 6450);
        map.put((Object)"ABICASE_SUMSUNG_1", 15000);
        map.put((Object)"ABICASE_SUMSUNG_2", 25000);
        map.put((Object)"ABICASE_REZAR", 26000);
        map.put((Object)"ABICASE_BLUE_AQUA", 17000);
        map.put((Object)"ABICASE_BLUE_BLUE", 17000);
        map.put((Object)"ABICASE_BLUE_GREEN", 17000);
        map.put((Object)"ABICASE_BLUE_RED", 17000);
        map.put((Object)"ABICASE_BLUE_YELLOW", 17000);
    });
    private static final Object2IntMap<String> CAT_DYES = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"DYE_PURE_WHITE", 250000);
        map.put((Object)"DYE_PURE_BLACK", 250000);
    });
    private static final Object2IntMap<String> CAT_ENCHANTS = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"ENCHANTMENT_HECATOMB_1", 6000);
        map.put((Object)"ENCHANTMENT_EXPERTISE_1", 4000);
        map.put((Object)"ENCHANTMENT_COMPACT_1", 4000);
        map.put((Object)"ENCHANTMENT_CULTIVATING_1", 4000);
        map.put((Object)"ENCHANTMENT_CHAMPION_1", 4000);
        map.put((Object)"ENCHANTMENT_TOXOPHILITE_1", 4000);
    });
    private static final Object2IntMap<String> CAT_ENRICHMENTS = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)"TALISMAN_ENRICHMENT_SWAPPER", 200);
        map.put((Object)"TALISMAN_ENRICHMENT_WALK_SPEED", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_INTELLIGENCE", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_CRITICAL_DAMAGE", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_CRITICAL_CHANCE", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_STRENGTH", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_DEFENSE", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_HEALTH", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_MAGIC_FIND", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_FEROCITY", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_SEA_CREATURE_CHANCE", 5000);
        map.put((Object)"TALISMAN_ENRICHMENT_ATTACK_SPEED", 5000);
    });
    private static final Map<String, Map<String, Integer>> CATEGORIES = Map.of("Kat Items", CAT_KAT, "Upgrade Components", CAT_UPGRADE_COMPONENTS, "Sacks", CAT_SACKS, "Abiphone Supershop", CAT_ABIPHONE, "Dyes", CAT_DYES, "Stacking Enchants", CAT_ENCHANTS, "Enrichments", CAT_ENRICHMENTS);
    public static final BitsHelper INSTANCE = new BitsHelper();
    private final Map<String, ObjectLongImmutablePair<String>> categoryOutput = new HashMap<String, ObjectLongImmutablePair<String>>();
    private int bestSlotIndexSelling = -1;
    private int bestSlotIndexAll = -1;
    private boolean megamindInLogs = false;

    private BitsHelper() {
        super(TITLE_PATTERN);
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        BestItemsResult bestItemsResult = this.calculateBestItems(slots);
        this.bestSlotIndexSelling = bestItemsResult.bestSlotIndexSelling;
        this.bestSlotIndexAll = bestItemsResult.bestSlotIndexAll;
        if (this.bestSlotIndexSelling != -1 && this.bestSlotIndexSelling == this.bestSlotIndexAll) {
            highlights.add(ColorHighlight.green(this.bestSlotIndexSelling));
        } else {
            if (this.bestSlotIndexSelling != -1) {
                highlights.add(ColorHighlight.green(this.bestSlotIndexSelling));
            }
            if (this.bestSlotIndexAll != -1) {
                highlights.add(ColorHighlight.yellow(this.bestSlotIndexAll));
            }
        }
        return highlights;
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        String lore = ItemUtils.concatenateLore(lines);
        Matcher bitsMatcher = BITS_PATTERN.matcher(lore);
        long coinsPerBit = 0L;
        String itemID = "";
        boolean isGreen = false;
        if (focusedSlot == null) {
            return;
        }
        if (!CATEGORY_PATTERN.matcher(lore).find()) {
            if (!bitsMatcher.find()) {
                return;
            }
            long bitsCost = Long.parseLong(bitsMatcher.group("amount").replace(",", ""));
            double itemCost = ItemUtils.getItemPrice(stack).keyDouble() * (double)stack.method_7947();
            if (itemCost == 0.0) {
                return;
            }
            coinsPerBit = Math.round(itemCost / (double)bitsCost);
        } else {
            String outerKey = stack.method_7964().getString();
            BestItemsResult bestItemsResult = this.calculateBestItems(this.getSlots());
            this.bestSlotIndexSelling = bestItemsResult.bestSlotIndexSelling;
            this.bestSlotIndexAll = bestItemsResult.bestSlotIndexAll;
            if (this.bestSlotIndexSelling != -1 && this.bestSlotIndexSelling == focusedSlot.method_34266()) {
                isGreen = true;
            }
            ObjectLongPair innerMap = (ObjectLongPair)this.categoryOutput.get(outerKey);
            ObjectLongPair innerMapGreen = (ObjectLongPair)this.categoryOutput.get(outerKey + "GREEN");
            if (innerMap != null) {
                if (isGreen) {
                    itemID = (String)innerMapGreen.left();
                    coinsPerBit = innerMapGreen.rightLong();
                } else {
                    itemID = (String)innerMap.left();
                    coinsPerBit = innerMap.rightLong();
                }
            }
        }
        class_1799 foundItemStack = ItemRepository.getItemStack(itemID);
        if (itemID.isEmpty()) {
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Bits Cost: ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(Formatters.INTEGER_NUMBERS.format(coinsPerBit) + " Coins per bit")).method_27692(class_124.field_1062)));
        } else if (foundItemStack != null && isGreen) {
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Bits Cost: ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(Formatters.INTEGER_NUMBERS.format(coinsPerBit) + " Coins per bit")).method_27692(class_124.field_1062)));
            lines.add((class_2561)class_2561.method_43470((String)("From " + foundItemStack.method_7964().getString())).method_27692(class_124.field_1060));
        } else if (foundItemStack != null) {
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Bits Cost: ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(Formatters.INTEGER_NUMBERS.format(coinsPerBit) + " Coins per bit")).method_27692(class_124.field_1062)));
            lines.add((class_2561)class_2561.method_43470((String)("From " + foundItemStack.method_7964().getString())).method_27692(class_124.field_1062));
        } else {
            if (!stack.method_7964().getString().equals("Stacking Enchants")) {
                LOGGER.warn("[Skyblocker Bits Helper] ItemStack not found for {}", (Object)itemID);
            }
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Bits Cost: ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(Formatters.INTEGER_NUMBERS.format(coinsPerBit) + " Coins per bit")).method_27692(class_124.field_1062)));
            lines.add((class_2561)class_2561.method_43470((String)("From " + itemID)).method_27692(class_124.field_1062));
        }
    }

    private Int2ObjectMap<class_1799> getSlots() {
        class_310 client = class_310.method_1551();
        class_437 class_4372 = client.field_1755;
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            class_1703 handler = screen.method_17577();
            Int2ObjectOpenHashMap slots = new Int2ObjectOpenHashMap();
            for (int i = 0; i < handler.field_7761.size(); ++i) {
                slots.put(i, (Object)handler.method_7611(i).method_7677());
            }
            if (!this.megamindInLogs) {
                LOGGER.info("[Skyblocker Bits Helper] \t\t\tNo slots?\n\u2800\u28de\u28bd\u28aa\u28a3\u28a3\u28a3\u28ab\u287a\u2875\u28dd\u286e\u28d7\u28b7\u28bd\u28bd\u28bd\u28ee\u2877\u287d\u28dc\u28dc\u28ae\u28ba\u28dc\u28b7\u28bd\u289d\u287d\u28dd\n\u2838\u2878\u281c\u2815\u2815\u2801\u2881\u2887\u288f\u28bd\u28ba\u28ea\u2873\u285d\u28ce\u28cf\u28af\u289e\u287f\u28df\u28f7\u28f3\u28af\u2877\u28fd\u28bd\u28af\u28f3\u28eb\u2807\n\u2800\u2800\u2880\u2880\u2884\u28ac\u28aa\u286a\u284e\u28c6\u2848\u281a\u281c\u2815\u2807\u2817\u281d\u2895\u28af\u28ab\u28de\u28ef\u28ff\u28fb\u287d\u28cf\u2897\u28d7\u280f\u2800\n\u2800\u282a\u286a\u286a\u28ea\u28aa\u28ba\u28b8\u28a2\u2893\u2886\u28a4\u2880\u2800\u2800\u2800\u2800\u2808\u288a\u289e\u287e\u28ff\u286f\u28cf\u28ae\u2837\u2801\u2800\u2800\n\u2800\u2800\u2800\u2808\u280a\u2806\u2843\u2815\u2895\u2887\u2887\u2887\u2887\u2887\u288f\u288e\u288e\u2886\u2884\u2800\u2891\u28fd\u28ff\u289d\u2832\u2809\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u2800\u2800\u287f\u2802\u2820\u2800\u2847\u2887\u2815\u2888\u28c0\u2800\u2801\u2821\u2823\u2863\u286b\u28c2\u28ff\u282f\u28aa\u2830\u2802\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u2800\u2866\u2859\u2842\u2880\u28a4\u28a3\u2823\u2848\u28fe\u2843\u2820\u2804\u2800\u2844\u28b1\u28cc\u28f6\u288f\u288a\u2802\u2800\u2800\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u2800\u289d\u2872\u28dc\u286e\u284f\u288e\u288c\u2882\u2819\u2822\u2810\u2880\u2898\u28b5\u28fd\u28ff\u287f\u2801\u2801\u2800\u2800\u2800\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u2800\u2828\u28fa\u287a\u2855\u2855\u2871\u2851\u2846\u2855\u2845\u2855\u285c\u287c\u28bd\u287b\u280f\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u2800\u28fc\u28f3\u28eb\u28fe\u28f5\u28d7\u2875\u2871\u2861\u28a3\u2891\u2895\u289c\u2895\u285d\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u28f4\u28ff\u28fe\u28ff\u28ff\u28ff\u287f\u287d\u2851\u288c\u282a\u2862\u2863\u28e3\u285f\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u285f\u287e\u28ff\u28bf\u28bf\u28b5\u28fd\u28fe\u28fc\u28d8\u28b8\u28b8\u28de\u285f\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\n\u2800\u2800\u2800\u2800\u2801\u2807\u2821\u2829\u286b\u28bf\u28dd\u287b\u286e\u28d2\u28bd\u280b\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800\u2800");
                this.megamindInLogs = true;
            }
            return slots;
        }
        return null;
    }

    private BestItemsResult calculateBestItems(Int2ObjectMap<class_1799> slots) {
        class_1799 stack;
        long bestCoinsPerBitSelling = 0L;
        long bestCoinsPerBitAll = 0L;
        int bestSlotIndexSelling = -1;
        int bestSlotIndexAll = -1;
        if (slots == null || slots.isEmpty()) {
            return new BestItemsResult(bestSlotIndexSelling, bestSlotIndexAll, bestCoinsPerBitSelling, bestCoinsPerBitAll);
        }
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            stack = (class_1799)entry.getValue();
            if (stack == null || stack.method_7960() || !CATEGORY_PATTERN.matcher(ItemUtils.getConcatenatedLore(stack)).find()) continue;
            ObjectLongImmutablePair<String> categoryResults = this.calculateBestInCategory(stack);
            String itemID = (String)categoryResults.left();
            long coinsPerBit = categoryResults.rightLong();
            if (GOOD_SELLING_ITEMS.contains(itemID) && coinsPerBit > bestCoinsPerBitSelling) {
                bestCoinsPerBitSelling = coinsPerBit;
                bestSlotIndexSelling = entry.getIntKey();
            }
            if (coinsPerBit <= bestCoinsPerBitAll) continue;
            bestCoinsPerBitAll = coinsPerBit;
            bestSlotIndexAll = entry.getIntKey();
        }
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            stack = (class_1799)entry.getValue();
            if (stack == null || stack.method_7960()) continue;
            String itemId = stack.getSkyblockApiId();
            String lore = ItemUtils.getConcatenatedLore(stack);
            Matcher bitsMatcher = BITS_PATTERN.matcher(lore);
            if (!bitsMatcher.find()) continue;
            long bitsCost = Long.parseLong(bitsMatcher.group("amount").replace(",", ""));
            double itemCost = ItemUtils.getItemPrice(stack).keyDouble() * (double)stack.method_7947();
            if (itemCost == 0.0 || bitsCost == 0L) continue;
            long coinsPerBit = Math.round(itemCost / (double)bitsCost);
            if (GOOD_SELLING_ITEMS.contains(itemId) && coinsPerBit > bestCoinsPerBitSelling) {
                bestCoinsPerBitSelling = coinsPerBit;
                bestSlotIndexSelling = entry.getIntKey();
            }
            if (coinsPerBit <= bestCoinsPerBitAll) continue;
            bestCoinsPerBitAll = coinsPerBit;
            bestSlotIndexAll = entry.getIntKey();
        }
        return new BestItemsResult(bestSlotIndexSelling, bestSlotIndexAll, bestCoinsPerBitSelling, bestCoinsPerBitAll);
    }

    private ObjectLongImmutablePair<String> calculateBestInCategory(class_1799 stack) {
        long bestCoinsPerBitSelling = 0L;
        long bestCoinsPerBitAll = 0L;
        String catName = stack.method_7964().getString();
        this.categoryOutput.put(catName, (ObjectLongImmutablePair<String>)ObjectLongImmutablePair.of((Object)"", (long)0L));
        this.categoryOutput.put(catName + "GREEN", (ObjectLongImmutablePair<String>)ObjectLongImmutablePair.of((Object)"", (long)0L));
        Object2LongMap<String> categoryResults = this.processCategory(stack);
        for (Map.Entry categoryEntry : categoryResults.object2LongEntrySet()) {
            String itemID = (String)categoryEntry.getKey();
            long coinsPerBit = (Long)categoryEntry.getValue();
            if (GOOD_SELLING_ITEMS.contains(itemID) && coinsPerBit > bestCoinsPerBitSelling) {
                this.categoryOutput.put(catName + "GREEN", (ObjectLongImmutablePair<String>)ObjectLongImmutablePair.of((Object)itemID, (long)coinsPerBit));
                bestCoinsPerBitSelling = coinsPerBit;
            }
            if (coinsPerBit <= bestCoinsPerBitAll) continue;
            this.categoryOutput.put(catName, (ObjectLongImmutablePair<String>)ObjectLongImmutablePair.of((Object)itemID, (long)coinsPerBit));
            bestCoinsPerBitAll = coinsPerBit;
        }
        return this.categoryOutput.get(catName);
    }

    private Object2LongMap<String> processCategory(class_1799 stack) {
        String categoryName = stack.method_7964().getString();
        if (CATEGORIES.containsKey(categoryName)) {
            Object2LongOpenHashMap results = new Object2LongOpenHashMap();
            Map<String, Integer> category = CATEGORIES.get(categoryName);
            for (Map.Entry<String, Integer> entry : category.entrySet()) {
                String itemID = entry.getKey();
                Integer itemBitsPrice = entry.getValue();
                double itemCost = ItemUtils.getItemPrice(itemID).keyDouble();
                long coinsPerBit = Math.round(itemCost / (double)itemBitsPrice.intValue());
                results.put((Object)itemID, coinsPerBit);
            }
            return results;
        }
        if (categoryName.contains("Fuel Blocks")) {
            String itemID = "INFERNO_FUEL_BLOCK";
            int[] itemBitsPrice = new int[]{75, 3600};
            double itemCost = ItemUtils.getItemPrice(itemID).keyDouble();
            long coinsPerBit = (long)Math.max(itemCost / (double)itemBitsPrice[0], itemCost * 64.0 / (double)itemBitsPrice[1]);
            Object2LongOpenHashMap fuelBlockResult = new Object2LongOpenHashMap();
            fuelBlockResult.put((Object)itemID, coinsPerBit);
            return fuelBlockResult;
        }
        LOGGER.warn("[Skyblocker Bits Helper] Can't recognize category {} from bits shop! Consider reporting this to our discord!", (Object)categoryName);
        return new Object2LongOpenHashMap();
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().helpers.enableBitsTooltip;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private record BestItemsResult(int bestSlotIndexSelling, int bestSlotIndexAll, long bestCoinsPerBitSelling, long bestCoinsPerBitAll) {
    }
}

