/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.RegexUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jspecify.annotations.Nullable;

public class DateCalculatorTooltip
extends SimpleTooltipAdder {
    private static final Pattern TIMER_PATTERN = Pattern.compile("((?<days>\\d+)d)? ?((?<hours>\\d+)h)? ?((?<minutes>\\d+)m)? ?((?<seconds>\\d+)s)?");
    private Timer currentTimer;

    public DateCalculatorTooltip(int priority) {
        super(priority);
    }

    @Override
    public boolean test(class_437 screen) {
        for (Timer timer : Timer.values()) {
            Matcher matcher = timer.titlePattern.matcher(screen.method_25440().getString());
            if (!matcher.matches()) continue;
            this.currentTimer = timer;
            return true;
        }
        this.currentTimer = null;
        return false;
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (this.currentTimer == null) {
            return;
        }
        for (int i = 1; i < lines.size(); ++i) {
            MatchResult result;
            String text = lines.get(i).getString();
            if (!this.currentTimer.qualifier.test(text) || (result = (MatchResult)TIMER_PATTERN.matcher(text).results().filter(DateCalculatorTooltip::hasAnyGroup).findFirst().orElse(null)) == null) continue;
            Instant instant = Instant.now().plus((long)RegexUtils.parseOptionalIntFromMatcher(result, "days").orElse(0), ChronoUnit.DAYS).plus((long)RegexUtils.parseOptionalIntFromMatcher(result, "hours").orElse(0), ChronoUnit.HOURS).plus((long)RegexUtils.parseOptionalIntFromMatcher(result, "minutes").orElse(0), ChronoUnit.MINUTES).plusSeconds(RegexUtils.parseOptionalIntFromMatcher(result, "seconds").orElse(0)).plusSeconds(30L).truncatedTo(ChronoUnit.MINUTES);
            lines.add(++i, (class_2561)class_2561.method_43470((String)Formatters.DATE_FORMATTER.format(instant)).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
        }
    }

    private static boolean hasAnyGroup(MatchResult result) {
        for (String group : result.namedGroups().keySet()) {
            if (result.group(group) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().helpers.enableDateCalculator;
    }

    private static enum Timer {
        CALENDAR("(Calendar and Events|.*?, Year \\d+.*)", l -> l.contains("Starts in:") || l.contains(" ("));

        private final Pattern titlePattern;
        private final Predicate<String> qualifier;

        private Timer(String title, Predicate<String> qualifier) {
            this.titlePattern = Pattern.compile(title);
            this.qualifier = qualifier;
        }
    }
}

