/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import org.jspecify.annotations.Nullable;

public class DungeonQualityTooltip
extends SimpleTooltipAdder {
    public DungeonQualityTooltip(int priority) {
        super(priority);
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        boolean maxQuality;
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        if (customData == null || !customData.method_10545("baseStatBoostPercentage")) {
            return;
        }
        int baseStatBoostPercentage = customData.method_68083("baseStatBoostPercentage", 0);
        boolean bl = maxQuality = baseStatBoostPercentage == 50;
        if (maxQuality) {
            lines.add((class_2561)class_2561.method_43470((String)(String.format("%-17s", "Item Quality:") + baseStatBoostPercentage + "/50")).method_27692(class_124.field_1061).method_27692(class_124.field_1067));
        } else {
            lines.add((class_2561)class_2561.method_43470((String)(String.format("%-21s", "Item Quality:") + baseStatBoostPercentage + "/50")).method_27692(class_124.field_1078));
        }
        if (customData.method_10545("item_tier")) {
            int itemTier = customData.method_68083("item_tier", 0);
            if (maxQuality) {
                lines.add((class_2561)class_2561.method_43470((String)(String.format("%-17s", "Floor Tier:") + itemTier + " (" + this.getItemTierFloor(itemTier) + ")")).method_27692(class_124.field_1061).method_27692(class_124.field_1067));
            } else {
                lines.add((class_2561)class_2561.method_43470((String)(String.format("%-21s", "Floor Tier:") + itemTier + " (" + this.getItemTierFloor(itemTier) + ")")).method_27692(class_124.field_1078));
            }
        }
    }

    private String getItemTierFloor(int tier) {
        return switch (tier) {
            case 0 -> "E";
            case 1 -> "F1";
            case 2 -> "F2";
            case 3 -> "F3";
            case 4 -> "F4/M1";
            case 5 -> "F5/M2";
            case 6 -> "F6/M3";
            case 7 -> "F7/M4";
            case 8 -> "M5";
            case 9 -> "M6";
            case 10 -> "M7";
            default -> "Unknown";
        };
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemTooltip.dungeonQuality;
    }
}

