/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import org.jspecify.annotations.Nullable;

public class EvolvingItemProgressTooltip
extends SimpleTooltipAdder {
    final List<String> evolutionItems = List.of("DARK_CACAO_TRUFFLE", "MOBY_DUCK", "ROSEWATER_FLASK", "DISCRITE", "NEW_BOTTLE_OF_JYRRE", "TRAINING_WEIGHTS");

    public EvolvingItemProgressTooltip(int priority) {
        super(priority);
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (!this.evolutionItems.contains(stack.getSkyblockId())) {
            return;
        }
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        int secondsHeld = switch (stack.getSkyblockId()) {
            case "DISCRITE" -> customData.method_68083("rift_discrite_seconds", 0);
            case "NEW_BOTTLE_OF_JYRRE" -> customData.method_68083("bottle_of_jyrre_seconds", 0);
            case "TRAINING_WEIGHTS" -> customData.method_68083("trainingWeightsHeldTime", 0);
            default -> customData.method_68083("seconds_held", 0);
        };
        int maxSeconds = switch (stack.getSkyblockId()) {
            case "TRAINING_WEIGHTS" -> 330000;
            default -> 1080000;
        };
        lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)String.format("%-23s", "Age: ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format("%3.1f", Float.valueOf((float)secondsHeld / 3600.0f))).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format("%3.1fh ", Float.valueOf((float)maxSeconds / 3600.0f))).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"(").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format("%2.1f%%", 100.0 * (double)secondsHeld / (double)maxSeconds)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)));
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemTooltip.enableEvolvingItemProgress;
    }
}

