/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.hunting.Attributes;
import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import org.jspecify.annotations.Nullable;

public class HuntingBoxPriceTooltip
extends SimpleTooltipAdder {
    public HuntingBoxPriceTooltip(int priority) {
        super("^Hunting Box$", priority);
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (focusedSlot == null || focusedSlot.field_7874 > 53) {
            return;
        }
        Attribute attribute = Attributes.getAttributeFromItemName((class_9322)stack);
        if (attribute != null && TooltipInfoType.BAZAAR.hasOrNullWarning(attribute.apiId())) {
            int count = ItemUtils.getItemCountInHuntingBox(stack).orElse(1);
            BazaarProduct product = (BazaarProduct)TooltipInfoType.BAZAAR.getData().get((Object)attribute.apiId());
            boolean holdingShift = HudHelper.hasShiftDown();
            String shardText = count > 1 ? "Shards" : "Shard";
            lines.add((class_2561)class_2561.method_43470((String)(shardText + " Sell Price: ")).method_27692(class_124.field_1065).method_10852((class_2561)(product.sellPrice().isEmpty() ? class_2561.method_43470((String)"No data").method_27692(class_124.field_1061) : ItemTooltip.getCoinsMessage(product.sellPrice().getAsDouble() * (double)count, holdingShift ? count : 1, true))));
        }
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().hunting.huntingBox.enabled;
    }
}

