/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.museum.MuseumItemCache;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jspecify.annotations.Nullable;

public class MuseumTooltip
extends SimpleTooltipAdder {
    public MuseumTooltip(int priority) {
        super(priority);
    }

    @Override
    public boolean isEnabled() {
        return TooltipInfoType.MUSEUM.isTooltipEnabled();
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        String internalID = stack.getSkyblockId();
        if (TooltipInfoType.MUSEUM.hasOrNullWarning(internalID)) {
            String format;
            String itemCategory;
            switch (itemCategory = TooltipInfoType.MUSEUM.getData().get(internalID)) {
                case "Weapons": {
                    String string = "%-18s";
                    break;
                }
                case "Armor": {
                    String string = "%-19s";
                    break;
                }
                default: {
                    String string = format = "%-20s";
                }
            }
            if (itemCategory.equals("Special")) {
                lines.add((class_2561)class_2561.method_43470((String)String.format(format, "Museum: (" + itemCategory + ")")).method_27692(class_124.field_1076));
            } else {
                boolean isInMuseum = MuseumItemCache.hasItemInMuseum(internalID);
                class_124 donatedIndicatorFormatting = isInMuseum ? class_124.field_1060 : class_124.field_1061;
                lines.add((class_2561)class_2561.method_43470((String)String.format(format, "Museum (" + itemCategory + "):")).method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)(isInMuseum ? "\u2714" : "\u2716")).method_27695(new class_124[]{donatedIndicatorFormatting, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)(isInMuseum ? " Donated" : " Not Donated")).method_27692(donatedIndicatorFormatting)));
            }
        }
    }
}

