/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.ItemUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2503;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ObtainedDateTooltip
extends SimpleTooltipAdder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateTimeFormatter OBTAINED_DATE_FORMATTER = DateTimeFormatter.ofPattern("MMMM d, yyyy").withZone(ZoneId.systemDefault()).localizedBy(Locale.ENGLISH);
    private static final DateTimeFormatter OLD_OBTAINED_DATE_FORMAT = DateTimeFormatter.ofPattern("M/d/yy h:m a").withZone(ZoneId.of("UTC")).localizedBy(Locale.ENGLISH);

    public ObtainedDateTooltip(int priority) {
        super(priority);
    }

    @Override
    public boolean isEnabled() {
        return TooltipInfoType.OBTAINED.isTooltipEnabled();
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        String timestamp = ObtainedDateTooltip.getTimestamp(stack);
        if (!timestamp.isEmpty()) {
            lines.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)String.format("%-21s", "Obtained: ")).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)timestamp).method_27692(class_124.field_1061)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TemporalAccessor getTimestampInternal(class_1799 stack) {
        Object value;
        class_2520 class_25202;
        class_2503 class_25032;
        Object object;
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        if (customData != null && (object = customData.method_10580("timestamp")) instanceof class_2503) {
            long l;
            class_25032 = (class_2503)object;
            long value2 = l = class_25032.comp_3821();
            return Instant.ofEpochMilli(value2);
        }
        if (customData == null || !((class_25202 = customData.method_10580("timestamp")) instanceof class_2519)) return null;
        class_25032 = (class_2519)class_25202;
        try {
            value = object = class_25032.comp_3831();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        try {
            return OLD_OBTAINED_DATE_FORMAT.parse((CharSequence)value);
        }
        catch (DateTimeParseException e) {
            LOGGER.error("[Skyblocker ObtainedDateTooltip] Failed to parse date: {}", value, (Object)e);
        }
        return null;
    }

    public static String getTimestamp(class_1799 stack) {
        TemporalAccessor accessor = ObtainedDateTooltip.getTimestampInternal(stack);
        return accessor != null ? OBTAINED_DATE_FORMATTER.format(accessor) : "";
    }

    public static long getLongTimestamp(class_1799 stack) {
        TemporalAccessor accessor = ObtainedDateTooltip.getTimestampInternal(stack);
        return accessor != null ? Instant.from(accessor).toEpochMilli() : 0L;
    }
}

