/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.adders;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.tooltip.SimpleTooltipAdder;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9322;
import org.jspecify.annotations.Nullable;

public class StackingEnchantProgressTooltip
extends SimpleTooltipAdder {
    private static final Set<String> STACKING_ENCHANT_IDS = Set.of("expertise", "compact", "cultivating", "champion", "hecatomb", "absorb", "toxophilite");
    private static final StackingEnchantInfo EXPERTISE_INFO = new StackingEnchantInfo("Expertise", "expertise_kills", "kills", 0, 50, 100, 250, 500, 1000, 2500, 5500, 10000, 15000);
    private static final StackingEnchantInfo COMPACT_INFO = new StackingEnchantInfo("Compact", "compact_blocks", "blocks", 0, 100, 500, 1500, 5000, 15000, 50000, 150000, 500000, 1000000);
    private static final StackingEnchantInfo CULTIVATING_INFO = new StackingEnchantInfo("Cultivating", "farmed_cultivating", "crops", 0, 1000, 5000, 25000, 100000, 300000, 1500000, 5000000, 20000000, 100000000);
    private static final StackingEnchantInfo CHAMPION_INFO = new StackingEnchantInfo("Champion", "champion_combat_xp", "Combat XP", 0, 50000, 100000, 250000, 500000, 1000000, 1500000, 2000000, 2500000, 3000000);
    private static final StackingEnchantInfo HECATOMB_INFO = new StackingEnchantInfo("Hecatomb", "hecatomb_s_runs", "S runs", 0, 2, 5, 10, 20, 30, 40, 60, 80, 100);
    private static final StackingEnchantInfo ABSORB_INFO = new StackingEnchantInfo("Absorb", "absorb_logs_chopped", "logs", 0, 1000, 5000, 25000, 100000, 300000, 1500000, 5000000, 25000000, 50000000);
    private static final StackingEnchantInfo TOXOPHILITE_INFO = new StackingEnchantInfo("Toxophilite", "toxophilite_combat_xp", "Combat XP", 0, 50000, 100000, 250000, 500000, 1000000, 1500000, 2000000, 2500000, 3000000);

    public StackingEnchantProgressTooltip(int priority) {
        super(priority);
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        class_2487 customData = ItemUtils.getCustomData((class_9322)stack);
        if (customData.method_10545("enchantments")) {
            class_2487 enchantments = customData.method_68568("enchantments");
            StackingEnchantInfo stackingEnchantInfo = null;
            int stackingEnchantLevel = 0;
            for (String enchantment : enchantments.method_10541()) {
                if (!STACKING_ENCHANT_IDS.contains(enchantment)) continue;
                stackingEnchantInfo = switch (enchantment) {
                    case "expertise" -> EXPERTISE_INFO;
                    case "compact" -> COMPACT_INFO;
                    case "cultivating" -> CULTIVATING_INFO;
                    case "champion" -> CHAMPION_INFO;
                    case "hecatomb" -> HECATOMB_INFO;
                    case "absorb" -> ABSORB_INFO;
                    case "toxophilite" -> TOXOPHILITE_INFO;
                    default -> throw new IllegalStateException("Unexpected stacking enchant: " + enchantment);
                };
                stackingEnchantLevel = enchantments.method_68083(enchantment, 0);
                break;
            }
            if (stackingEnchantInfo != null && stackingEnchantLevel > 0 && stackingEnchantLevel < 10) {
                int progress = customData.method_68083(stackingEnchantInfo.field(), 0);
                int needed = stackingEnchantInfo.ladder()[stackingEnchantLevel];
                class_5250 text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)(stackingEnchantInfo.name() + " ")).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + (stackingEnchantLevel + 1))).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(progress)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(needed)).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(" " + stackingEnchantInfo.unit())).method_27692(class_124.field_1080));
                lines.add((class_2561)text);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().general.itemTooltip.enableStackingEnchantProgress;
    }

    private record StackingEnchantInfo(String name, String field, String unit, int[] ladder) {
        StackingEnchantInfo {
            if (ladder.length != 10) {
                throw new IllegalStateException("Ladder must have 10 entries but had only " + ladder.length + "!");
            }
        }
    }
}

