/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.info;

import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.config.configs.GeneralConfig;
import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.info.DataTooltipInfoType;
import de.hysky.skyblocker.skyblock.item.tooltip.info.SimpleTooltipInfo;
import de.hysky.skyblocker.utils.Http;
import java.net.http.HttpHeaders;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

public final class DataTooltipInfo<T>
extends SimpleTooltipInfo
implements DataTooltipInfoType<T> {
    private final String address;
    private final Codec<T> codec;
    private @Nullable T data;
    private final boolean cacheable;
    private long hash;
    private final BiPredicate<T, String> contains;
    private final Predicate<GeneralConfig.ItemTooltip> dataEnabled;
    private final @Nullable Consumer<T>[] callbacks;

    @SafeVarargs
    protected DataTooltipInfo(String address, Codec<T> codec, boolean cacheable, BiPredicate<T, String> contains, Predicate<GeneralConfig.ItemTooltip> tooltipEnabled, Predicate<GeneralConfig.ItemTooltip> dataEnabled, Consumer<T> ... callbacks) {
        super(tooltipEnabled);
        this.address = address;
        this.codec = codec;
        this.cacheable = cacheable;
        this.contains = contains;
        this.dataEnabled = dataEnabled;
        this.callbacks = callbacks;
    }

    @Override
    public boolean isDataEnabled() {
        return this.dataEnabled.test(ItemTooltip.config.get());
    }

    @Override
    public @Nullable T getData() {
        return this.data;
    }

    @Override
    public Codec<T> getCodec() {
        return this.codec;
    }

    @Override
    public boolean hasOrNullWarning(String memberName) {
        if (this.data == null) {
            ItemTooltip.nullWarning();
            return false;
        }
        return this.contains.test(this.data, memberName);
    }

    @Override
    public void run() {
        try {
            String response;
            if (this.cacheable) {
                HttpHeaders headers = Http.sendHeadRequest(this.address);
                long hash = Http.getEtag(headers).hashCode() + Http.getLastModified(headers).hashCode();
                if (this.hash == hash) {
                    return;
                }
                this.hash = hash;
            }
            if ((response = Http.sendGetRequest(this.address)).trim().startsWith("<!DOCTYPE") || response.trim().startsWith("<html")) {
                ItemTooltip.LOGGER.warn("[Skyblocker] Received HTML content for {}. Expected JSON.", (Object)this.address);
                return;
            }
            this.data = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(response)).getOrThrow();
            if (this.callbacks != null) {
                for (Consumer<T> callback : this.callbacks) {
                    callback.accept(this.data);
                }
            }
        }
        catch (Exception e) {
            ItemTooltip.LOGGER.warn("[Skyblocker] Failed to download {} data!", (Object)this.address, (Object)e);
        }
    }
}

