/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.tooltip.info;

import com.mojang.serialization.Codec;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.GeneralConfig;
import de.hysky.skyblocker.skyblock.accessories.AccessoriesHelper;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.EssenceShopPrice;
import de.hysky.skyblocker.skyblock.item.tooltip.info.DataTooltipInfo;
import de.hysky.skyblocker.skyblock.item.tooltip.info.DataTooltipInfoType;
import de.hysky.skyblocker.skyblock.item.tooltip.info.SimpleTooltipInfo;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface TooltipInfoType {
    public static final DataTooltipInfoType<Object2DoubleMap<String>> NPC = TooltipInfoType.ofData("https://hysky.de/api/npcprice", CodecUtils.object2DoubleMapCodec(Codec.STRING), true, Object2DoubleMap::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableNPCPrice, new Consumer[0]);
    public static final DataTooltipInfoType<Object2ObjectMap<String, BazaarProduct>> BAZAAR = TooltipInfoType.ofData("https://hysky.de/api/bazaar", BazaarProduct.MAP_CODEC, false, Object2ObjectMap::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableBazaarPrice, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableBazaarPrice || itemTooltip.enableCraftingCost != GeneralConfig.Craft.OFF || itemTooltip.enableEstimatedItemValue || TooltipInfoType.getConfig().dungeons.dungeonChestProfit.enableProfitCalculator || TooltipInfoType.getConfig().dungeons.dungeonChestProfit.croesusProfit || TooltipInfoType.getConfig().uiAndVisuals.chestValue.enableChestValue || SkyblockerConfigManager.get().helpers.enableBitsTooltip || itemTooltip.showEssenceCost, EssenceShopPrice::refreshEssencePrices);
    public static final DataTooltipInfoType<Object2DoubleMap<String>> LOWEST_BINS = TooltipInfoType.ofData("https://hysky.de/api/auctions/lowestbins", CodecUtils.object2DoubleMapCodec(Codec.STRING), false, Object2DoubleMap::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableLowestBIN, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableLowestBIN || itemTooltip.enableCraftingCost != GeneralConfig.Craft.OFF || itemTooltip.enableEstimatedItemValue || TooltipInfoType.getConfig().dungeons.dungeonChestProfit.enableProfitCalculator || TooltipInfoType.getConfig().dungeons.dungeonChestProfit.croesusProfit || TooltipInfoType.getConfig().uiAndVisuals.chestValue.enableChestValue || SkyblockerConfigManager.get().helpers.enableBitsTooltip, new Consumer[0]);
    public static final DataTooltipInfoType<Object2DoubleMap<String>> ONE_DAY_AVERAGE = TooltipInfoType.ofData("https://hysky.de/api/auctions/lowestbins/average/1day.json", CodecUtils.object2DoubleMapCodec(Codec.STRING), false, Object2DoubleMap::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableAvgBIN, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableAvgBIN && itemTooltip.avg != GeneralConfig.Average.THREE_DAY, new Consumer[0]);
    public static final DataTooltipInfoType<Object2DoubleMap<String>> THREE_DAY_AVERAGE = TooltipInfoType.ofData("https://hysky.de/api/auctions/lowestbins/average/3day.json", CodecUtils.object2DoubleMapCodec(Codec.STRING), false, Object2DoubleMap::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableAvgBIN, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableAvgBIN && itemTooltip.avg != GeneralConfig.Average.ONE_DAY || TooltipInfoType.getConfig().uiAndVisuals.searchOverlay.enableAuctionHouse, new Consumer[0]);
    public static final DataTooltipInfoType<Object2IntMap<String>> MOTES = TooltipInfoType.ofData("https://hysky.de/api/motesprice", CodecUtils.object2IntMapCodec(Codec.STRING), true, Object2IntMap::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableMotesPrice, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableMotesPrice && Utils.isInTheRift(), new Consumer[0]);
    public static final TooltipInfoType OBTAINED = TooltipInfoType.ofSimple(itemTooltip -> itemTooltip.enableObtainedDate);
    public static final DataTooltipInfoType<Map<String, String>> MUSEUM = TooltipInfoType.ofData("https://hysky.de/api/museum", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), true, Map::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableMuseumInfo, new Consumer[0]);
    public static final DataTooltipInfoType<Map<String, String>> COLOR = TooltipInfoType.ofData("https://hysky.de/api/color", Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING), true, Map::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableExoticTooltip, new Consumer[0]);
    public static final DataTooltipInfoType<Map<String, AccessoriesHelper.Accessory>> ACCESSORIES = TooltipInfoType.ofData("https://hysky.de/api/accessories", AccessoriesHelper.Accessory.MAP_CODEC, true, Map::containsKey, (GeneralConfig.ItemTooltip itemTooltip) -> itemTooltip.enableAccessoriesHelper, AccessoriesHelper::refreshData);
    public static final TooltipInfoType ESTIMATED_ITEM_VALUE = TooltipInfoType.ofSimple(itemTooltip -> itemTooltip.enableEstimatedItemValue);

    public boolean isTooltipEnabled();

    private static SkyblockerConfig getConfig() {
        return SkyblockerConfigManager.get();
    }

    private static TooltipInfoType ofSimple(Predicate<GeneralConfig.ItemTooltip> tooltipEnabled) {
        return new SimpleTooltipInfo(tooltipEnabled);
    }

    @SafeVarargs
    private static <T> DataTooltipInfoType<T> ofData(String address, Codec<T> codec, boolean cacheable, BiPredicate<T, String> contains, Predicate<GeneralConfig.ItemTooltip> tooltipEnabled, Consumer<T> ... callbacks) {
        return TooltipInfoType.ofData(address, codec, cacheable, contains, tooltipEnabled, tooltipEnabled, callbacks);
    }

    @SafeVarargs
    private static <T> DataTooltipInfoType<T> ofData(String address, Codec<T> codec, boolean cacheable, BiPredicate<T, String> contains, Predicate<GeneralConfig.ItemTooltip> tooltipEnabled, Predicate<GeneralConfig.ItemTooltip> dataEnabled, Consumer<T> ... callbacks) {
        return new DataTooltipInfo<T>(address, codec, cacheable, contains, tooltipEnabled, dataEnabled, callbacks);
    }
}

