/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.wikilookup;

import com.mojang.datafixers.util.Either;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookup;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import org.jspecify.annotations.Nullable;

public class PetItemLookup
implements WikiLookup {
    private static final Pattern PET_ITEM_NAME = Pattern.compile("^\\[Lvl \\d+] (?<name>.+)$");
    private static final Function<String, Matcher> PET_MATCHER = itemName -> PET_ITEM_NAME.matcher(itemName + " Pet");
    private static final Predicate<class_1799> PET_ITEM_FILTER = itemStack -> {
        String itemName = itemStack.method_7964().getString();
        PetInfo petInfo = itemStack.getPetInfo();
        return !petInfo.isEmpty() || itemName.matches(PET_ITEM_NAME.pattern());
    };
    public static final PetItemLookup INSTANCE = new PetItemLookup();

    private PetItemLookup() {
    }

    @Override
    public void open(class_1799 itemStack, class_1657 player, boolean useOfficial) {
        String itemName = itemStack.method_7964().getString();
        PetInfo petInfo = itemStack.getPetInfo();
        PetItemLookup.lookupPetItem(PET_MATCHER.apply(petInfo.name().orElse(itemName)), player, useOfficial);
    }

    @Override
    public boolean canSearch(@Nullable String title, Either<class_1735, class_1799> either) {
        class_1799 itemStack = WikiLookupManager.mapEitherToItemStack(either);
        return PET_ITEM_FILTER.test(itemStack);
    }

    private static void lookupPetItem(Matcher matcher, class_1657 player, boolean useOfficial) {
        if (matcher.matches()) {
            String petName = (String)REPLACING_FUNCTION.apply(matcher.group("name").trim());
            WikiLookupManager.openWikiLinkName(petName, player, useOfficial);
        }
    }
}

